/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.slash.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import java.util.List;
import java.util.regex.MatchResult;
import net.itsthesky.disky.elements.structures.slash.StructSlashCommand;
import net.itsthesky.disky.elements.structures.slash.models.ParsedArgument;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExprSlashArgument
extends SimpleExpression<Object> {
    private ParsedArgument arg;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        if (!this.getParser().isCurrentStructure(StructSlashCommand.class)) {
            return false;
        }
        List<ParsedArgument> currentArguments = ((StructSlashCommand)this.getParser().getCurrentStructure()).getParsedCommand().getArguments();
        if (currentArguments.isEmpty()) {
            Skript.error((String)"This command doesn't have any arguments", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        ParsedArgument arg = null;
        switch (matchedPattern) {
            case 0: {
                arg = currentArguments.get(currentArguments.size() - 1);
                break;
            }
            case 1: 
            case 2: {
                int i = Utils.parseInt((String)((MatchResult)parser.regexes.get(0)).group(1));
                if (i > currentArguments.size()) {
                    Skript.error((String)("The command doesn't have a " + StringUtils.fancyOrderNumber((int)i) + " argument"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    return false;
                }
                arg = currentArguments.get(i - 1);
                break;
            }
            case 3: {
                if (currentArguments.size() == 1) {
                    arg = currentArguments.get(0);
                    break;
                }
                Skript.error((String)"'argument(s)' cannot be used if the command has multiple arguments. Use 'argument 1', 'argument 2', etc. instead", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
            case 4: 
            case 5: {
                ClassInfo c = (ClassInfo)((Literal)exprs[0]).getSingle();
                int num = parser.regexes.size() > 0 ? Utils.parseInt((String)((MatchResult)parser.regexes.get(0)).group()) : -1;
                int j = 1;
                for (ParsedArgument a : currentArguments) {
                    if (!c.getC().isAssignableFrom(a.getTypeInfo().getC())) continue;
                    if (arg != null) {
                        Skript.error((String)("There are multiple " + String.valueOf(c) + " arguments in this command"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                        return false;
                    }
                    if (j < num) {
                        ++j;
                        continue;
                    }
                    arg = a;
                    if (j != num) continue;
                    break;
                }
                if (arg != null) break;
                if (num == -1 || --j == 0) {
                    Skript.error((String)("There is no " + String.valueOf(c) + " argument in this command"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                } else if (j == 1) {
                    Skript.error((String)("There is only one " + String.valueOf(c) + " argument in this command"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                } else {
                    Skript.error((String)("There are only " + j + " " + String.valueOf(c) + " arguments in this command"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                }
                return false;
            }
            default: {
                assert (false) : matchedPattern;
                return false;
            }
        }
        assert (arg != null);
        this.arg = arg;
        return true;
    }

    protected Object @NotNull [] get(@NotNull Event e) {
        Object value = this.arg.getValue();
        if (value == null) {
            return new Object[0];
        }
        return new Object[]{value};
    }

    @NotNull
    public Class<?> getReturnType() {
        return this.arg.getTypeInfo().getC();
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return "the " + StringUtils.fancyOrderNumber((int)1) + " argument";
        }
        return Classes.getDebugMessage((Object)this.getArray(e));
    }

    public boolean isSingle() {
        return true;
    }

    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("argument");
    }

    static {
        Skript.registerExpression(ExprSlashArgument.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[][the] last arg[ument][s]", "[][the] arg[ument][s](-| )<(\\d+)>", "[][the] <(\\d*1)st|(\\d*2)nd|(\\d*3)rd|(\\d*[4-90])th> arg[ument][s]", "[][the] arg[ument][s]", "[][the] %*classinfo%( |-)arg[ument][( |-)<\\d+>]", "[][the] arg[ument]( |-)%*classinfo%[( |-)<\\d+>]"});
    }
}

