/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.managers;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import net.itsthesky.disky.DiSky;
import org.bukkit.configuration.file.YamlConfiguration;

public final class ConfigManager {
    private static final String CONFIG_FILE = "config.yml";
    private static YamlConfiguration CONFIG;

    public static void loadConfig(DiSky instance) {
        int currentVersion;
        File localConfig = new File(instance.getDataFolder(), CONFIG_FILE);
        if (!localConfig.exists()) {
            instance.saveResource(CONFIG_FILE, false);
        }
        YamlConfiguration localYaml = YamlConfiguration.loadConfiguration((File)localConfig);
        YamlConfiguration defaultYaml = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(instance.getResource(CONFIG_FILE)));
        int localVersion = localYaml.getInt("version", 1);
        if (localVersion < (currentVersion = defaultYaml.getInt("version", 1))) {
            instance.getLogger().info("Your configuration file is outdated! (v" + localVersion + " -> v" + currentVersion + ")");
            ConfigManager.updateConfig(instance, localYaml);
        }
        CONFIG = localYaml;
    }

    private static void updateConfig(DiSky instance, YamlConfiguration local) {
        instance.saveResource(CONFIG_FILE, true);
        YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)new File(instance.getDataFolder(), CONFIG_FILE));
        for (String key : newConfig.getKeys(true)) {
            if (local.contains(key)) continue;
            local.set(key, newConfig.get(key));
        }
        try {
            local.save(new File(instance.getDataFolder(), CONFIG_FILE));
            instance.getLogger().info("Configuration file updated successfully!");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void reloadConfig(DiSky instance) {
        File localConfig = new File(instance.getDataFolder(), CONFIG_FILE);
        if (!localConfig.exists()) {
            instance.saveResource(CONFIG_FILE, false);
        }
        CONFIG = YamlConfiguration.loadConfiguration((File)localConfig);
    }

    public static <T> T get(String path, T def) {
        return (T)CONFIG.get(path, def);
    }

    public static List<Integer> getIgnoredCodes() {
        return CONFIG.getIntegerList("ignored-codes");
    }
}

