/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.managers;

import java.util.TreeMap;
import java.util.WeakHashMap;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.MessageUpdateEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.managers.wrappers.MessageWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageManager
extends ListenerAdapter {
    private static final WeakHashMap<String, MessageManager> loadedManagers = new WeakHashMap();
    private final TreeMap<Long, MessageWrapper> deletedMessageCache = new TreeMap();
    private final TreeMap<Long, EditedMessageInfo> editedMessageCache = new TreeMap();

    @NotNull
    public static MessageManager getManager(JDA bot) {
        @Nullable MessageManager manager = loadedManagers.getOrDefault(bot.getSelfUser().getId(), null);
        if (manager == null) {
            throw new NullPointerException("The bot " + bot.getSelfUser().getAsTag() + " is not loaded!");
        }
        return manager;
    }

    public MessageManager(Bot bot) {
        loadedManagers.put(bot.getInstance().getSelfUser().getId(), this);
    }

    @Override
    public void onMessageReceived(@NotNull MessageReceivedEvent event) {
        this.insert(event.getMessage());
    }

    @Override
    public void onMessageUpdate(@NotNull MessageUpdateEvent event) {
        this.update(event.getMessage());
    }

    private void insert(Message message2) {
        if (!message2.isFromGuild()) {
            return;
        }
        long id = message2.getIdLong();
        this.editedMessageCache.put(id, new EditedMessageInfo(message2));
        this.deletedMessageCache.put(id, new MessageWrapper(message2));
        DiSky.debug("Caching message with id " + id + ": " + String.valueOf(this.deletedMessageCache.get(id)));
    }

    private void update(Message message2) {
        EditedMessageInfo info = this.editedMessageCache.getOrDefault(message2.getIdLong(), null);
        if (info == null) {
            return;
        }
        info.setPreviousContent(info.getCurrentContent());
        info.setCurrentContent(message2.getContentRaw());
        this.editedMessageCache.put(message2.getIdLong(), info);
        this.deletedMessageCache.put(message2.getIdLong(), new MessageWrapper(message2));
    }

    @Nullable
    public Message getDeletedMessage(long id) {
        if (!this.deletedMessageCache.containsKey(id)) {
            DiSky.debug("Message with id " + id + " is not in deleted cache.");
        }
        return this.deletedMessageCache.getOrDefault(id, null);
    }

    @Nullable
    public EditedMessageInfo getEditedMessage(long id) {
        return this.editedMessageCache.getOrDefault(id, null);
    }

    @Nullable
    public String getEditedMessageOldContent(long id) {
        @Nullable EditedMessageInfo info = this.getEditedMessage(id);
        return info == null ? null : info.getPreviousContent();
    }

    @Nullable
    public String getDeletedMessageContent(long id) {
        @Nullable Message info = this.getDeletedMessage(id);
        return info == null ? null : info.getContentRaw();
    }

    public static class EditedMessageInfo {
        private String previousContent;
        private String currentContent;

        public EditedMessageInfo(Message original) {
            this.previousContent = original.getContentRaw();
            this.currentContent = original.getContentRaw();
        }

        public String getPreviousContent() {
            return this.previousContent;
        }

        public void setPreviousContent(String previousContent) {
            this.previousContent = previousContent;
        }

        public String getCurrentContent() {
            return this.currentContent;
        }

        public void setCurrentContent(String currentContent) {
            this.currentContent = currentContent;
        }
    }
}

