/*
 * Decompiled with CFR 0.152.
 */
package online.andrew2007.mythic.config;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import online.andrew2007.mythic.MythicWorldTweaks;
import online.andrew2007.mythic.config.ConfigLoader;

public class ConfigFileListener {
    private static ListenerThread listenerThread = null;

    public static void initiateListener() {
        if (listenerThread != null) {
            throw new IllegalStateException("A listener thread has already been running.");
        }
        listenerThread = new ListenerThread();
        listenerThread.start();
        MythicWorldTweaks.LOGGER.info("Config listener started!");
    }

    public static void stopListener() {
        if (listenerThread == null) {
            throw new IllegalStateException("No listener thread is running.");
        }
        ConfigFileListener.listenerThread.shouldRun = false;
        listenerThread.interrupt();
        listenerThread = null;
        MythicWorldTweaks.LOGGER.info("Config listener stopped!");
    }

    private static void onEventTriggered(Path fileName) {
        String stringFileName = fileName.toString();
        if (stringFileName.startsWith("config.json")) {
            try {
                MythicWorldTweaks.LOGGER.info("Config file change detected, starting hot update process. The listener will cool down for 3000 ms.");
                ConfigLoader.onConfigHotUpdate();
            }
            catch (Exception e) {
                MythicWorldTweaks.LOGGER.error("Error doing hot update", (Throwable)e);
            }
        }
    }

    private static class ListenerThread
    extends Thread {
        boolean shouldRun = true;
        long lastTriggeredTime = 0L;

        public ListenerThread() {
            super("Config File Listener");
        }

        @Override
        public void run() {
            Path configDir = Paths.get(System.getProperty("user.dir") + "/config/mythicworldtweaks", new String[0]);
            try (WatchService watchService = FileSystems.getDefault().newWatchService();){
                configDir.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                while (this.shouldRun) {
                    try {
                        WatchKey watchKey = watchService.take();
                        for (WatchEvent<?> event : watchKey.pollEvents()) {
                            WatchEvent.Kind<?> watchEventKind = event.kind();
                            if (watchEventKind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                            WatchEvent<?> modifyEvent = event;
                            Path fileName = (Path)modifyEvent.context();
                            if (this.lastTriggeredTime + 3000L >= System.currentTimeMillis()) continue;
                            this.lastTriggeredTime = System.currentTimeMillis();
                            ConfigFileListener.onEventTriggered(fileName);
                        }
                        if (watchKey.reset()) continue;
                    }
                    catch (InterruptedException e) {
                        if (this.shouldRun) continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

