/*
 * Decompiled with CFR 0.152.
 */
package online.andrew2007.mythic.config;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import online.andrew2007.mythic.MythicWorldTweaks;
import online.andrew2007.mythic.config.ConfigFileListener;
import online.andrew2007.mythic.config.RuntimeController;
import online.andrew2007.mythic.config.patterns.ModConfig;
import online.andrew2007.mythic.misc.EnvironmentDetection;
import online.andrew2007.mythic.misc.LocalToaster;
import org.jetbrains.annotations.NotNull;

public class ConfigLoader {
    private static final Timer notifier = new Timer(true);
    private static boolean initState = false;
    private static ImmutableBiMap<class_2960, class_1792> allItems;
    private static ImmutableBiMap<class_2960, class_6880<class_1291>> allStatusEffects;
    private static ImmutableSet<String> allModIds;
    private static boolean isItemEditorParserReady;
    private static MinecraftServer currentServer;
    private static boolean isDuringServerRuntime;
    private static volatile ModConfig currentModConfig;
    private static boolean notifierRunning;
    private static TimerTask notifierTask;

    public static void onServerStarting(MinecraftServer server) {
        ConfigLoader.tryConfigSystemInit();
        currentServer = server;
        isDuringServerRuntime = true;
        RuntimeController.loadTransmittableParamsFromConfig(true);
    }

    public static void onServerStopping() {
        currentServer = null;
        isDuringServerRuntime = false;
        if (!EnvironmentDetection.isPhyClient) {
            ConfigFileListener.stopListener();
        }
    }

    public static void tryConfigSystemInit() throws RuntimeException {
        if (!initState) {
            MythicWorldTweaks.LOGGER.info("MythicWorldTweaks' config system starts to be initialized!");
            initState = true;
            ImmutableBiMap.Builder itemMapBuilder = ImmutableBiMap.builder();
            for (Object item : class_7923.field_41178) {
                itemMapBuilder.put((Object)class_7923.field_41178.method_10221(item), item);
            }
            allItems = itemMapBuilder.build();
            ImmutableBiMap.Builder effectMapBuilder = ImmutableBiMap.builder();
            for (class_1291 statusEffect : class_7923.field_41174) {
                effectMapBuilder.put((Object)Objects.requireNonNull(class_7923.field_41174.method_10221((Object)statusEffect), "Error initializing config system!"), (Object)class_7923.field_41174.method_47983((Object)statusEffect));
            }
            allStatusEffects = effectMapBuilder.build();
            isItemEditorParserReady = true;
            ImmutableSet.Builder modIdSetBuilder = ImmutableSet.builder();
            FabricLoader fabricLoader = FabricLoader.getInstance();
            fabricLoader.getAllMods().forEach(modContainer -> modIdSetBuilder.add((Object)modContainer.getMetadata().getId()));
            allModIds = modIdSetBuilder.build();
            try {
                ConfigLoader.tryPlaceDefaultConfigFile(true);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create default config file.");
            }
            try {
                currentModConfig = ConfigLoader.getConfigObject();
            }
            catch (RuntimeException e) {
                MythicWorldTweaks.LOGGER.error("Unable to load config on startup, Minecraft is shutting down.");
                throw e;
            }
            if (RuntimeController.getLocalRuntimeParams().modEnabled()) {
                ConfigFileListener.initiateListener();
            }
        }
    }

    public static synchronized void onConfigHotUpdate() {
        if (notifierRunning) {
            notifierTask.cancel();
            notifierRunning = false;
            notifierTask = null;
        }
        try {
            currentModConfig = ConfigLoader.getConfigObject();
            MythicWorldTweaks.LOGGER.info("Successfully parsed hot updating config.");
        }
        catch (RuntimeException e) {
            MythicWorldTweaks.LOGGER.error("Failed to parse hot updating config, current config won't change, please try editing it again.", (Throwable)e);
            if (EnvironmentDetection.isPhyClient && !notifierRunning) {
                notifierTask = new TimerTask(){

                    @Override
                    public void run() {
                        LocalToaster.toast(class_2561.method_30163((String)"MythicWorldTweaks"), (class_2561)class_2561.method_43471((String)"mythicworldtweaks.config.fail_to_hot_update"));
                    }
                };
                notifier.schedule(notifierTask, 0L, 20000L);
                notifierRunning = true;
            }
            return;
        }
        if (ConfigLoader.isDuringServerRuntime()) {
            RuntimeController.loadTransmittableParamsFromConfig(false);
            MythicWorldTweaks.LOGGER.info("Server is running, config loaded immediately.");
            LocalToaster.toast(class_2561.method_30163((String)"MythicWorldTweaks"), (class_2561)class_2561.method_43471((String)"mythicworldtweaks.config.hot_update_succeed"));
        } else {
            LocalToaster.toast(class_2561.method_30163((String)"MythicWorldTweaks"), (class_2561)class_2561.method_43471((String)"mythicworldtweaks.config.hot_update_later"));
        }
    }

    @NotNull
    public static ImmutableBiMap<class_2960, class_1792> getAllItems() throws IllegalStateException {
        if (!initState) {
            throw new IllegalStateException("The config system hasn't been initialized, allItems is empty.");
        }
        return allItems;
    }

    @NotNull
    public static ImmutableBiMap<class_2960, class_6880<class_1291>> getAllStatusEffects() throws IllegalStateException {
        if (!initState) {
            throw new IllegalStateException("The config system hasn't been initialized, allStatusEffects is empty.");
        }
        return allStatusEffects;
    }

    @NotNull
    public static ImmutableSet<String> getAllModIds() throws IllegalStateException {
        if (!initState) {
            throw new IllegalStateException("The config system hasn't been initialized, allStatusEffects is empty.");
        }
        return allModIds;
    }

    public static ModConfig getCurrentModConfig() {
        return currentModConfig;
    }

    public static synchronized ModConfig getConfigObject() throws RuntimeException {
        try {
            ModConfig modConfig = null;
            while (modConfig == null) {
                String configContent = ConfigLoader.readConfigContent();
                modConfig = (ModConfig)ModConfig.CONFIG_FILE_GSON.fromJson(configContent, ModConfig.class);
            }
            return modConfig;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get config object.", e);
        }
    }

    private static String readConfigContent() throws IOException {
        String configFilePath = System.getProperty("user.dir") + "/config/mythicworldtweaks/config.json";
        File configFile = new File(configFilePath);
        ConfigLoader.tryPlaceDefaultConfigFile(false);
        try (FileReader fileReader = new FileReader(configFile);){
            String string;
            try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                int charCount;
                char[] charBuffer = new char[128];
                StringBuilder fileIndex = new StringBuilder();
                while ((charCount = bufferedReader.read(charBuffer)) != -1) {
                    fileIndex.append(new String(charBuffer, 0, charCount));
                }
                string = fileIndex.toString();
            }
            return string;
        }
    }

    private static String getDefaultConfig() throws IOException, NullPointerException {
        ClassLoader classLoader = ConfigLoader.class.getClassLoader();
        try (InputStream inputStream = Objects.requireNonNull(classLoader.getResourceAsStream("config/default_config.json"));){
            String string;
            try (InputStreamReader reader = new InputStreamReader(inputStream);){
                int charCount;
                char[] charBuffer = new char[128];
                StringBuilder fileIndex = new StringBuilder();
                while ((charCount = reader.read(charBuffer)) != -1) {
                    fileIndex.append(new String(charBuffer, 0, charCount));
                }
                string = fileIndex.toString();
            }
            return string;
        }
    }

    private static void tryPlaceDefaultConfigFile(boolean isDemo) throws IOException {
        String defaultConfigFilePath = System.getProperty("user.dir") + "/config/mythicworldtweaks" + (isDemo ? "/default_config.json" : "/config.json");
        File defaultConfigFile = new File(defaultConfigFilePath);
        if (!defaultConfigFile.exists()) {
            MythicWorldTweaks.LOGGER.info("MythicWorldTweaks' {}config file doesn't exist, creating new one.", (Object)(isDemo ? "default " : ""));
            defaultConfigFile.getParentFile().mkdirs();
            defaultConfigFile.createNewFile();
            String defaultConfigContent = ConfigLoader.getDefaultConfig();
            try (FileWriter fileWriter = new FileWriter(defaultConfigFile, false);){
                fileWriter.write(defaultConfigContent);
                fileWriter.flush();
            }
        }
    }

    public static MinecraftServer getCurrentServer() {
        if (!isDuringServerRuntime) {
            throw new IllegalStateException("Server isn't running, unable to get!");
        }
        return currentServer;
    }

    public static boolean isDuringServerRuntime() {
        return isDuringServerRuntime;
    }

    public static boolean isItemEditorParserReady() {
        return isItemEditorParserReady;
    }

    static {
        isItemEditorParserReady = false;
        currentServer = null;
        isDuringServerRuntime = false;
        currentModConfig = null;
        notifierRunning = false;
        notifierTask = null;
    }
}

