/*
 * Decompiled with CFR 0.152.
 */
package online.andrew2007.mythic.config;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashSet;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import online.andrew2007.mythic.MythicWorldTweaks;
import online.andrew2007.mythic.config.ConfigLoader;
import online.andrew2007.mythic.config.patterns.BinaryToggleTweaksConfig;
import online.andrew2007.mythic.config.patterns.ItemEditorConfig;
import online.andrew2007.mythic.config.patterns.ModConfig;
import online.andrew2007.mythic.config.patterns.ParamsRequiredTweaksConfig;
import online.andrew2007.mythic.config.runtimeParams.LocalRuntimeParams;
import online.andrew2007.mythic.config.runtimeParams.TransmittableRuntimeParams;
import online.andrew2007.mythic.item.ItemEditor;
import online.andrew2007.mythic.misc.LocalToaster;
import online.andrew2007.mythic.misc.WardenEntityStuff;
import online.andrew2007.mythic.network.payloads.PlayConfigPushPayload;

public class RuntimeController {
    private static LocalRuntimeParams localRuntimeParams = LocalRuntimeParams.getDefaultInstance();
    private static boolean localRuntimeParamsInitialized = false;
    private static TransmittableRuntimeParams currentTParams = TransmittableRuntimeParams.getDefaultInstance();
    private static TransmittableRuntimeParams.TransmittableIECUnit[] previousItemEditorConfig = new TransmittableRuntimeParams.TransmittableIECUnit[0];
    private static TransmittableRuntimeParams serverPlayReceivedTParams = null;
    private static boolean isDuringMythicServerPlay = false;

    public static synchronized void loadTransmittableParamsFromConfig(boolean isStartup) {
        TransmittableRuntimeParams newParams;
        ModConfig modConfig = ConfigLoader.getCurrentModConfig();
        if (modConfig.tweaksEnabled() && localRuntimeParams.modEnabled()) {
            TransmittableRuntimeParams.TransmittableIECUnit[] transmittableIECUnits;
            BinaryToggleTweaksConfig binaryToggleTweaksConfig = modConfig.binaryToggleTweaksConfig();
            ParamsRequiredTweaksConfig paramsRequiredTweaksConfig = modConfig.paramsRequiredTweaksConfig();
            boolean itemEditorEnabled = modConfig.itemEditorConfig().enabled();
            if (itemEditorEnabled) {
                ItemEditorConfig.ItemEditorConfigUnit[] itemEditorConfigUnits = modConfig.itemEditorConfig().itemEditorConfigUnits();
                transmittableIECUnits = new TransmittableRuntimeParams.TransmittableIECUnit[itemEditorConfigUnits.length];
                for (int i = 0; i < itemEditorConfigUnits.length; ++i) {
                    ItemEditorConfig.ItemEditorConfigUnit itemEditorConfigUnit = itemEditorConfigUnits[i];
                    transmittableIECUnits[i] = new TransmittableRuntimeParams.TransmittableIECUnit(itemEditorConfigUnit.targetItem(), itemEditorConfigUnit.maxStackSize(), itemEditorConfigUnit.maxDamage(), itemEditorConfigUnit.fireResistant(), itemEditorConfigUnit.rarity(), itemEditorConfigUnit.recipeRemainder(), itemEditorConfigUnit.foodProperty());
                }
            } else {
                transmittableIECUnits = new TransmittableRuntimeParams.TransmittableIECUnit[]{};
            }
            newParams = new TransmittableRuntimeParams(binaryToggleTweaksConfig.throwableFireCharge(), binaryToggleTweaksConfig.largeFireCharge(), binaryToggleTweaksConfig.editablePlayerData(), binaryToggleTweaksConfig.blocksFriendlyCreepers(), binaryToggleTweaksConfig.itemExplosionResistance(), binaryToggleTweaksConfig.nestableShulkerBoxes(), binaryToggleTweaksConfig.rideablePlayers(), binaryToggleTweaksConfig.playerRidingGestures(), binaryToggleTweaksConfig.playerRidingProtection(), binaryToggleTweaksConfig.dispensableTridents(), binaryToggleTweaksConfig.voidReturnableTrident(), binaryToggleTweaksConfig.multiTridentDamage(), binaryToggleTweaksConfig.persistentTridents(), binaryToggleTweaksConfig.silentWardens(), binaryToggleTweaksConfig.constantVillagerConversion(), binaryToggleTweaksConfig.fakePlayerSleepExclusion(), binaryToggleTweaksConfig.sleepingExtras(), binaryToggleTweaksConfig.suicideCommand(), binaryToggleTweaksConfig.keepExperience(), binaryToggleTweaksConfig.alwaysDragonEgg(), binaryToggleTweaksConfig.bowEnchantmentsForCrossbow(), binaryToggleTweaksConfig.creativePlayerVoidResistance(), paramsRequiredTweaksConfig.autoDiscardingFireBallConfig().enabled(), paramsRequiredTweaksConfig.stuffedShulkerBoxStackLimitConfig().enabled(), paramsRequiredTweaksConfig.shulkerBoxNestingLimitConfig().enabled(), paramsRequiredTweaksConfig.wardenAttributesWeakeningConfig().enabled(), paramsRequiredTweaksConfig.wardenSonicBoomWeakeningConfig().enabled(), paramsRequiredTweaksConfig.playerDeathItemProtectionConfig().enabled(), paramsRequiredTweaksConfig.autoDiscardingFireBallConfig().maxLifeTicks(), paramsRequiredTweaksConfig.stuffedShulkerBoxStackLimitConfig().maxStackSize(), paramsRequiredTweaksConfig.shulkerBoxNestingLimitConfig().maxLayers(), paramsRequiredTweaksConfig.wardenAttributesWeakeningConfig().maxHealth(), paramsRequiredTweaksConfig.wardenAttributesWeakeningConfig().knockBackResistance(), paramsRequiredTweaksConfig.wardenAttributesWeakeningConfig().meleeAttackDamage(), paramsRequiredTweaksConfig.wardenAttributesWeakeningConfig().meleeAttackKnockBack(), paramsRequiredTweaksConfig.wardenAttributesWeakeningConfig().idleMovementSpeed(), paramsRequiredTweaksConfig.wardenAttributesWeakeningConfig().chasingMovementSpeed(), paramsRequiredTweaksConfig.wardenAttributesWeakeningConfig().attackIntervalTicks(), paramsRequiredTweaksConfig.wardenSonicBoomWeakeningConfig().sonicBoomDamage(), paramsRequiredTweaksConfig.wardenSonicBoomWeakeningConfig().sonicBoomKnockBackRate(), paramsRequiredTweaksConfig.wardenSonicBoomWeakeningConfig().sonicBoomIntervalTicks(), paramsRequiredTweaksConfig.playerDeathItemProtectionConfig().itemDiscardTicks(), paramsRequiredTweaksConfig.playerDeathItemProtectionConfig().mobPickupProtection(), paramsRequiredTweaksConfig.playerDeathItemProtectionConfig().strictPickup(), itemEditorEnabled, transmittableIECUnits);
        } else {
            newParams = TransmittableRuntimeParams.getDefaultInstance();
        }
        if (localRuntimeParams.modEnabled()) {
            currentTParams = newParams;
            if (!isDuringMythicServerPlay) {
                RuntimeController.onParamsChange();
            }
            if (RuntimeController.getLocalRuntimeParams().serverPlaySupportEnabled() && ConfigLoader.isDuringServerRuntime() && !isStartup) {
                GameProfile hostProfile;
                MinecraftServer server = ConfigLoader.getCurrentServer();
                ArrayList<class_3222> playerList = new ArrayList<class_3222>(server.method_3760().method_14571());
                String hostPlayerName = !server.method_3816() ? ((hostProfile = server.method_43824()) != null ? hostProfile.getName() : null) : null;
                playerList.removeIf(player -> player.method_7334().getName().equalsIgnoreCase(hostPlayerName));
                for (class_3222 player2 : playerList) {
                    ServerPlayNetworking.send((class_3222)player2, (class_8710)new PlayConfigPushPayload(RuntimeController.getCurrentTParams()));
                    player2.mythicWorldTweaks$onPlayConfigPush();
                }
            }
        }
    }

    public static void loadLocalParamsFromConfig() {
        if (!localRuntimeParamsInitialized) {
            try {
                ModConfig modConfig = ConfigLoader.getConfigObject();
                localRuntimeParams = new LocalRuntimeParams(modConfig.modEnabled(), modConfig.modDataPackEnabled(), modConfig.serverPlaySupportEnabled(), modConfig.serverName(), modConfig.modIdValidationConfig().enabled(), modConfig.modIdValidationConfig().modIdList());
                localRuntimeParamsInitialized = true;
            }
            catch (RuntimeException e) {
                MythicWorldTweaks.LOGGER.error("Unable to load config on startup, Minecraft is shutting down.");
                throw e;
            }
        }
    }

    private static void onParamsChange() {
        RuntimeController.applyItemEdits();
        WardenEntityStuff.modifyWardenAttributes();
        WardenEntityStuff.WardenEntityTrack.wardenRefresh();
    }

    private static void applyItemEdits() {
        TransmittableRuntimeParams.TransmittableIECUnit[] currentUnits;
        HashSet<ItemEditor> itemEditors = new HashSet<ItemEditor>();
        if (previousItemEditorConfig != null) {
            for (TransmittableRuntimeParams.TransmittableIECUnit unit : previousItemEditorConfig) {
                itemEditors.add(unit.revertItemEditor());
            }
        }
        if ((currentUnits = RuntimeController.getCurrentTParams().itemEditorConfig()) != null) {
            for (TransmittableRuntimeParams.TransmittableIECUnit unit : currentUnits) {
                itemEditors.add(unit.applyToItemEditor());
            }
        }
        itemEditors.forEach(ItemEditor::apply);
        previousItemEditorConfig = currentUnits;
    }

    public static synchronized void receiveConfigPush(TransmittableRuntimeParams params) {
        serverPlayReceivedTParams = params;
        isDuringMythicServerPlay = true;
        RuntimeController.onParamsChange();
        LocalToaster.toast(class_2561.method_30163((String)"MythicWorldTweaks"), (class_2561)class_2561.method_43471((String)"mythicworldtweaks.network.received_config"));
        MythicWorldTweaks.LOGGER.info("Successfully received and applied mod config from the server.");
    }

    public static synchronized void exitMythicServerPlay() {
        if (isDuringMythicServerPlay) {
            isDuringMythicServerPlay = false;
            serverPlayReceivedTParams = null;
            RuntimeController.onParamsChange();
            MythicWorldTweaks.LOGGER.info("Disconnected from server, switch from server config to local config.");
        }
    }

    public static TransmittableRuntimeParams getCurrentTParams() {
        return isDuringMythicServerPlay ? serverPlayReceivedTParams : currentTParams;
    }

    public static LocalRuntimeParams getLocalRuntimeParams() {
        return localRuntimeParams;
    }

    public static boolean isDuringMythicServerPlay() {
        return isDuringMythicServerPlay;
    }
}

