/*
 * Decompiled with CFR 0.152.
 */
package online.andrew2007.mythic.config.patterns;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import online.andrew2007.mythic.config.ConfigLoader;

public interface CustomJsonDeserializer<T>
extends JsonDeserializer<T> {
    public static int getCharCount(String string, char character) {
        return string.split(String.valueOf(character), -1).length - 1;
    }

    default public boolean readBoolean(JsonElement jsonElement) throws JsonParseException {
        JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
        if (!jsonPrimitive.isBoolean()) {
            throw new JsonParseException("Wrong type: non boolean value!");
        }
        return jsonPrimitive.getAsBoolean();
    }

    default public class_2960 parseIdentifier(JsonElement jsonElement) throws JsonParseException {
        String rawIdentity = jsonElement.getAsString();
        if (rawIdentity.isBlank()) {
            throw new JsonParseException(String.format("The identity \"%s\" is blank.", rawIdentity));
        }
        int colonCount = CustomJsonDeserializer.getCharCount(rawIdentity, ':');
        try {
            if (colonCount == 0) {
                return class_2960.method_60656((String)rawIdentity);
            }
            if (colonCount == 1) {
                String[] segments = rawIdentity.split(":", -1);
                String nameSpace = segments[0];
                String path = segments[1];
                if (nameSpace.isBlank() || path.isBlank()) {
                    throw new JsonParseException(String.format("The identity \"%s\" has blank content.", rawIdentity));
                }
                return class_2960.method_60655((String)nameSpace, (String)path);
            }
            throw new JsonParseException(String.format("The identity \"%s\" has wrong format.", rawIdentity));
        }
        catch (class_151 e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    default public class_1792 getItem(class_2960 itemIdentifier) throws JsonParseException {
        class_1792 item = (class_1792)ConfigLoader.getAllItems().get((Object)itemIdentifier);
        if (item == null) {
            throw new JsonParseException(String.format("Item \"%s\" doesn't exist!", itemIdentifier));
        }
        return item;
    }

    default public void checkKeys(Set<String> expected, Set<String> present, boolean requireFull) throws JsonParseException {
        HashSet<String> excessKeys = new HashSet<String>(present);
        excessKeys.removeAll(expected);
        HashSet<String> missingKeys = new HashSet<String>(expected);
        missingKeys.removeAll(present);
        boolean error = false;
        StringBuilder errorMessage = new StringBuilder();
        if (!excessKeys.isEmpty()) {
            error = true;
            errorMessage.append(String.format("Excess keys: %s.", excessKeys));
        }
        if (!missingKeys.isEmpty() && requireFull) {
            error = true;
            errorMessage.append(String.format("Missing keys: %s.", missingKeys));
        }
        if (error) {
            throw new JsonParseException(String.format("Wrong config structure. %s", errorMessage));
        }
    }
}

