/*
 * Decompiled with CFR 0.152.
 */
package online.andrew2007.mythic.config.patterns;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import online.andrew2007.mythic.config.ConfigLoader;
import online.andrew2007.mythic.config.patterns.CustomJsonDeserializer;

public record ItemEditorConfig(boolean enabled, ItemEditorConfigUnit[] itemEditorConfigUnits) {

    public record ItemEditorConfigUnit(class_1792 targetItem, int maxStackSize, int maxDamage, boolean fireResistant, class_1814 rarity, class_1792 recipeRemainder, class_4174 foodProperty) {

        public static class Deserializer
        implements CustomJsonDeserializer<ItemEditorConfigUnit> {
            public ItemEditorConfigUnit deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                if (!jsonObject.has("target_item")) {
                    throw new JsonParseException("Wrong config structure, missing \"target_item_key\"!");
                }
                this.checkKeys(Set.of("target_item", "max_stack_size", "max_damage", "fire_resistant", "rarity", "recipe_remainder", "food_property"), jsonObject.keySet(), false);
                class_2960 targetItemIdentifier = this.parseIdentifier(jsonObject.get("target_item"));
                class_1792 targetItem = this.getItem(targetItemIdentifier);
                boolean itemDamageable = targetItem.method_57347().method_57832(class_9334.field_50072);
                int maxStackSize = targetItem.method_7882();
                int maxDamage = (Integer)targetItem.method_57347().method_57830(class_9334.field_50072, (Object)0);
                boolean fireResistant = targetItem.method_57347().method_57832(class_9334.field_50076);
                class_1814 rarity = (class_1814)targetItem.method_57347().method_57830(class_9334.field_50073, (Object)class_1814.field_8906);
                Object recipeRemainder = targetItem.method_7858();
                Object foodProperty = (class_4174)targetItem.method_57347().method_57830(class_9334.field_50075, null);
                if (jsonObject.has("max_stack_size") && (maxStackSize = jsonObject.get("max_stack_size").getAsInt()) <= 0) {
                    throw new JsonParseException("Wrong config value for \"max_stack_size\", positive value is required.");
                }
                if (jsonObject.has("max_damage") && (maxDamage = jsonObject.get("max_damage").getAsInt()) < 0) {
                    throw new JsonParseException("Wrong config value for \"max_damage\", non-negative value is required.");
                }
                if (jsonObject.has("fire_resistant")) {
                    fireResistant = jsonObject.get("fire_resistant").getAsBoolean();
                }
                if (jsonObject.has("rarity")) {
                    String rarityIdentity;
                    rarity = switch (rarityIdentity = jsonObject.get("rarity").getAsString().toLowerCase()) {
                        case "common" -> class_1814.field_8906;
                        case "uncommon" -> class_1814.field_8907;
                        case "rare" -> class_1814.field_8903;
                        case "epic" -> class_1814.field_8904;
                        default -> throw new JsonParseException(String.format("No such rarity identity: %s", rarityIdentity));
                    };
                }
                if (jsonObject.has("recipe_remainder")) {
                    JsonElement recipeRemainderJSON = jsonObject.get("recipe_remainder");
                    recipeRemainder = recipeRemainderJSON.isJsonNull() ? null : this.getItem(this.parseIdentifier(jsonObject.get("recipe_remainder")));
                }
                if (jsonObject.has("food_property")) {
                    JsonElement foodPropertyJSON = jsonObject.get("food_property");
                    foodProperty = foodPropertyJSON.isJsonNull() ? null : ((FoodProperty)context.deserialize((JsonElement)foodPropertyJSON, FoodProperty.class)).foodComponent;
                }
                if (itemDamageable) {
                    if (maxStackSize > 1) {
                        throw new JsonParseException(String.format("Item \"%s\" is damageable in its vanilla settings. You cannot set \"max_stack_size\" to more than 1.", targetItemIdentifier));
                    }
                    if (maxDamage == 0) {
                        throw new JsonParseException(String.format("Item \"%s\" is damageable in its vanilla settings. You cannot set \"max_damage\" to or less than 0.", targetItemIdentifier));
                    }
                } else if (maxDamage > 0) {
                    throw new JsonParseException(String.format("Item \"%s\" is not damageable in its vanilla settings. You cannot set \"max_damage\" to more than 0.", targetItemIdentifier));
                }
                return new ItemEditorConfigUnit(targetItem, maxStackSize, maxDamage, fireResistant, rarity, (class_1792)recipeRemainder, (class_4174)foodProperty);
            }
        }
    }

    public record FoodStatusEffectUnit(class_6880<class_1291> statusEffect, int level, int lastingTime, float probability) {

        public static class Deserializer
        implements CustomJsonDeserializer<FoodStatusEffectUnit> {
            public FoodStatusEffectUnit deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                this.checkKeys(Set.of("status_effect", "level", "lasting_time", "probability"), jsonObject.keySet(), true);
                class_2960 effectIdentifier = this.parseIdentifier(jsonObject.get("status_effect"));
                class_6880 statusEffect = (class_6880)ConfigLoader.getAllStatusEffects().get((Object)effectIdentifier);
                if (statusEffect == null) {
                    throw new JsonParseException(String.format("Status effect \"%s\" doesn't exist!", effectIdentifier));
                }
                int level = jsonObject.get("level").getAsInt();
                int lastingTime = jsonObject.get("lasting_time").getAsInt();
                float probability = jsonObject.get("probability").getAsFloat();
                if (level <= 0 || level > 256) {
                    throw new JsonParseException("Wrong config value for \"level\", value from 1 to 256 is required.");
                }
                if (lastingTime < -1) {
                    throw new JsonParseException("Wrong config value for \"lasting_time\", value equal to or greater than -1 is required.");
                }
                if (probability < 0.0f || probability > 1.0f) {
                    throw new JsonParseException("Wrong config value for \"probability\", value from 0.0 to 1.0 is required.");
                }
                return new FoodStatusEffectUnit((class_6880<class_1291>)statusEffect, level, lastingTime, probability);
            }
        }
    }

    public record FoodProperty(class_4174 foodComponent) {

        public static class Deserializer
        implements CustomJsonDeserializer<FoodProperty> {
            public FoodProperty deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                this.checkKeys(Set.of("nutrition", "saturation", "always_edible", "eat_seconds", "left_over_item", "status_effects"), jsonObject.keySet(), true);
                int nutrition = jsonObject.get("nutrition").getAsInt();
                float saturation = jsonObject.get("saturation").getAsFloat();
                boolean alwaysEdible = jsonObject.get("always_edible").getAsBoolean();
                float eatSeconds = jsonObject.get("eat_seconds").getAsFloat();
                JsonElement leftOverItemJSON = jsonObject.get("left_over_item");
                Optional<Object> leftOverItemOptional = Optional.empty();
                if (!leftOverItemJSON.isJsonNull()) {
                    class_2960 leftOverItemIdentifier = this.parseIdentifier(leftOverItemJSON);
                    class_1792 leftOverItem = this.getItem(leftOverItemIdentifier);
                    leftOverItemOptional = Optional.of(new class_1799((class_1935)leftOverItem));
                }
                ArrayList<class_4174.class_9423> statusEffectEntryList = new ArrayList<class_4174.class_9423>();
                if (nutrition < 0) {
                    throw new JsonParseException("Wrong config value for \"nutrition\", non-negative value is required.");
                }
                if (saturation < 0.0f) {
                    throw new JsonParseException("Wrong config value for \"saturation\", non-negative value is required.");
                }
                if (eatSeconds < 0.0f) {
                    throw new JsonParseException("Wrong config value for \"eat_seconds\", non-negative value is required.");
                }
                List statusEffectsJSONList = jsonObject.get("status_effects").getAsJsonArray().asList();
                FoodStatusEffectUnit[] foodStatusEffectUnits = new FoodStatusEffectUnit[statusEffectsJSONList.size()];
                for (int i = 0; i < statusEffectsJSONList.size(); ++i) {
                    foodStatusEffectUnits[i] = (FoodStatusEffectUnit)context.deserialize((JsonElement)statusEffectsJSONList.get(i), FoodStatusEffectUnit.class);
                }
                for (FoodStatusEffectUnit foodStatusEffectUnit : foodStatusEffectUnits) {
                    statusEffectEntryList.add(new class_4174.class_9423(new class_1293(foodStatusEffectUnit.statusEffect(), foodStatusEffectUnit.lastingTime(), foodStatusEffectUnit.level() - 1), foodStatusEffectUnit.probability()));
                }
                return new FoodProperty(new class_4174(nutrition, saturation, alwaysEdible, eatSeconds, leftOverItemOptional, statusEffectEntryList));
            }
        }
    }

    public static class Deserializer
    implements CustomJsonDeserializer<ItemEditorConfig> {
        public ItemEditorConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            this.checkKeys(Set.of("enabled", "item_edit_config_list"), jsonObject.keySet(), true);
            boolean enabled = jsonObject.get("enabled").getAsBoolean();
            List configUnitsJSONList = jsonObject.get("item_edit_config_list").getAsJsonArray().asList();
            ItemEditorConfigUnit[] itemEditorConfigUnits = new ItemEditorConfigUnit[configUnitsJSONList.size()];
            ArrayList<class_1792> editedItemList = new ArrayList<class_1792>();
            for (int i = 0; i < configUnitsJSONList.size(); ++i) {
                ItemEditorConfigUnit unit = (ItemEditorConfigUnit)context.deserialize((JsonElement)configUnitsJSONList.get(i), ItemEditorConfigUnit.class);
                if (editedItemList.contains(unit.targetItem)) {
                    throw new JsonParseException(String.format("Duplicate edit for item %s in config.", unit.targetItem.toString()));
                }
                editedItemList.add(unit.targetItem);
                itemEditorConfigUnits[i] = unit;
            }
            return new ItemEditorConfig(enabled, itemEditorConfigUnits);
        }
    }
}

