/*
 * Decompiled with CFR 0.152.
 */
package online.andrew2007.mythic.config.patterns;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Set;
import online.andrew2007.mythic.config.ConfigLoader;
import online.andrew2007.mythic.config.patterns.BinaryToggleTweaksConfig;
import online.andrew2007.mythic.config.patterns.CustomJsonDeserializer;
import online.andrew2007.mythic.config.patterns.ItemEditorConfig;
import online.andrew2007.mythic.config.patterns.ModIdValidationConfig;
import online.andrew2007.mythic.config.patterns.ParamsRequiredTweaksConfig;

public record ModConfig(boolean modEnabled, boolean modDataPackEnabled, boolean tweaksEnabled, boolean serverPlaySupportEnabled, String serverName, ModIdValidationConfig modIdValidationConfig, BinaryToggleTweaksConfig binaryToggleTweaksConfig, ParamsRequiredTweaksConfig paramsRequiredTweaksConfig, ItemEditorConfig itemEditorConfig) {
    public static final Gson CONFIG_FILE_GSON = new GsonBuilder().registerTypeAdapter(ModConfig.class, (Object)new Deserializer()).registerTypeAdapter(ModIdValidationConfig.class, (Object)new ModIdValidationConfig.Deserializer()).registerTypeAdapter(BinaryToggleTweaksConfig.class, (Object)new BinaryToggleTweaksConfig.Deserializer()).registerTypeAdapter(ParamsRequiredTweaksConfig.class, (Object)new ParamsRequiredTweaksConfig.Deserializer()).registerTypeAdapter(ParamsRequiredTweaksConfig.AutoDiscardingFireBallConfig.class, (Object)new ParamsRequiredTweaksConfig.AutoDiscardingFireBallConfig.Deserializer()).registerTypeAdapter(ParamsRequiredTweaksConfig.StuffedShulkerBoxStackLimitConfig.class, (Object)new ParamsRequiredTweaksConfig.StuffedShulkerBoxStackLimitConfig.Deserializer()).registerTypeAdapter(ParamsRequiredTweaksConfig.ShulkerBoxNestingLimitConfig.class, (Object)new ParamsRequiredTweaksConfig.ShulkerBoxNestingLimitConfig.Deserializer()).registerTypeAdapter(ParamsRequiredTweaksConfig.WardenAttributesWeakeningConfig.class, (Object)new ParamsRequiredTweaksConfig.WardenAttributesWeakeningConfig.Deserializer()).registerTypeAdapter(ParamsRequiredTweaksConfig.WardenSonicBoomWeakeningConfig.class, (Object)new ParamsRequiredTweaksConfig.WardenSonicBoomWeakeningConfig.Deserializer()).registerTypeAdapter(ParamsRequiredTweaksConfig.PlayerDeathItemProtectionConfig.class, (Object)new ParamsRequiredTweaksConfig.PlayerDeathItemProtectionConfig.Deserializer()).registerTypeAdapter(ItemEditorConfig.class, (Object)new ItemEditorConfig.Deserializer()).registerTypeAdapter(ItemEditorConfig.ItemEditorConfigUnit.class, (Object)new ItemEditorConfig.ItemEditorConfigUnit.Deserializer()).registerTypeAdapter(ItemEditorConfig.FoodProperty.class, (Object)new ItemEditorConfig.FoodProperty.Deserializer()).registerTypeAdapter(ItemEditorConfig.FoodStatusEffectUnit.class, (Object)new ItemEditorConfig.FoodStatusEffectUnit.Deserializer()).create();

    public static class Deserializer
    implements CustomJsonDeserializer<ModConfig> {
        public ModConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            this.checkKeys(Set.of("mod_enabled", "mod_data_pack_enabled", "tweaks_enabled", "server_play_support_enabled", "server_name", "mod_id_validation", "binary_toggle_tweaks", "params_required_tweaks", "item_editor"), jsonObject.keySet(), true);
            ModIdValidationConfig modIdValidationConfig = (ModIdValidationConfig)context.deserialize(jsonObject.get("mod_id_validation"), ModIdValidationConfig.class);
            BinaryToggleTweaksConfig binaryToggleTweaksConfig = ConfigLoader.isItemEditorParserReady() ? (BinaryToggleTweaksConfig)context.deserialize(jsonObject.get("binary_toggle_tweaks"), BinaryToggleTweaksConfig.class) : null;
            ParamsRequiredTweaksConfig paramsRequiredTweaksConfig = ConfigLoader.isItemEditorParserReady() ? (ParamsRequiredTweaksConfig)context.deserialize(jsonObject.get("params_required_tweaks"), ParamsRequiredTweaksConfig.class) : null;
            ItemEditorConfig itemEditorConfig = ConfigLoader.isItemEditorParserReady() ? (ItemEditorConfig)context.deserialize(jsonObject.get("item_editor"), ItemEditorConfig.class) : null;
            return new ModConfig(this.readBoolean(jsonObject.get("mod_enabled")), this.readBoolean(jsonObject.get("mod_data_pack_enabled")), this.readBoolean(jsonObject.get("tweaks_enabled")), this.readBoolean(jsonObject.get("server_play_support_enabled")), jsonObject.get("server_name").getAsString(), modIdValidationConfig, binaryToggleTweaksConfig, paramsRequiredTweaksConfig, itemEditorConfig);
        }
    }
}

