/*
 * Decompiled with CFR 0.152.
 */
package online.andrew2007.mythic.config.patterns;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Set;
import online.andrew2007.mythic.config.patterns.CustomJsonDeserializer;

public record ParamsRequiredTweaksConfig(AutoDiscardingFireBallConfig autoDiscardingFireBallConfig, StuffedShulkerBoxStackLimitConfig stuffedShulkerBoxStackLimitConfig, ShulkerBoxNestingLimitConfig shulkerBoxNestingLimitConfig, WardenAttributesWeakeningConfig wardenAttributesWeakeningConfig, WardenSonicBoomWeakeningConfig wardenSonicBoomWeakeningConfig, PlayerDeathItemProtectionConfig playerDeathItemProtectionConfig) {

    public record AutoDiscardingFireBallConfig(boolean enabled, int maxLifeTicks) {

        public static class Deserializer
        implements CustomJsonDeserializer<AutoDiscardingFireBallConfig> {
            public AutoDiscardingFireBallConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                this.checkKeys(Set.of("enabled", "max_life_ticks"), jsonObject.keySet(), true);
                int maxLifeTicks = jsonObject.get("max_life_ticks").getAsInt();
                if (maxLifeTicks <= 0) {
                    throw new JsonParseException("Wrong config value for \"max_life_time\", positive value is required.");
                }
                return new AutoDiscardingFireBallConfig(this.readBoolean(jsonObject.get("enabled")), maxLifeTicks);
            }
        }
    }

    public record StuffedShulkerBoxStackLimitConfig(boolean enabled, int maxStackSize) {

        public static class Deserializer
        implements CustomJsonDeserializer<StuffedShulkerBoxStackLimitConfig> {
            public StuffedShulkerBoxStackLimitConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                this.checkKeys(Set.of("enabled", "max_stack_size"), jsonObject.keySet(), true);
                int maxStackSize = jsonObject.get("max_stack_size").getAsInt();
                if (maxStackSize <= 0) {
                    throw new JsonParseException("Wrong config value for \"max_stack_size\", positive value is required.");
                }
                return new StuffedShulkerBoxStackLimitConfig(this.readBoolean(jsonObject.get("enabled")), maxStackSize);
            }
        }
    }

    public record ShulkerBoxNestingLimitConfig(boolean enabled, int maxLayers) {

        public static class Deserializer
        implements CustomJsonDeserializer<ShulkerBoxNestingLimitConfig> {
            public ShulkerBoxNestingLimitConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                this.checkKeys(Set.of("enabled", "max_layers"), jsonObject.keySet(), true);
                int maxLayers = jsonObject.get("max_layers").getAsInt();
                if (maxLayers <= 0 || maxLayers > 10) {
                    throw new JsonParseException("Wrong config value for \"max_layers\", value between 0 and 10 is required.");
                }
                return new ShulkerBoxNestingLimitConfig(this.readBoolean(jsonObject.get("enabled")), maxLayers);
            }
        }
    }

    public record WardenAttributesWeakeningConfig(boolean enabled, double maxHealth, double knockBackResistance, double meleeAttackDamage, double meleeAttackKnockBack, double idleMovementSpeed, float chasingMovementSpeed, int attackIntervalTicks) {

        public static class Deserializer
        implements CustomJsonDeserializer<WardenAttributesWeakeningConfig> {
            public WardenAttributesWeakeningConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                this.checkKeys(Set.of("enabled", "max_health", "knock_back_resistance", "melee_attack_damage", "melee_attack_knock_back", "idle_movement_speed", "chasing_movement_speed", "attack_interval_ticks"), jsonObject.keySet(), true);
                double maxHealth = jsonObject.get("max_health").getAsDouble();
                double knockBackResistance = jsonObject.get("knock_back_resistance").getAsDouble();
                double meleeAttackDamage = jsonObject.get("melee_attack_damage").getAsDouble();
                double meleeAttackKnockBack = jsonObject.get("melee_attack_knock_back").getAsDouble();
                double idleMovementSpeed = jsonObject.get("idle_movement_speed").getAsDouble();
                float chasingMovementSpeed = jsonObject.get("chasing_movement_speed").getAsFloat();
                int attackIntervalTicks = jsonObject.get("attack_interval_ticks").getAsInt();
                if (maxHealth <= 0.0) {
                    throw new JsonParseException("Wrong config value for \"max_health\", positive value is required.");
                }
                if (knockBackResistance < 0.0 || knockBackResistance > 1.0) {
                    throw new JsonParseException("Wrong config value for \"knock_back_resistance\", value from 0.0 to 1.0 is required.");
                }
                if (meleeAttackDamage < 0.0) {
                    throw new JsonParseException("Wrong config value for \"melee_attack_damage\", non-negative value is required.");
                }
                if (meleeAttackKnockBack < 0.0) {
                    throw new JsonParseException("Wrong config value for \"melee_attack_knock_back\", non-negative value is required.");
                }
                if (idleMovementSpeed <= 0.0) {
                    throw new JsonParseException("Wrong config value for \"idle_movement_speed\", positive value is required.");
                }
                if (chasingMovementSpeed <= 0.0f) {
                    throw new JsonParseException("Wrong config value for \"chasing_movement_speed\", positive value is required.");
                }
                if (attackIntervalTicks <= 0) {
                    throw new JsonParseException("Wrong config value for \"attack_interval_ticks\", positive value is required.");
                }
                return new WardenAttributesWeakeningConfig(this.readBoolean(jsonObject.get("enabled")), maxHealth, knockBackResistance, meleeAttackDamage, meleeAttackKnockBack, idleMovementSpeed, chasingMovementSpeed, attackIntervalTicks);
            }
        }
    }

    public record WardenSonicBoomWeakeningConfig(boolean enabled, float sonicBoomDamage, double sonicBoomKnockBackRate, int sonicBoomIntervalTicks) {

        public static class Deserializer
        implements CustomJsonDeserializer<WardenSonicBoomWeakeningConfig> {
            public WardenSonicBoomWeakeningConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                this.checkKeys(Set.of("enabled", "sonic_boom_damage", "sonic_boom_knock_back_rate", "sonic_boom_interval_ticks"), jsonObject.keySet(), true);
                float sonicBoomDamage = jsonObject.get("sonic_boom_damage").getAsFloat();
                double sonicBoomKnockBackRate = jsonObject.get("sonic_boom_knock_back_rate").getAsDouble();
                int sonicBoomIntervalTicks = jsonObject.get("sonic_boom_interval_ticks").getAsInt();
                if (sonicBoomDamage < 0.0f) {
                    throw new JsonParseException("Wrong config value for \"sonic_boom_damage\", non-negative value is required.");
                }
                if (sonicBoomKnockBackRate < 0.0) {
                    throw new JsonParseException("Wrong config value for \"sonic_boom_knock_back_rate\", non-negative value is required.");
                }
                if (sonicBoomIntervalTicks <= 0) {
                    throw new JsonParseException("Wrong config value for \"sonic_boom_interval_ticks\", positive value is required.");
                }
                return new WardenSonicBoomWeakeningConfig(this.readBoolean(jsonObject.get("enabled")), sonicBoomDamage, sonicBoomKnockBackRate, sonicBoomIntervalTicks);
            }
        }
    }

    public record PlayerDeathItemProtectionConfig(boolean enabled, int itemDiscardTicks, boolean mobPickupProtection, boolean strictPickup) {

        public static class Deserializer
        implements CustomJsonDeserializer<PlayerDeathItemProtectionConfig> {
            public PlayerDeathItemProtectionConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                this.checkKeys(Set.of("enabled", "item_discard_ticks", "mob_pickup_protection", "strict_pickup"), jsonObject.keySet(), true);
                int itemDiscardTicks = jsonObject.get("item_discard_ticks").getAsInt();
                boolean mobPickupProtection = this.readBoolean(jsonObject.get("mob_pickup_protection"));
                boolean strictPickup = this.readBoolean(jsonObject.get("strict_pickup"));
                if (itemDiscardTicks < -1) {
                    throw new JsonParseException("Wrong config value for \"item_discard_ticks\", value greater than -2 is required.");
                }
                return new PlayerDeathItemProtectionConfig(this.readBoolean(jsonObject.get("enabled")), itemDiscardTicks, mobPickupProtection, strictPickup);
            }
        }
    }

    public static class Deserializer
    implements CustomJsonDeserializer<ParamsRequiredTweaksConfig> {
        public ParamsRequiredTweaksConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            this.checkKeys(Set.of("auto_discarding_fire_ball", "stuffed_shulker_box_stack_limit", "shulker_box_nesting_limit", "warden_attributes_weakening", "warden_sonic_boom_weakening", "player_death_item_protection"), jsonObject.keySet(), true);
            AutoDiscardingFireBallConfig autoDiscardingFireBallConfig = (AutoDiscardingFireBallConfig)context.deserialize(jsonObject.get("auto_discarding_fire_ball"), AutoDiscardingFireBallConfig.class);
            StuffedShulkerBoxStackLimitConfig stuffedShulkerBoxStackLimitConfig = (StuffedShulkerBoxStackLimitConfig)context.deserialize(jsonObject.get("stuffed_shulker_box_stack_limit"), StuffedShulkerBoxStackLimitConfig.class);
            ShulkerBoxNestingLimitConfig shulkerBoxNestingLimitConfig = (ShulkerBoxNestingLimitConfig)context.deserialize(jsonObject.get("shulker_box_nesting_limit"), ShulkerBoxNestingLimitConfig.class);
            WardenAttributesWeakeningConfig wardenAttributesWeakeningConfig = (WardenAttributesWeakeningConfig)context.deserialize(jsonObject.get("warden_attributes_weakening"), WardenAttributesWeakeningConfig.class);
            WardenSonicBoomWeakeningConfig wardenSonicBoomWeakeningConfig = (WardenSonicBoomWeakeningConfig)context.deserialize(jsonObject.get("warden_sonic_boom_weakening"), WardenSonicBoomWeakeningConfig.class);
            PlayerDeathItemProtectionConfig playerDeathItemProtectionConfig = (PlayerDeathItemProtectionConfig)context.deserialize(jsonObject.get("player_death_item_protection"), PlayerDeathItemProtectionConfig.class);
            return new ParamsRequiredTweaksConfig(autoDiscardingFireBallConfig, stuffedShulkerBoxStackLimitConfig, shulkerBoxNestingLimitConfig, wardenAttributesWeakeningConfig, wardenSonicBoomWeakeningConfig, playerDeathItemProtectionConfig);
        }
    }
}

