/*
 * Decompiled with CFR 0.152.
 */
package online.andrew2007.mythic.config.runtimeParams;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_6880;
import online.andrew2007.mythic.config.ConfigLoader;
import online.andrew2007.mythic.config.patterns.CustomJsonDeserializer;
import online.andrew2007.mythic.item.ItemEditor;

public record TransmittableRuntimeParams(boolean throwableFireCharge, boolean largeFireCharge, boolean editablePlayerData, boolean blocksFriendlyCreepers, boolean itemExplosionResistance, boolean nestableShulkerBoxes, boolean rideablePlayers, boolean playerRidingGestures, boolean playerRidingProtection, boolean dispensableTridents, boolean voidReturnableTrident, boolean multiTridentDamage, boolean persistentTridents, boolean silentWardens, boolean constantVillagerConversion, boolean fakePlayerSleepExclusion, boolean sleepingExtras, boolean suicideCommand, boolean keepExperience, boolean alwaysDragonEgg, boolean bowEnchantmentsForCrossbow, boolean creativePlayerVoidResistance, boolean autoDiscardingFireBallEnabled, boolean stuffedShulkerBoxStackLimitEnabled, boolean shulkerBoxNestingLimitEnabled, boolean wardenAttributesWeakeningEnabled, boolean wardenSonicBoomWeakeningEnabled, boolean playerDeathItemProtectionEnabled, int fireBallMaxLifeTicks, int shulkerBoxMaxStackSize, int shulkerBoxMaxLayers, double wardenMaxHealth, double wardenKnockBackResistance, double wardenMeleeAttackDamage, double wardenMeleeAttackKnockBack, double wardenIdleMovementSpeed, float wardenChasingMovementSpeed, int wardenAttackIntervalTicks, float sonicBoomDamage, double sonicBoomKnockBackRate, int sonicBoomIntervalTicks, int itemDiscardTicks, boolean mobPickupProtection, boolean strictPickup, boolean itemEditorEnabled, TransmittableIECUnit[] itemEditorConfig) {
    public static final Gson TRANSMITTING_GSON = new GsonBuilder().registerTypeAdapter(class_1792.class, (Object)new ItemTypeAdapter()).registerTypeAdapter(class_4174.class, (Object)new FoodComponentTypeAdapter()).registerTypeAdapter(class_1799.class, (Object)new FoodItemStackTypeAdapter()).registerTypeAdapter(class_4174.class_9423.class, (Object)new FoodStatusEffectEntryTypeAdapter()).registerTypeAdapter(class_1293.class, (Object)new FoodStatusEffectInstanceTypeAdapter()).registerTypeAdapter(class_2960.class, (Object)new IdentifierTypeAdapter()).create();
    public static final ImmutableSet<Field> allPrimitiveFields;

    public static TransmittableRuntimeParams getDefaultInstance() {
        return new TransmittableRuntimeParams(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, 200, 1, 2, 500.0, 1.0, 30.0, 1.5, 0.3, 1.2f, 18, 10.0f, 1.0, 34, 12000, false, false, false, new TransmittableIECUnit[0]);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        for (Field field : allPrimitiveFields) {
            try {
                Object otherValue;
                Object thisValue = field.get(this);
                if (thisValue.equals(otherValue = field.get(other))) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to compare two TRParams.", e);
            }
        }
        if (this.itemEditorConfig.length != ((TransmittableRuntimeParams)other).itemEditorConfig.length) {
            return false;
        }
        HashMap<class_1792, TransmittableIECUnit> thisIECs = TransmittableIECUnit.arrayToMap(this.itemEditorConfig);
        HashMap<class_1792, TransmittableIECUnit> otherIECs = TransmittableIECUnit.arrayToMap(((TransmittableRuntimeParams)other).itemEditorConfig());
        for (class_1792 item : thisIECs.keySet()) {
            TransmittableIECUnit otherUnit;
            if (!otherIECs.containsKey(item)) {
                return false;
            }
            TransmittableIECUnit thisUnit = thisIECs.get(item);
            if (!thisUnit.equals(otherUnit = otherIECs.get(item))) {
                return false;
            }
            otherIECs.remove(item);
        }
        return otherIECs.isEmpty();
    }

    static {
        Field[] fields = TransmittableRuntimeParams.class.getDeclaredFields();
        ImmutableSet.Builder setBuilder = new ImmutableSet.Builder();
        for (Field field : fields) {
            field.setAccessible(true);
            if (!field.getType().isPrimitive() || Modifier.isStatic(field.getModifiers())) continue;
            setBuilder.add((Object)field);
        }
        allPrimitiveFields = setBuilder.build();
    }

    public record TransmittableIECUnit(class_1792 targetItem, int maxStackSize, int maxDamage, boolean fireResistant, class_1814 rarity, class_1792 recipeRemainder, class_4174 foodProperty) {
        public static HashMap<class_1792, TransmittableIECUnit> arrayToMap(TransmittableIECUnit[] units) {
            HashMap<class_1792, TransmittableIECUnit> map = new HashMap<class_1792, TransmittableIECUnit>();
            for (TransmittableIECUnit unit : units) {
                map.put(unit.targetItem, unit);
            }
            return map;
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!this.getClass().equals(other.getClass())) {
                return false;
            }
            TransmittableIECUnit castedOther = (TransmittableIECUnit)other;
            boolean foodPropertyEquals = false;
            if (this.foodProperty == castedOther.foodProperty) {
                foodPropertyEquals = true;
            } else if (this.foodProperty != null && castedOther.foodProperty != null) {
                foodPropertyEquals = this.foodProperty.comp_2491() == castedOther.foodProperty.comp_2491() && this.foodProperty.comp_2492() == castedOther.foodProperty.comp_2492() && this.foodProperty.comp_2493() == castedOther.foodProperty.comp_2493() && this.foodProperty.comp_2494() == castedOther.foodProperty.comp_2494() && Objects.equals(this.foodProperty.comp_2794().orElse(class_1799.field_8037).method_7909(), castedOther.foodProperty.comp_2794().orElse(class_1799.field_8037).method_7909()) && Objects.equals(this.foodProperty.comp_2495(), castedOther.foodProperty.comp_2495());
            }
            return Objects.equals(this.targetItem, castedOther.targetItem) && this.maxStackSize == castedOther.maxStackSize && this.maxDamage == castedOther.maxDamage && this.fireResistant == castedOther.fireResistant && Objects.equals(this.rarity, castedOther.rarity) && Objects.equals(this.recipeRemainder, castedOther.recipeRemainder) && foodPropertyEquals;
        }

        public ItemEditor applyToItemEditor() {
            ItemEditor editor = ItemEditor.getInstance(this.targetItem);
            editor.setMaxStackSize(this.maxStackSize);
            editor.setMaxDamage(this.maxDamage);
            editor.setFireResistance(this.fireResistant);
            editor.setRarity(this.rarity);
            editor.setRecipeRemainder(this.recipeRemainder);
            editor.setFoodComponent(this.foodProperty);
            return editor;
        }

        public ItemEditor revertItemEditor() {
            ItemEditor editor = ItemEditor.getInstance(this.targetItem);
            editor.revertVanilla();
            return editor;
        }
    }

    public static class ItemTypeAdapter
    implements JsonSerializer<class_1792>,
    JsonDeserializer<class_1792> {
        public class_1792 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            class_2960 itemId = (class_2960)context.deserialize(json, class_2960.class);
            return (class_1792)ConfigLoader.getAllItems().get((Object)itemId);
        }

        public JsonElement serialize(class_1792 src, Type typeOfSrc, JsonSerializationContext context) {
            class_2960 srcId = (class_2960)ConfigLoader.getAllItems().inverse().get((Object)src);
            return context.serialize((Object)srcId);
        }
    }

    public static class FoodComponentTypeAdapter
    implements JsonSerializer<class_4174>,
    JsonDeserializer<class_4174> {
        public class_4174 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            int nutrition = jsonObject.get("nutrition").getAsInt();
            float saturation = jsonObject.get("saturation").getAsFloat();
            boolean canAlwaysEat = jsonObject.get("canAlwaysEat").getAsBoolean();
            float eatSeconds = jsonObject.get("eatSeconds").getAsFloat();
            JsonElement leftOverStackJson = jsonObject.get("leftOverStack");
            Optional<Object> leftOverStackOptional = leftOverStackJson == null ? Optional.empty() : Optional.of((class_1799)context.deserialize(leftOverStackJson, class_1799.class));
            List effectsJsonList = jsonObject.get("effects").getAsJsonArray().asList();
            ArrayList<class_4174.class_9423> effectsList = new ArrayList<class_4174.class_9423>();
            for (JsonElement effectJson : effectsJsonList) {
                effectsList.add((class_4174.class_9423)context.deserialize(effectJson, class_4174.class_9423.class));
            }
            return new class_4174(nutrition, saturation, canAlwaysEat, eatSeconds, leftOverStackOptional, effectsList);
        }

        public JsonElement serialize(class_4174 src, Type typeOfSrc, JsonSerializationContext context) {
            int nutrition = src.comp_2491();
            float saturation = src.comp_2492();
            boolean canAlwaysEat = src.comp_2493();
            float eatSeconds = src.comp_2494();
            class_1799 leftOverStack = src.comp_2794().orElse(null);
            List effects = src.comp_2495();
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("nutrition", (JsonElement)new JsonPrimitive((Number)nutrition));
            jsonObject.add("saturation", (JsonElement)new JsonPrimitive((Number)Float.valueOf(saturation)));
            jsonObject.add("canAlwaysEat", (JsonElement)new JsonPrimitive(Boolean.valueOf(canAlwaysEat)));
            jsonObject.add("eatSeconds", (JsonElement)new JsonPrimitive((Number)Float.valueOf(eatSeconds)));
            jsonObject.add("leftOverStack", context.serialize((Object)leftOverStack));
            jsonObject.add("effects", context.serialize((Object)effects));
            return jsonObject;
        }
    }

    public static class FoodItemStackTypeAdapter
    implements JsonSerializer<class_1799>,
    JsonDeserializer<class_1799> {
        public class_1799 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            class_1792 carriedItem = (class_1792)context.deserialize(json, class_1792.class);
            return new class_1799((class_1935)carriedItem);
        }

        public JsonElement serialize(class_1799 src, Type typeOfSrc, JsonSerializationContext context) {
            class_1792 containedItem = src.method_7909();
            return context.serialize((Object)containedItem);
        }
    }

    public static class FoodStatusEffectEntryTypeAdapter
    implements JsonSerializer<class_4174.class_9423>,
    JsonDeserializer<class_4174.class_9423> {
        public class_4174.class_9423 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            class_1293 effect = (class_1293)context.deserialize(jsonObject.get("effect"), class_1293.class);
            float probability = jsonObject.get("probability").getAsFloat();
            return new class_4174.class_9423(effect, probability);
        }

        public JsonElement serialize(class_4174.class_9423 src, Type typeOfSrc, JsonSerializationContext context) {
            class_1293 effect = src.comp_2496();
            float probability = src.comp_2497();
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("effect", context.serialize((Object)effect));
            jsonObject.add("probability", (JsonElement)new JsonPrimitive((Number)Float.valueOf(probability)));
            return jsonObject;
        }
    }

    public static class FoodStatusEffectInstanceTypeAdapter
    implements JsonSerializer<class_1293>,
    JsonDeserializer<class_1293> {
        public class_1293 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            class_2960 effectId = (class_2960)context.deserialize(jsonObject.get("effect"), class_2960.class);
            class_6880 effect = (class_6880)ConfigLoader.getAllStatusEffects().get((Object)effectId);
            int amplifier = jsonObject.get("amplifier").getAsInt();
            int duration = jsonObject.get("duration").getAsInt();
            return new class_1293(effect, duration, amplifier);
        }

        public JsonElement serialize(class_1293 src, Type typeOfSrc, JsonSerializationContext context) {
            class_6880 effect = src.method_5579();
            class_2960 effectId = (class_2960)ConfigLoader.getAllStatusEffects().inverse().get((Object)effect);
            int amplifier = src.method_5578();
            int duration = src.method_5584();
            JsonObject json = new JsonObject();
            json.add("effect", context.serialize((Object)effectId));
            json.add("amplifier", (JsonElement)new JsonPrimitive((Number)amplifier));
            json.add("duration", (JsonElement)new JsonPrimitive((Number)duration));
            return json;
        }
    }

    public static class IdentifierTypeAdapter
    implements JsonSerializer<class_2960>,
    CustomJsonDeserializer<class_2960> {
        public class_2960 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return this.parseIdentifier(json);
        }

        public JsonElement serialize(class_2960 src, Type typeOfSrc, JsonSerializationContext context) {
            String literal = src.method_12836() + ":" + src.method_12832();
            return new JsonPrimitive(literal);
        }
    }
}

