/*
 * Decompiled with CFR 0.152.
 */
package online.andrew2007.mythic.item;

import com.mojang.datafixers.util.Unit;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.HashMap;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_4174;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import online.andrew2007.mythic.misc.ReflectionUtils;
import org.jetbrains.annotations.NotNull;

public class ItemEditor {
    private static final HashMap<class_1792, ItemEditor> itemEditors = new HashMap();
    private final class_1792 carriedItem;
    private final boolean itemDamageable;
    private final int vanillaMaxStackSize;
    private final int vanillaMaxDamage;
    private final class_1814 vanillaRarity;
    private final class_4174 vanillaFoodComponent;
    private final boolean vanillaFireResistance;
    private final class_1792 vanillaRecipeRemainder;
    private int maxStackSize;
    private int maxDamage;
    private class_1814 rarity;
    private class_4174 foodComponent;
    private boolean fireResistance;
    private class_1792 recipeRemainder;

    private ItemEditor(@NotNull class_1792 item) {
        itemEditors.put(item, this);
        this.carriedItem = item;
        ReflectionUtils.separateItemComponents(this.carriedItem);
        this.vanillaMaxStackSize = (Integer)item.method_57347().method_57830(class_9334.field_50071, (Object)1);
        this.vanillaMaxDamage = (Integer)item.method_57347().method_57830(class_9334.field_50072, (Object)0);
        this.vanillaRarity = (class_1814)item.method_57347().method_57830(class_9334.field_50073, (Object)class_1814.field_8906);
        this.vanillaFoodComponent = (class_4174)item.method_57347().method_57830(class_9334.field_50075, null);
        this.vanillaFireResistance = item.method_57347().method_57832(class_9334.field_50076);
        this.vanillaRecipeRemainder = item.method_7858();
        this.itemDamageable = this.carriedItem.method_57347().method_57832(class_9334.field_50072);
        this.revertVanilla();
    }

    public static ItemEditor getInstance(@NotNull class_1792 item) {
        ItemEditor editor = itemEditors.get(item);
        if (editor == null) {
            editor = new ItemEditor(item);
        }
        return editor;
    }

    public void revertVanilla() {
        this.maxStackSize = this.vanillaMaxStackSize;
        this.maxDamage = this.vanillaMaxDamage;
        this.rarity = this.vanillaRarity;
        this.foodComponent = this.vanillaFoodComponent;
        this.fireResistance = this.vanillaFireResistance;
        this.recipeRemainder = this.vanillaRecipeRemainder;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = this.itemDamageable ? 1 : maxStackSize;
    }

    public void setMaxDamage(int maxDamage) {
        if (this.itemDamageable) {
            this.maxDamage = maxDamage;
        }
    }

    public void setRarity(class_1814 rarity) {
        this.rarity = rarity;
    }

    public void setFoodComponent(class_4174 foodComponent) {
        this.foodComponent = foodComponent;
    }

    public void setFireResistance(boolean fireResistance) {
        this.fireResistance = fireResistance;
    }

    public void setRecipeRemainder(class_1792 recipeRemainder) {
        this.recipeRemainder = recipeRemainder;
    }

    public void apply() {
        Reference2ObjectMap<class_9331<?>, Object> underlyingMap = ReflectionUtils.getItemComponentsUnderlyingMap(this.carriedItem);
        if (this.itemDamageable) {
            underlyingMap.put((Object)class_9334.field_50072, (Object)this.maxDamage);
        } else {
            underlyingMap.put((Object)class_9334.field_50071, (Object)this.maxStackSize);
        }
        underlyingMap.put((Object)class_9334.field_50073, (Object)this.rarity);
        if (this.foodComponent == null) {
            underlyingMap.remove((Object)class_9334.field_50075);
        } else {
            underlyingMap.put((Object)class_9334.field_50075, (Object)this.foodComponent);
        }
        if (this.fireResistance) {
            underlyingMap.put((Object)class_9334.field_50076, (Object)Unit.INSTANCE);
        } else {
            underlyingMap.remove((Object)class_9334.field_50076);
        }
        ReflectionUtils.Item$recipeRemainder.setFieldValue(this.carriedItem, this.recipeRemainder);
    }
}

