/*
 * Decompiled with CFR 0.152.
 */
package online.andrew2007.mythic.misc;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1665;
import net.minecraft.class_1674;
import net.minecraft.class_1685;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2940;
import net.minecraft.class_5132;
import net.minecraft.class_5135;
import net.minecraft.class_6880;
import net.minecraft.class_7254;
import net.minecraft.class_7260;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import online.andrew2007.mythic.misc.EnvironmentDetection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtils {
    public static final ReflectedField<class_1674, Integer> FireballEntity$explosionPower = new ReflectedField<class_1674, Integer>(class_1674.class, Integer.class, "explosionPower", "field_7624");
    public static final ReflectedField<class_1665, class_1799> PersistentProjectileEntity$stack = new ReflectedField<class_1665, class_1799>(class_1665.class, class_1799.class, "stack", "field_46970");
    public static final ReflectedField<class_1685, class_2940<Boolean>> TridentEntity$ENCHANTED = new ReflectedField<class_1685, class_2940>(class_1685.class, class_2940.class, "ENCHANTED", "field_21514");
    public static final ReflectedField<class_5135, Map<class_1299<? extends class_1309>, class_5132>> DefaultAttributeRegistry$DEFAULT_ATTRIBUTE_REGISTRY = new ReflectedField<class_5135, Map>(class_5135.class, Map.class, "DEFAULT_ATTRIBUTE_REGISTRY", "field_23730");
    public static final ReflectedField<class_5132, Map<class_6880<class_1320>, class_1324>> DefaultAttributeContainer$instances = new ReflectedField<class_5132, Map>(class_5132.class, Map.class, "instances", "field_23713");
    public static final ReflectedField<class_1324, Double> EntityAttributeInstance$baseValue = new ReflectedField<class_1324, Double>(class_1324.class, Double.class, "baseValue", "field_23704");
    public static final ReflectedField<class_1324, Double> EntityAttributeInstance$value = new ReflectedField<class_1324, Double>(class_1324.class, Double.class, "value", "field_23706");
    public static final ReflectedField<class_1792, class_1792> Item$recipeRemainder = new ReflectedField<class_1792, class_1792>(class_1792.class, class_1792.class, "recipeRemainder", "field_8008");
    public static final ReflectedField<class_7260, class_2940<Integer>> WardenEntity$ANGER = new ReflectedField<class_7260, class_2940>(class_7260.class, class_2940.class, "ANGER", "field_38148");
    public static final ReflectedField<class_7260, class_7254> WardenEntity$angerManager = new ReflectedField<class_7260, class_7254>(class_7260.class, class_7254.class, "angerManager", "field_38141");
    private static final ReflectedField<class_1792, class_9323> Item$components = new ReflectedField<class_1792, class_9323>(class_1792.class, class_9323.class, "components", "field_49263");
    private static final Method SimpleComponentMap$map;

    public static Reference2ObjectMap<class_9331<?>, Object> getItemComponentsUnderlyingMap(class_1792 item) {
        Reference2ObjectMap underlyingMap;
        class_9323 componentMap = item.method_57347();
        try {
            underlyingMap = (Reference2ObjectMap)SimpleComponentMap$map.invoke((Object)componentMap, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to get underlying map of item components.", e);
        }
        return underlyingMap;
    }

    public static void separateItemComponents(class_1792 item) {
        class_9323 copiedComponents = class_9323.method_57827().method_57839(item.method_57347()).method_57838();
        Item$components.setFieldValue(item, copiedComponents);
    }

    static {
        try {
            SimpleComponentMap$map = class_9334.field_49627.getClass().getDeclaredMethod(EnvironmentDetection.isYarn ? "map" : "comp_2440", new Class[0]);
            SimpleComponentMap$map.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to get method object.", e);
        }
    }

    public static class ReflectedField<C, F> {
        private final Field containedField;
        private final Class<F> fieldType;
        private final boolean isStaticConstant;
        private final F cachedConstant;
        private static final ImmutableMap<Class<?>, Class<?>> PRIMITIVE_TO_BOXED = new ImmutableMap.Builder().put(Byte.TYPE, Byte.class).put(Short.TYPE, Short.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Float.TYPE, Float.class).put(Double.TYPE, Double.class).put(Boolean.TYPE, Boolean.class).put(Character.TYPE, Character.class).build();

        public ReflectedField(@NotNull Class<C> fieldClass, @NotNull Class<F> fieldType, @NotNull String prettyName, @Nullable String intermediaryName) {
            String fieldName = EnvironmentDetection.isYarn || intermediaryName == null ? prettyName : intermediaryName;
            try {
                this.containedField = fieldClass.getDeclaredField(fieldName);
                this.fieldType = fieldType;
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException(String.format("Unable to find field with name: %s, %s", prettyName, intermediaryName), e);
            }
            this.containedField.setAccessible(true);
            if (!ReflectedField.getBoxedType(this.containedField).isAssignableFrom(fieldType)) {
                throw new IllegalArgumentException("Wrong field type! Check the generics type!");
            }
            int mod = this.containedField.getModifiers();
            if (Modifier.isFinal(mod) && Modifier.isStatic(mod)) {
                this.isStaticConstant = true;
                try {
                    this.cachedConstant = this.fieldType.cast(this.containedField.get(null));
                }
                catch (ClassCastException | IllegalAccessException e) {
                    throw new RuntimeException(String.format("Failed to get value of field: %s", this.containedField), e);
                }
            } else {
                this.isStaticConstant = false;
                this.cachedConstant = null;
            }
        }

        private static Class<?> getBoxedType(Field field) {
            Class fieldType = field.getType();
            Class mappedType = (Class)PRIMITIVE_TO_BOXED.get(fieldType);
            return mappedType == null ? fieldType : mappedType;
        }

        public void setFieldValue(C instance, F targetValue) {
            if (this.isStaticConstant) {
                throw new UnsupportedOperationException(String.format("Field %s is constant, modification not supported.", this.cachedConstant));
            }
            try {
                this.containedField.set(instance, targetValue);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(String.format("Failed to set value of field: %s", this.containedField), e);
            }
        }

        public F getFieldValue(C instance) {
            if (this.isStaticConstant) {
                return this.cachedConstant;
            }
            try {
                Object value = this.containedField.get(instance);
                Class<F> fieldType = this.fieldType;
                return fieldType.cast(value);
            }
            catch (ClassCastException | IllegalAccessException e) {
                throw new RuntimeException(String.format("Failed to get value of field: %s", this.containedField), e);
            }
        }
    }
}

