/*
 * Decompiled with CFR 0.152.
 */
package online.andrew2007.mythic.mixin;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import online.andrew2007.mythic.config.RuntimeController;
import online.andrew2007.mythic.injected.interfaces.ItemEntityMethodInjections;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1542.class})
public abstract class ItemEntityMixin
extends class_1297
implements ItemEntityMethodInjections {
    @Unique
    private final int worldMinY = this.method_37908().method_31607() + 1;
    @Shadow
    private int field_7204;
    @Unique
    private boolean isUnderProtection = false;

    public ItemEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Override
    public boolean mythicWorldTweaks$isUnderProtection() {
        return this.isUnderProtection;
    }

    @Override
    public void mythicWorldTweaks$setUnderProtection(boolean value) {
        this.isUnderProtection = value;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/entity/ItemEntity;merge(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;I)Lnet/minecraft/item/ItemStack;"), method={"merge(Lnet/minecraft/entity/ItemEntity;Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)V"}, index=2)
    private static int mergeCountFix(int maxCount) {
        if (RuntimeController.getCurrentTParams().itemEditorEnabled()) {
            return Integer.MAX_VALUE;
        }
        return maxCount;
    }

    @Shadow
    protected abstract double method_7490();

    @Unique
    private boolean isUnderProtection() {
        return RuntimeController.getCurrentTParams().playerDeathItemProtectionEnabled() && this.isUnderProtection;
    }

    @Inject(at={@At(value="RETURN")}, method={"getGravity"}, cancellable=true)
    private void getGravity(CallbackInfoReturnable<Double> info) {
        if (this.isUnderProtection() && this.method_23318() <= (double)this.worldMinY) {
            info.setReturnValue((Object)0.0);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;tick()V", shift=At.Shift.AFTER)}, method={"tick"})
    private void tick(CallbackInfo info) {
        if (this.isUnderProtection()) {
            class_2338 blockPosAbove = this.method_24515().method_10084();
            if (this.method_23318() <= (double)this.worldMinY + 0.3 && !this.method_37908().method_8320(blockPosAbove).method_26212((class_1922)this.method_37908(), blockPosAbove)) {
                this.method_18799(new class_243(this.method_18798().field_1352, 0.0, this.method_18798().field_1350));
                double relevantHeight = Math.abs(this.method_23318() - (double)this.worldMinY);
                if (relevantHeight <= 0.5) {
                    if (relevantHeight > 0.1) {
                        this.method_5814(this.method_23317(), this.worldMinY, this.method_23321());
                    } else {
                        this.method_18799(class_243.field_1353);
                    }
                } else {
                    this.method_5814(this.method_23317(), this.method_23318() + 0.5, this.method_23321());
                }
            }
            if (RuntimeController.getCurrentTParams().itemDiscardTicks() <= 0) {
                this.field_7204 = 0;
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"isFireImmune"}, cancellable=true)
    private void isFireImmune(CallbackInfoReturnable<Boolean> info) {
        if (this.isUnderProtection()) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"damage"}, cancellable=true)
    private void damage(CallbackInfoReturnable<Boolean> info) {
        if (this.isUnderProtection()) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tryMerge(Lnet/minecraft/entity/ItemEntity;)V"}, cancellable=true)
    private void tryMerge(class_1542 other, CallbackInfo info) {
        if (RuntimeController.getCurrentTParams().playerDeathItemProtectionEnabled() && this.mythicWorldTweaks$isUnderProtection() ^ other.mythicWorldTweaks$isUnderProtection()) {
            info.cancel();
        }
    }

    @ModifyConstant(constant={@Constant(intValue=6000)}, method={"tick"})
    private int discardTicks(int value) {
        int itemDiscardTicks = RuntimeController.getCurrentTParams().itemDiscardTicks();
        return itemDiscardTicks > 0 && this.isUnderProtection() ? itemDiscardTicks : value;
    }

    @Inject(at={@At(value="RETURN")}, method={"writeCustomDataToNbt"})
    private void writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10556("isUnderProtection", this.isUnderProtection);
    }

    @Inject(at={@At(value="RETURN")}, method={"readCustomDataFromNbt"})
    private void readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        this.isUnderProtection = nbt.method_10545("isUnderProtection") ? nbt.method_10577("isUnderProtection") : false;
    }
}

