/*
 * Decompiled with CFR 0.152.
 */
package online.andrew2007.mythic.mixin;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2899;
import net.minecraft.class_2913;
import net.minecraft.class_3248;
import net.minecraft.class_8594;
import net.minecraft.class_8595;
import net.minecraft.server.MinecraftServer;
import online.andrew2007.mythic.MythicWorldTweaks;
import online.andrew2007.mythic.config.RuntimeController;
import online.andrew2007.mythic.config.runtimeParams.TransmittableRuntimeParams;
import online.andrew2007.mythic.network.MythicNetwork;
import online.andrew2007.mythic.network.payloads.LoginConfigPushC2SPayload;
import online.andrew2007.mythic.network.payloads.LoginConfigPushS2CPayload;
import online.andrew2007.mythic.network.payloads.ValidationC2SPayload;
import online.andrew2007.mythic.network.payloads.ValidationS2CPayload;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3248.class}, priority=999)
public abstract class ServerLoginNetworkHandlerMixin {
    @Shadow
    @Final
    class_2535 field_14158;
    @Shadow
    @Final
    MinecraftServer field_14162;
    @Shadow
    private int field_14156;
    @Unique
    private boolean isValidationRequestSent = false;
    @Unique
    private boolean isValidationProcessed = false;
    @Unique
    private boolean isValidationPassed = false;
    @Unique
    private String failReason = "Player validation response timed out, you must have MythicWorldTweaks " + MythicWorldTweaks.MOD_VERSION + " installed and its \"server_play_support\" config enabled.";
    @Unique
    private int tickSincePush;
    @Unique
    private boolean isConfigPushed = false;
    @Unique
    private boolean isConfigPushResponded = false;
    @Unique
    private boolean isConfigPushSuccess = false;

    @Shadow
    public abstract void method_14380(class_2561 var1);

    @Inject(at={@At(value="HEAD")}, method={"tick"}, cancellable=true)
    private void tick(CallbackInfo info) {
        if (!this.field_14158.method_10756() && RuntimeController.getLocalRuntimeParams().serverPlaySupportEnabled()) {
            if (!this.isValidationRequestSent) {
                this.field_14158.method_10743((class_2596)new class_2899(MythicNetwork.registerRequest(ValidationS2CPayload.payloadId), (class_8595)new ValidationS2CPayload(RuntimeController.getLocalRuntimeParams().serverName(), MythicWorldTweaks.GAME_VERSION, MythicWorldTweaks.MOD_VERSION)));
                this.isValidationRequestSent = true;
            }
            if (!this.isValidationProcessed) {
                if (++this.field_14156 >= 60) {
                    this.method_14380(class_2561.method_30163((String)this.failReason));
                }
                info.cancel();
                return;
            }
            if (!this.isValidationPassed) {
                this.method_14380(class_2561.method_30163((String)this.failReason));
                info.cancel();
                return;
            }
            if (!this.isConfigPushed) {
                this.tickSincePush = this.field_14156;
                this.field_14158.method_10743((class_2596)new class_2899(MythicNetwork.registerRequest(LoginConfigPushS2CPayload.payloadId), (class_8595)new LoginConfigPushS2CPayload(RuntimeController.getCurrentTParams())));
                this.isConfigPushed = true;
            }
            if (!this.isConfigPushResponded) {
                if (++this.field_14156 >= this.tickSincePush + 60) {
                    this.method_14380(class_2561.method_30163((String)"Config push response timed out, regarded as failure."));
                }
                info.cancel();
            } else if (!this.isConfigPushSuccess) {
                this.method_14380(class_2561.method_30163((String)"Config push failed, received config is not equivalent to the server's."));
                info.cancel();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Inject(at={@At(value="HEAD")}, method={"onQueryResponse"}, cancellable=true)
    private void onQueryResponse(class_2913 packet, CallbackInfo info) {
        TransmittableRuntimeParams params;
        class_8594 rawPayload = packet.comp_1570();
        if (rawPayload == null) return;
        if (rawPayload instanceof ValidationC2SPayload) {
            Object allModIds;
            String modVersion;
            ValidationC2SPayload validationC2SPayload = (ValidationC2SPayload)rawPayload;
            try {
                Object object = validationC2SPayload.modVersion();
                modVersion = object;
                allModIds = object = validationC2SPayload.allModIds();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            this.field_14162.execute(() -> this.lambda$onQueryResponse$0(modVersion, (Set)allModIds));
            info.cancel();
            return;
        }
        if (!(rawPayload instanceof LoginConfigPushC2SPayload)) return;
        LoginConfigPushC2SPayload loginConfigPushC2SPayload = (LoginConfigPushC2SPayload)rawPayload;
        {
            TransmittableRuntimeParams transmittableRuntimeParams;
            params = transmittableRuntimeParams = loginConfigPushC2SPayload.params();
        }
        this.field_14162.execute(() -> {
            if (RuntimeController.getLocalRuntimeParams().serverPlaySupportEnabled()) {
                this.isConfigPushSuccess = params.equals(RuntimeController.getCurrentTParams());
                this.isConfigPushResponded = true;
            }
        });
        info.cancel();
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerLoginNetworkHandler;disconnect(Lnet/minecraft/text/Text;)V")}, method={"onQueryResponse"}, cancellable=true)
    private void handleAbnormalPacket(class_2913 packet, CallbackInfo info) {
        if (RuntimeController.getLocalRuntimeParams().serverPlaySupportEnabled()) {
            this.field_14162.execute(() -> {
                MythicWorldTweaks.LOGGER.warn("Received unrecognized login query response packet from client.");
                MythicWorldTweaks.LOGGER.warn("Maybe it is caused by missing mods, or simply the packet reflection from clients without MythicWorldTweaks");
            });
            info.cancel();
        }
    }

    private /* synthetic */ void lambda$onQueryResponse$0(String modVersion, Set allModIds) {
        if (RuntimeController.getLocalRuntimeParams().serverPlaySupportEnabled()) {
            boolean versionValidationFailed = false;
            boolean modIdsValidationFailed = false;
            if (!MythicWorldTweaks.MOD_VERSION.equals(modVersion)) {
                versionValidationFailed = true;
                this.failReason = String.format("The version of your MythicWorldTweaks is %s, while the version %s is required to join the server.", modVersion, MythicWorldTweaks.MOD_VERSION);
            }
            if (RuntimeController.getLocalRuntimeParams().modIdValidationEnabled() && !versionValidationFailed) {
                ImmutableSet submittedModIds = ImmutableSet.copyOf((Collection)allModIds);
                ImmutableSet requiredModIds = ImmutableSet.copyOf((Object[])RuntimeController.getLocalRuntimeParams().modIdList());
                ImmutableSet modIdsNotPresent = Sets.difference((Set)requiredModIds, (Set)submittedModIds).immutableCopy();
                if (!modIdsNotPresent.isEmpty()) {
                    modIdsValidationFailed = true;
                    StringBuilder missingModsMessage = new StringBuilder();
                    for (String modId : modIdsNotPresent) {
                        if (!missingModsMessage.isEmpty()) {
                            missingModsMessage.append(", ");
                        }
                        missingModsMessage.append(modId);
                    }
                    this.failReason = String.format("Some mods required by the server are missing on your side, please have them installed: %s", missingModsMessage);
                }
            }
            this.isValidationPassed = !versionValidationFailed && !modIdsValidationFailed;
            this.isValidationProcessed = true;
        }
    }
}

