/*
 * Decompiled with CFR 0.152.
 */
package online.andrew2007.mythic.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3468;
import net.minecraft.class_3902;
import online.andrew2007.mythic.config.RuntimeController;
import online.andrew2007.mythic.config.runtimeParams.TransmittableRuntimeParams;
import online.andrew2007.mythic.injected.interfaces.ServerPlayerEntityMethodInjections;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements ServerPlayerEntityMethodInjections {
    @Shadow
    public class_3244 field_13987;
    @Unique
    private byte pressTime;
    @Unique
    private byte singleClickInterval;
    @Unique
    private boolean isDuringValidation = false;
    @Unique
    private short pastValidationTicks = 0;
    @Unique
    private String failReason = null;
    @Unique
    private boolean isValidationProcessed = false;
    @Unique
    private boolean isValidationPassed = false;

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Override
    public void mythicWorldTweaks$onPlayConfigPush() {
        this.isDuringValidation = true;
        this.pastValidationTicks = 0;
        this.failReason = "Config push response timed out, regarded as failure.";
        this.isValidationProcessed = false;
        this.isValidationPassed = false;
    }

    @Override
    public void mythicWorldTweaks$onPlayConfigPushResponse(TransmittableRuntimeParams params) {
        if (RuntimeController.getCurrentTParams().equals(params)) {
            this.isValidationProcessed = true;
            this.isValidationPassed = true;
        } else {
            this.isValidationProcessed = true;
            this.isValidationPassed = false;
            this.failReason = "Config push failed, received config is not equivalent to the server's.";
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"}, cancellable=true)
    private void tick(CallbackInfo info) {
        if (RuntimeController.getCurrentTParams().playerRidingGestures()) {
            if (this.method_5715()) {
                this.pressTime = this.pressTime >= 0 && this.pressTime < 10 ? (byte)(this.pressTime + 1) : (byte)-1;
            } else {
                if (this.pressTime > 0 && this.pressTime <= 10) {
                    if (this.singleClickInterval > 0) {
                        this.method_5772();
                    }
                    this.singleClickInterval = 0;
                }
                this.pressTime = 0;
            }
            if (this.singleClickInterval >= 0) {
                this.singleClickInterval = this.singleClickInterval < 10 ? (byte)(this.singleClickInterval + 1) : (byte)-1;
            }
        }
        if (RuntimeController.getCurrentTParams().playerRidingProtection() && this.mythicWorldTweaks$isUnderFallProtection() && (this.method_24828() || this.method_52535() || this.method_6128() || this.method_7337() && this.method_31549().field_7479)) {
            this.mythicWorldTweaks$setUnderFallProtection(false);
        }
        if (RuntimeController.getLocalRuntimeParams().serverPlaySupportEnabled() && this.isDuringValidation) {
            if (!this.isValidationProcessed) {
                this.pastValidationTicks = (short)(this.pastValidationTicks + 1);
                if (this.pastValidationTicks >= 60) {
                    this.isDuringValidation = false;
                    this.field_13987.method_52396(class_2561.method_30163((String)this.failReason));
                    info.cancel();
                }
            } else if (!this.isValidationPassed) {
                this.field_13987.method_52396(class_2561.method_30163((String)this.failReason));
                info.cancel();
            } else {
                this.isDuringValidation = false;
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onDeath"})
    private void onDeath(class_1282 damageSource, CallbackInfo info) {
        this.mythicWorldTweaks$setUnderFallProtection(false);
        this.mythicWorldTweaks$setReallySleeping(false);
    }

    @Inject(at={@At(value="HEAD")}, method={"onDisconnect"})
    private void onDisconnect(CallbackInfo info) {
        class_1297 passenger = this.method_31483();
        if (RuntimeController.getCurrentTParams().playerRidingProtection() && passenger != null && passenger instanceof class_3222) {
            class_3222 playerPassenger = (class_3222)passenger;
            playerPassenger.mythicWorldTweaks$setUnderFallProtection(true);
        }
        this.mythicWorldTweaks$setReallySleeping(false);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;wakeUp(ZZ)V", shift=At.Shift.AFTER)}, method={"wakeUp"})
    private void wakeUp(boolean skipSleepTimer, boolean updateSleepingPlayers, CallbackInfo info) {
        this.mythicWorldTweaks$setReallySleeping(false);
    }

    @Inject(at={@At(value="RETURN", ordinal=4)}, method={"trySleep"}, cancellable=true)
    private void alwaysAbleToSleep(class_2338 pos, CallbackInfoReturnable<Either<class_1657.class_1658, class_3902>> info) {
        if (RuntimeController.getCurrentTParams().sleepingExtras()) {
            if (!this.method_7337()) {
                class_243 vec3d = class_243.method_24955((class_2382)pos);
                List list = this.method_37908().method_8390(class_1588.class, new class_238(vec3d.method_10216() - 8.0, vec3d.method_10214() - 5.0, vec3d.method_10215() - 8.0, vec3d.method_10216() + 8.0, vec3d.method_10214() + 5.0, vec3d.method_10215() + 8.0), entity -> entity.method_7076((class_1657)this));
                if (!list.isEmpty()) {
                    info.setReturnValue((Object)Either.left((Object)class_1657.class_1658.field_7532));
                    return;
                }
            }
            Either either = super.method_7269(pos).ifRight(unit -> this.method_7281(class_3468.field_15381));
            ((class_3218)this.method_37908()).method_8448();
            info.setReturnValue((Object)either);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/advancement/criterion/TickCriterion;trigger(Lnet/minecraft/server/network/ServerPlayerEntity;)V")}, method={"method_19504"}, cancellable=true)
    private void triggerAdvancement(class_3902 unit, CallbackInfo info) {
        if (RuntimeController.getCurrentTParams().sleepingExtras()) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"copyFrom"})
    private void copyFrom(class_3222 oldPlayer, boolean alive, CallbackInfo info) {
        if (!this.method_37908().method_8450().method_8355(class_1928.field_19389) && !oldPlayer.method_7325() && RuntimeController.getCurrentTParams().keepExperience()) {
            this.field_7520 = oldPlayer.field_7520;
            this.field_7495 = oldPlayer.field_7495;
            this.field_7510 = oldPlayer.field_7510;
            this.method_7320(oldPlayer.method_7272());
        }
    }
}

