/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.doomsmarkers;

import com.imjustdoom.doomsmarkers.Marker;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoomsMarkers {
    public static final String MOD_ID = "doomsmarkers";
    public static final String MOD_NAME = "Doom's Markers";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Doom's Markers");
    public static final class_2960 MARKER_SYNC_PACKET = new class_2960("doomsmarkers", "marker");
    public static final class_2960 ADD_MARKER_PACKET = new class_2960("doomsmarkers", "add");
    public static final class_2960 CALCULATE_MAP_MARKER_PACKET = new class_2960("doomsmarkers", "calculate_map");
    public static final class_2960 DELETE_MARKER_PACKET = new class_2960("doomsmarkers", "delete");
    public static final class_2960 UPDATE_MARKER_PACKET = new class_2960("doomsmarkers", "update");
    public static final List<class_2960> MARKER_ICONS = new ArrayList<class_2960>();
    public static final Map<class_3222, List<Marker>> MARKERS = new HashMap<class_3222, List<Marker>>();
    public static final int MAX_MARKERS_PER_PLAYER = 50;

    public static void init() {
        MARKER_ICONS.add(new class_2960(MOD_ID, "textures/block_marker.png"));
        MARKER_ICONS.add(new class_2960(MOD_ID, "textures/diamond_marker.png"));
        MARKER_ICONS.add(new class_2960(MOD_ID, "textures/monster_marker.png"));
        MARKER_ICONS.add(new class_2960(MOD_ID, "textures/square_marker.png"));
        MARKER_ICONS.add(new class_2960(MOD_ID, "textures/grave_marker.png"));
        MARKER_ICONS.add(new class_2960(MOD_ID, "textures/skele_marker.png"));
    }

    public static float[] argbIntToFloatArray(int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f};
    }

    public static void sendMarkerToPlayer(class_3222 player, Marker marker) {
        class_2520 encodedMarker = (class_2520)Marker.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)marker).getOrThrow(false, err -> System.err.println("Failed to encode marker: " + err));
        class_2487 wrapper = new class_2487();
        wrapper.method_10566("data", encodedMarker);
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10794(wrapper);
        player.field_13987.method_14364((class_2596)new class_2658(ADD_MARKER_PACKET, buf));
    }

    public static class_243 getWorldPosFromDecoration(class_22 mapData, class_20 decoration) {
        byte x = decoration.method_90();
        byte z = decoration.method_91();
        if (decoration.method_93() == class_20.class_21.field_86 || decoration.method_93() == class_20.class_21.field_87) {
            throw new IllegalArgumentException("Cannot reverse clamped decoration: position is out of map bounds");
        }
        byte scale = mapData.field_119;
        int i = 1 << scale;
        double centerX = mapData.field_116;
        double centerZ = mapData.field_115;
        double f = (double)x / 2.0;
        double f1 = (double)z / 2.0;
        double levelX = centerX + f * (double)i;
        double levelZ = centerZ + f1 * (double)i;
        return new class_243(levelX, 70.0, levelZ);
    }
}

