/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.doomsmarkers;

import com.imjustdoom.doomsmarkers.DoomsMarkers;
import com.imjustdoom.doomsmarkers.Marker;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4d;

public class DoomsMarkersClient {
    public static final class_304 MARKER_KEY_MAPPING = new class_304("category.doomsmarkers.use", class_3675.class_307.field_1668, 96, "key.categories.doomsmarkers");
    public static final class_304 TOGGLE_MARKER_KEY_MAPPING = new class_304("category.doomsmarkers.toggle", class_3675.class_307.field_1668, 77, "key.categories.doomsmarkers");
    public static final List<Marker> FOCUSED_MARKERS = new ArrayList<Marker>();
    public static final List<Marker> MARKERS = new ArrayList<Marker>();
    public static boolean KEY_USED_THIS_HOLD = false;
    public static boolean TOGGLED_MARKERS = true;

    public static void renderMarkers(class_332 context) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null || minecraft.field_1724 == null) {
            return;
        }
        FOCUSED_MARKERS.clear();
        if (!TOGGLED_MARKERS) {
            return;
        }
        class_4184 camera = minecraft.field_1773.method_19418();
        Vector3f cameraPos = camera.method_19326().method_46409();
        Matrix4f modelView = new Matrix4f().rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(camera.method_19329())).rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f)).translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        double fov = (float)((Integer)minecraft.field_1690.method_41808().method_41753()).intValue() * minecraft.field_1724.method_3118();
        Matrix4f projectionMatrix = minecraft.field_1773.method_22973(fov);
        for (Marker marker : new ArrayList<Marker>(MARKERS)) {
            boolean focused;
            Vector4d clipPos = new Vector4d(marker.getPosition().field_1352, marker.getPosition().field_1351, marker.getPosition().field_1350, 1.0);
            clipPos.mul((Matrix4fc)modelView);
            clipPos.mul((Matrix4fc)projectionMatrix);
            if (clipPos.w < 0.0) continue;
            float screenX = (float)((double)((float)context.method_51421() / 2.0f) * (1.0 + clipPos.x / clipPos.w));
            float screenY = (float)((double)((float)context.method_51443() / 2.0f) * (1.0 - clipPos.y / clipPos.w));
            if (screenX < -8.0f || screenX > (float)(context.method_51421() + 8) || screenY < -8.0f || screenY > (float)(context.method_51443() + 8)) continue;
            boolean bl = focused = screenX > (float)context.method_51421() / 2.0f - 12.0f && screenX < (float)context.method_51421() / 2.0f + 12.0f && screenY > (float)context.method_51443() / 2.0f - 12.0f && screenY < (float)context.method_51443() / 2.0f + 12.0f;
            if (focused) {
                FOCUSED_MARKERS.add(marker);
                if (MARKER_KEY_MAPPING.method_1434()) {
                    class_1792 encoded;
                    if (minecraft.field_1690.field_1886.method_1436()) {
                        MARKERS.remove(marker);
                        KEY_USED_THIS_HOLD = true;
                        class_2487 wrapper = new class_2487();
                        wrapper.method_10582("uuid", marker.getUuid().toString());
                        class_2540 buf = new class_2540(Unpooled.buffer());
                        buf.method_10794(wrapper);
                        minecraft.field_1724.field_3944.method_2883((class_2596)new class_2817(DoomsMarkers.DELETE_MARKER_PACKET, buf));
                    } else if (minecraft.field_1690.field_1871.method_1436()) {
                        marker.setIconIndex(-1);
                        marker.setItemIcon(minecraft.field_1724.method_5998(minecraft.field_1724.method_6058()).method_7909());
                        KEY_USED_THIS_HOLD = true;
                        encoded = (class_2520)Marker.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)marker).getOrThrow(false, err -> System.err.println("Failed to encode markers: " + err));
                        wrapper = new class_2487();
                        wrapper.method_10566("data", (class_2520)encoded);
                        buf = new class_2540(Unpooled.buffer());
                        buf.method_10794(wrapper);
                        minecraft.field_1724.field_3944.method_2883((class_2596)new class_2817(DoomsMarkers.UPDATE_MARKER_PACKET, buf));
                    } else if (minecraft.field_1690.field_1904.method_1436() && (encoded = minecraft.field_1724.method_5998(minecraft.field_1724.method_6058()).method_7909()) instanceof class_1769) {
                        class_1769 dye = (class_1769)encoded;
                        marker.setColour(DoomsMarkers.argbIntToFloatArray(dye.method_7802().method_16357()));
                        KEY_USED_THIS_HOLD = true;
                        encoded = (class_2520)Marker.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)marker).getOrThrow(false, err -> System.err.println("Failed to encode markers: " + err));
                        wrapper = new class_2487();
                        wrapper.method_10566("data", (class_2520)encoded);
                        buf = new class_2540(Unpooled.buffer());
                        buf.method_10794(wrapper);
                        minecraft.field_1724.field_3944.method_2883((class_2596)new class_2817(DoomsMarkers.UPDATE_MARKER_PACKET, buf));
                    }
                }
            }
            double distance = Math.sqrt(minecraft.field_1724.method_5649(marker.getPosition().field_1352, marker.getPosition().field_1351, marker.getPosition().field_1350));
            String distanceText = String.format("%.0fm", distance);
            class_4587 pose = context.method_51448();
            pose.method_22903();
            pose.method_46416(screenX - 8.0f, screenY - 8.0f, 0.0f);
            RenderSystem.setShader(class_757::method_34542);
            if (marker.getIconIndex() == -1) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(focused ? 1.0f : 0.5f));
                context.method_51427(marker.getItemIcon(), 0, 0);
                RenderSystem.setShaderColor((float)marker.getColour().get(0).floatValue(), (float)marker.getColour().get(1).floatValue(), (float)marker.getColour().get(2).floatValue(), (float)(focused ? 1.0f : 0.5f));
            } else {
                class_2960 icon = DoomsMarkers.MARKER_ICONS.get(marker.getIconIndex());
                RenderSystem.setShaderColor((float)marker.getColour().get(0).floatValue(), (float)marker.getColour().get(1).floatValue(), (float)marker.getColour().get(2).floatValue(), (float)(focused ? 1.0f : 0.5f));
                RenderSystem.setShaderTexture((int)0, (class_2960)icon);
                RenderSystem.enableBlend();
                context.method_25290(icon, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            class_327 font = minecraft.field_1772;
            int textWidth = font.method_1727(distanceText);
            pose.method_22904(8.0 - (double)textWidth / 2.0, 16.0, 0.0);
            context.method_25303(font, distanceText, 0, 0, 0xFFFFFF);
            RenderSystem.disableBlend();
            pose.method_22909();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void sendMarkerToServer(Marker marker) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        class_2520 encodedMarker = (class_2520)Marker.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)marker).getOrThrow(false, err -> System.err.println("Failed to encode marker: " + err));
        class_2487 wrapper = new class_2487();
        wrapper.method_10566("data", encodedMarker);
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10794(wrapper);
        class_310.method_1551().field_1724.field_3944.method_2883((class_2596)new class_2817(DoomsMarkers.ADD_MARKER_PACKET, buf));
    }
}

