/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.doomsmarkers;

import com.imjustdoom.doomsmarkers.Marker;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoomsMarkers {
    public static final String MOD_ID = "doomsmarkers";
    public static final String MOD_NAME = "Doom's Markers";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Doom's Markers");
    public static final ResourceLocation MARKER_SYNC_PACKET = new ResourceLocation("doomsmarkers", "marker");
    public static final ResourceLocation ADD_MARKER_PACKET = new ResourceLocation("doomsmarkers", "add");
    public static final ResourceLocation CALCULATE_MAP_MARKER_PACKET = new ResourceLocation("doomsmarkers", "calculate_map");
    public static final ResourceLocation DELETE_MARKER_PACKET = new ResourceLocation("doomsmarkers", "delete");
    public static final ResourceLocation UPDATE_MARKER_PACKET = new ResourceLocation("doomsmarkers", "update");
    public static final List<ResourceLocation> MARKER_ICONS = new ArrayList<ResourceLocation>();
    public static final Map<ServerPlayer, List<Marker>> MARKERS = new HashMap<ServerPlayer, List<Marker>>();
    public static final int MAX_MARKERS_PER_PLAYER = 50;

    public static void init() {
        MARKER_ICONS.add(new ResourceLocation(MOD_ID, "textures/block_marker.png"));
        MARKER_ICONS.add(new ResourceLocation(MOD_ID, "textures/diamond_marker.png"));
        MARKER_ICONS.add(new ResourceLocation(MOD_ID, "textures/monster_marker.png"));
        MARKER_ICONS.add(new ResourceLocation(MOD_ID, "textures/square_marker.png"));
        MARKER_ICONS.add(new ResourceLocation(MOD_ID, "textures/grave_marker.png"));
        MARKER_ICONS.add(new ResourceLocation(MOD_ID, "textures/skele_marker.png"));
    }

    public static float[] argbIntToFloatArray(int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f};
    }

    public static void sendMarkerToPlayer(ServerPlayer player, Marker marker) {
        Tag encodedMarker = (Tag)Marker.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)marker).getOrThrow(false, err -> System.err.println("Failed to encode marker: " + err));
        CompoundTag wrapper = new CompoundTag();
        wrapper.m_128365_("data", encodedMarker);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130079_(wrapper);
        player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(ADD_MARKER_PACKET, buf));
    }

    public static Vec3 getWorldPosFromDecoration(MapItemSavedData mapData, MapDecoration decoration) {
        byte x = decoration.m_77804_();
        byte z = decoration.m_77805_();
        if (decoration.m_77803_() == MapDecoration.Type.PLAYER_OFF_MAP || decoration.m_77803_() == MapDecoration.Type.PLAYER_OFF_LIMITS) {
            throw new IllegalArgumentException("Cannot reverse clamped decoration: position is out of map bounds");
        }
        byte scale = mapData.f_77890_;
        int i = 1 << scale;
        double centerX = mapData.f_256718_;
        double centerZ = mapData.f_256789_;
        double f = (double)x / 2.0;
        double f1 = (double)z / 2.0;
        double levelX = centerX + f * (double)i;
        double levelZ = centerZ + f1 * (double)i;
        return new Vec3(levelX, 70.0, levelZ);
    }
}

