/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.doomsmarkers;

import com.imjustdoom.doomsmarkers.DoomsMarkers;
import com.imjustdoom.doomsmarkers.Marker;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4d;

public class DoomsMarkersClient {
    public static final KeyMapping MARKER_KEY_MAPPING = new KeyMapping("category.doomsmarkers.use", InputConstants.Type.KEYSYM, 96, "key.categories.doomsmarkers");
    public static final KeyMapping TOGGLE_MARKER_KEY_MAPPING = new KeyMapping("category.doomsmarkers.toggle", InputConstants.Type.KEYSYM, 77, "key.categories.doomsmarkers");
    public static final List<Marker> FOCUSED_MARKERS = new ArrayList<Marker>();
    public static final List<Marker> MARKERS = new ArrayList<Marker>();
    public static boolean KEY_USED_THIS_HOLD = false;
    public static boolean TOGGLED_MARKERS = true;

    public static void renderMarkers(GuiGraphics context) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null || minecraft.f_91074_ == null) {
            return;
        }
        FOCUSED_MARKERS.clear();
        if (!TOGGLED_MARKERS) {
            return;
        }
        Camera camera = minecraft.f_91063_.m_109153_();
        Vector3f cameraPos = camera.m_90583_().m_252839_();
        Matrix4f modelView = new Matrix4f().rotate((Quaternionfc)Axis.f_252529_.m_252977_(camera.m_90589_())).rotate((Quaternionfc)Axis.f_252436_.m_252977_(camera.m_90590_() + 180.0f)).translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        double fov = (float)((Integer)minecraft.f_91066_.m_231837_().m_231551_()).intValue() * minecraft.f_91074_.m_108565_();
        Matrix4f projectionMatrix = minecraft.f_91063_.m_253088_(fov);
        for (Marker marker : new ArrayList<Marker>(MARKERS)) {
            boolean focused;
            Vector4d clipPos = new Vector4d(marker.getPosition().f_82479_, marker.getPosition().f_82480_, marker.getPosition().f_82481_, 1.0);
            clipPos.mul((Matrix4fc)modelView);
            clipPos.mul((Matrix4fc)projectionMatrix);
            if (clipPos.w < 0.0) continue;
            float screenX = (float)((double)((float)context.m_280182_() / 2.0f) * (1.0 + clipPos.x / clipPos.w));
            float screenY = (float)((double)((float)context.m_280206_() / 2.0f) * (1.0 - clipPos.y / clipPos.w));
            if (screenX < -8.0f || screenX > (float)(context.m_280182_() + 8) || screenY < -8.0f || screenY > (float)(context.m_280206_() + 8)) continue;
            boolean bl = focused = screenX > (float)context.m_280182_() / 2.0f - 12.0f && screenX < (float)context.m_280182_() / 2.0f + 12.0f && screenY > (float)context.m_280206_() / 2.0f - 12.0f && screenY < (float)context.m_280206_() / 2.0f + 12.0f;
            if (focused) {
                FOCUSED_MARKERS.add(marker);
                if (MARKER_KEY_MAPPING.m_90857_()) {
                    Item encoded;
                    if (minecraft.f_91066_.f_92096_.m_90859_()) {
                        MARKERS.remove(marker);
                        KEY_USED_THIS_HOLD = true;
                        CompoundTag wrapper = new CompoundTag();
                        wrapper.m_128359_("uuid", marker.getUuid().toString());
                        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                        buf.m_130079_(wrapper);
                        minecraft.f_91074_.f_108617_.m_104955_((Packet)new ServerboundCustomPayloadPacket(DoomsMarkers.DELETE_MARKER_PACKET, buf));
                    } else if (minecraft.f_91066_.f_92097_.m_90859_()) {
                        marker.setIconIndex(-1);
                        marker.setItemIcon(minecraft.f_91074_.m_21120_(minecraft.f_91074_.m_7655_()).m_41720_());
                        KEY_USED_THIS_HOLD = true;
                        encoded = (Tag)Marker.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)marker).getOrThrow(false, err -> System.err.println("Failed to encode markers: " + err));
                        wrapper = new CompoundTag();
                        wrapper.m_128365_("data", (Tag)encoded);
                        buf = new FriendlyByteBuf(Unpooled.buffer());
                        buf.m_130079_(wrapper);
                        minecraft.f_91074_.f_108617_.m_104955_((Packet)new ServerboundCustomPayloadPacket(DoomsMarkers.UPDATE_MARKER_PACKET, buf));
                    } else if (minecraft.f_91066_.f_92095_.m_90859_() && (encoded = minecraft.f_91074_.m_21120_(minecraft.f_91074_.m_7655_()).m_41720_()) instanceof DyeItem) {
                        DyeItem dye = (DyeItem)encoded;
                        marker.setColour(DoomsMarkers.argbIntToFloatArray(dye.m_41089_().m_41071_()));
                        KEY_USED_THIS_HOLD = true;
                        encoded = (Tag)Marker.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)marker).getOrThrow(false, err -> System.err.println("Failed to encode markers: " + err));
                        wrapper = new CompoundTag();
                        wrapper.m_128365_("data", (Tag)encoded);
                        buf = new FriendlyByteBuf(Unpooled.buffer());
                        buf.m_130079_(wrapper);
                        minecraft.f_91074_.f_108617_.m_104955_((Packet)new ServerboundCustomPayloadPacket(DoomsMarkers.UPDATE_MARKER_PACKET, buf));
                    }
                }
            }
            double distance = Math.sqrt(minecraft.f_91074_.m_20275_(marker.getPosition().f_82479_, marker.getPosition().f_82480_, marker.getPosition().f_82481_));
            String distanceText = String.format("%.0fm", distance);
            PoseStack pose = context.m_280168_();
            pose.m_85836_();
            pose.m_252880_(screenX - 8.0f, screenY - 8.0f, 0.0f);
            RenderSystem.setShader(GameRenderer::m_172817_);
            if (marker.getIconIndex() == -1) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(focused ? 1.0f : 0.5f));
                context.m_280480_(marker.getItemIcon(), 0, 0);
                RenderSystem.setShaderColor((float)marker.getColour().get(0).floatValue(), (float)marker.getColour().get(1).floatValue(), (float)marker.getColour().get(2).floatValue(), (float)(focused ? 1.0f : 0.5f));
            } else {
                ResourceLocation icon = DoomsMarkers.MARKER_ICONS.get(marker.getIconIndex());
                RenderSystem.setShaderColor((float)marker.getColour().get(0).floatValue(), (float)marker.getColour().get(1).floatValue(), (float)marker.getColour().get(2).floatValue(), (float)(focused ? 1.0f : 0.5f));
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon);
                RenderSystem.enableBlend();
                context.m_280163_(icon, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            Font font = minecraft.f_91062_;
            int textWidth = font.m_92895_(distanceText);
            pose.m_85837_(8.0 - (double)textWidth / 2.0, 16.0, 0.0);
            context.m_280488_(font, distanceText, 0, 0, 0xFFFFFF);
            RenderSystem.disableBlend();
            pose.m_85849_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void sendMarkerToServer(Marker marker) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        Tag encodedMarker = (Tag)Marker.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)marker).getOrThrow(false, err -> System.err.println("Failed to encode marker: " + err));
        CompoundTag wrapper = new CompoundTag();
        wrapper.m_128365_("data", encodedMarker);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130079_(wrapper);
        Minecraft.m_91087_().f_91074_.f_108617_.m_104955_((Packet)new ServerboundCustomPayloadPacket(DoomsMarkers.ADD_MARKER_PACKET, buf));
    }
}

