/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.doomsmarkers;

import com.imjustdoom.doomsmarkers.DoomsMarkers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class Marker {
    public static Codec<Marker> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.f_235867_.fieldOf("uuid").forGetter(Marker::getUuid), (App)Vec3.f_231074_.fieldOf("position").forGetter(Marker::getPosition), (App)Codec.FLOAT.listOf().fieldOf("colour").forGetter(Marker::getColour), (App)Codec.INT.fieldOf("iconIndex").forGetter(Marker::getIconIndex), (App)ItemStack.f_41582_.fieldOf("itemIcon").forGetter(Marker::getItemIcon)).apply((Applicative)instance, Marker::new));
    private UUID uuid;
    private Vec3 position;
    private List<Float> colour;
    private int iconIndex;
    private ItemStack itemIcon;

    public Marker(Vec3 position, List<Float> colour, int iconIndex) {
        this(UUID.randomUUID(), position, colour, iconIndex, ItemStack.f_41583_);
    }

    public Marker(Vec3 position, List<Float> colour, Item itemIcon) {
        this(position, colour, -1, itemIcon);
    }

    public Marker(Vec3 position, List<Float> colour, int iconIndex, Item itemIcon) {
        this(UUID.randomUUID(), position, colour, iconIndex, new ItemStack((ItemLike)itemIcon));
    }

    public Marker(UUID uuid, Vec3 position, List<Float> colour, int iconIndex, ItemStack itemIcon) {
        this.uuid = uuid;
        this.position = position;
        this.colour = colour;
        this.iconIndex = iconIndex;
        this.itemIcon = itemIcon;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public List<Float> getColour() {
        return this.colour;
    }

    public void setColour(float[] colour) {
        ArrayList<Float> list = new ArrayList<Float>();
        for (float value : colour) {
            list.add(Float.valueOf(value));
        }
        this.colour = list;
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public void setIconIndex(int iconIndex) {
        this.iconIndex = iconIndex;
    }

    public void changeIconIndex(boolean negative) {
        if (negative) {
            if (this.iconIndex-- <= -1) {
                this.iconIndex = DoomsMarkers.MARKER_ICONS.size() - 1;
            }
        } else {
            this.iconIndex = this.iconIndex + 1 >= DoomsMarkers.MARKER_ICONS.size() ? -1 : ++this.iconIndex;
        }
    }

    public ItemStack getItemIcon() {
        return this.itemIcon;
    }

    public void setItemIcon(Item itemIcon) {
        this.itemIcon = new ItemStack((ItemLike)itemIcon);
    }

    public String toString() {
        return this.getPosition().toString() + ", " + String.valueOf(this.getColour()) + ", " + this.getIconIndex();
    }
}

