/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.doomsmarkers.mixin;

import com.imjustdoom.doomsmarkers.DoomsMarkers;
import com.imjustdoom.doomsmarkers.Marker;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends LivingEntity {
    protected ServerPlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"die"}, at={@At(value="TAIL")})
    public void onDeath(DamageSource damageSource, CallbackInfo ci) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Marker marker = new Marker(new Vec3(this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.75, this.m_20182_().f_82481_), List.of(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)), 4);
        DoomsMarkers.MARKERS.get((ServerPlayer)this).add(marker);
        DoomsMarkers.sendMarkerToPlayer((ServerPlayer)this, marker);
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    public void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        if (!DoomsMarkers.MARKERS.containsKey(player)) {
            DoomsMarkers.LOG.info("No Markers exist for {} to save", (Object)player.m_7755_().getString());
            return;
        }
        Tag encodedList = (Tag)Marker.CODEC.listOf().encodeStart((DynamicOps)NbtOps.f_128958_, DoomsMarkers.MARKERS.get(player)).getOrThrow(false, err -> System.err.println("Save encode error: " + err));
        compoundTag.m_128365_("Markers", encodedList);
        DoomsMarkers.LOG.info("Saved {} markers for {}", (Object)DoomsMarkers.MARKERS.get(player).size(), (Object)player.m_7755_().getString());
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    public void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        if (!compoundTag.m_128425_("Markers", 9)) {
            DoomsMarkers.LOG.info("No Markers exist for {}", (Object)player.m_7755_().getString());
            DoomsMarkers.MARKERS.put(player, new ArrayList());
            return;
        }
        ListTag markersList = compoundTag.m_128437_("Markers", 10);
        List markers = (List)Marker.CODEC.listOf().parse((DynamicOps)NbtOps.f_128958_, (Object)markersList).getOrThrow(false, err -> System.err.println("Load parse error: " + err));
        DoomsMarkers.LOG.info("Loaded {} markers for {}", (Object)markers.size(), (Object)player.m_7755_().getString());
        DoomsMarkers.MARKERS.put(player, new ArrayList(markers));
    }
}

