/*
 * Decompiled with CFR 0.152.
 */
package com.periut.chisel.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class ChiselGroupLookup {
    private static final Map<String, ChiselGroup> CHISEL_GROUPS = new HashMap<String, ChiselGroup>();

    private ChiselGroupLookup() {
    }

    public static Iterator<String> getGroupNameIterator() {
        return CHISEL_GROUPS.keySet().iterator();
    }

    public static void addGroup(String name) {
        if (!CHISEL_GROUPS.keySet().contains(name)) {
            CHISEL_GROUPS.put(name, new ChiselGroup());
        }
    }

    public static void addItemToGroup(String name, ResourceLocation id) {
        if (!CHISEL_GROUPS.keySet().contains(name)) {
            ChiselGroupLookup.addGroup(name);
        }
        CHISEL_GROUPS.get(name).addItem(id);
    }

    public static void addItemToGroup(String name, List<ResourceLocation> id) {
        if (!CHISEL_GROUPS.keySet().contains(name)) {
            ChiselGroupLookup.addGroup(name);
        }
        for (int i = 0; i < id.size(); ++i) {
            CHISEL_GROUPS.get(name).addItem(id.get(i));
        }
    }

    public static void addTagToGroup(String name, ResourceLocation id) {
        if (!CHISEL_GROUPS.keySet().contains(name)) {
            ChiselGroupLookup.addGroup(name);
        }
        CHISEL_GROUPS.get(name).addTag(id);
    }

    public static void addTagToGroup(String name, List<ResourceLocation> id) {
        if (!CHISEL_GROUPS.keySet().contains(name)) {
            ChiselGroupLookup.addGroup(name);
        }
        for (int i = 0; i < id.size(); ++i) {
            CHISEL_GROUPS.get(name).addTag(id.get(i));
        }
    }

    public static ChiselGroup getGroup(Item item) {
        Iterator<ChiselGroup> chiselGroupIterator = CHISEL_GROUPS.values().iterator();
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        while (chiselGroupIterator.hasNext()) {
            ChiselGroup group = chiselGroupIterator.next();
            if (!group.containsItem(itemId)) continue;
            return group;
        }
        return null;
    }

    public static List<Item> getBlocksInGroup(String name) {
        ChiselGroup group = CHISEL_GROUPS.get(name);
        if (group != null) {
            return ChiselGroupLookup.getBlocksInGroup(group);
        }
        return new ArrayList<Item>();
    }

    public static List<Item> getBlocksInGroup(Item item) {
        ChiselGroup group = ChiselGroupLookup.getGroup(item);
        if (group != null) {
            return ChiselGroupLookup.getBlocksInGroup(group);
        }
        return new ArrayList<Item>();
    }

    public static List<Item> getBlocksInGroup(ChiselGroup group) {
        ArrayList<Item> groupItems = new ArrayList<Item>();
        groupItems.addAll(group.getItems());
        return groupItems;
    }

    public static List<ResourceLocation> getTagsFor(Item item) {
        ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>();
        return tags;
    }

    public static class ChiselGroup {
        private final List<ResourceLocation> items = new ArrayList<ResourceLocation>();
        private final List<ResourceLocation> tags = new ArrayList<ResourceLocation>();

        public void addItem(ResourceLocation item) {
            this.items.add(item);
        }

        public void addTag(ResourceLocation tag) {
            this.tags.add(tag);
        }

        public boolean containsItem(ResourceLocation item) {
            return this.inItems(item) || this.inTags(item);
        }

        public boolean inItems(ResourceLocation item) {
            return this.items.contains(item);
        }

        public boolean inTags(ResourceLocation id) {
            return false;
        }

        public List<Item> getItems() {
            ArrayList<Item> itemsInGroup = new ArrayList<Item>();
            for (int i = 0; i < this.items.size(); ++i) {
                Item item = (Item)BuiltInRegistries.ITEM.getValue(this.items.get(i));
                if (item.equals(Items.AIR)) continue;
                itemsInGroup.add(item);
            }
            ArrayList<Item> itemsInGroupNoDupes = new ArrayList<Item>();
            for (int i = 0; i < itemsInGroup.size(); ++i) {
                Item item = (Item)itemsInGroup.get(i);
                if (itemsInGroupNoDupes.contains(item)) continue;
                itemsInGroupNoDupes.add(item);
            }
            return itemsInGroupNoDupes;
        }
    }
}

