/*
 * Decompiled with CFR 0.152.
 */
package com.periut.chisel.gui;

import com.periut.chisel.gui.BigSlot;
import com.periut.chisel.mixins.HandledScreenAccessor;
import com.periut.cryonicconfig.CryonicConfig;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ChiselScreen
extends AbstractContainerScreen<AbstractContainerMenu> {
    boolean compactTexture = CryonicConfig.getConfig((String)"chisel").getBoolean("compact_chisel_gui", false);
    public static final ResourceLocation OLD_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"chisel", (String)"textures/chiselfabricgui.png");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"chisel", (String)"textures/chisel2gui.png");
    public static final int OLD_TEXTURE_WIDTH = 194;
    public static final int OLD_TEXTURE_HEIGHT = 209;
    public static final int TEXTURE_WIDTH = 248;
    public static final int TEXTURE_HEIGHT = 202;

    public ChiselScreen(AbstractContainerMenu handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
        if (this.compactTexture) {
            this.titleLabelY = 5;
            this.imageWidth = 194;
            this.imageHeight = 209;
        } else {
            this.titleLabelX = 18;
            this.titleLabelY = 62;
            this.imageWidth = 248;
            this.imageHeight = 202;
        }
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (this.compactTexture) {
            context.blit(RenderPipelines.GUI_TEXTURED, OLD_TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        } else {
            context.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
    }

    protected void init() {
        super.init();
        if (this.compactTexture) {
            this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        }
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
        context.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    protected void renderSlot(GuiGraphics context, Slot slot) {
        ResourceLocation identifier;
        int k;
        int slotSize;
        int i = slot.x;
        int j = slot.y;
        ItemStack itemStack = slot.getItem();
        boolean bl = false;
        boolean bl2 = slot == ((HandledScreenAccessor)((Object)this)).getTouchDragSlotStart() && !((HandledScreenAccessor)((Object)this)).getTouchDragStack().isEmpty() && !((HandledScreenAccessor)((Object)this)).getTouchIsRightClickDrag();
        ItemStack itemStack2 = this.menu.getCarried();
        String string = null;
        boolean isBigSlot = slot instanceof BigSlot && ((BigSlot)slot).isBigSlot();
        int n = slotSize = isBigSlot ? 32 : 16;
        if (slot == ((HandledScreenAccessor)((Object)this)).getTouchDragSlotStart() && !((HandledScreenAccessor)((Object)this)).getTouchDragStack().isEmpty() && ((HandledScreenAccessor)((Object)this)).getTouchIsRightClickDrag() && !itemStack.isEmpty()) {
            itemStack = itemStack.copyWithCount(itemStack.getCount() / 2);
        } else if (this.isQuickCrafting && this.quickCraftSlots.contains(slot) && !itemStack2.isEmpty()) {
            if (this.quickCraftSlots.size() == 1) {
                return;
            }
            if (AbstractContainerMenu.canItemQuickReplace((Slot)slot, (ItemStack)itemStack2, (boolean)true) && this.menu.canDragTo(slot)) {
                bl = true;
                k = Math.min(itemStack2.getMaxStackSize(), slot.getMaxStackSize(itemStack2));
                int l = slot.getItem().isEmpty() ? 0 : slot.getItem().getCount();
                int m = AbstractContainerMenu.getQuickCraftPlaceCount((Set)this.quickCraftSlots, (int)((HandledScreenAccessor)((Object)this)).getHeldButtonType(), (ItemStack)itemStack2) + l;
                if (m > k) {
                    m = k;
                    String var10000 = ChatFormatting.YELLOW.toString();
                    string = var10000 + k;
                }
                itemStack = itemStack2.copyWithCount(m);
            } else {
                this.quickCraftSlots.remove(slot);
                ((HandledScreenAccessor)((Object)this)).invokeCalculateOffset();
            }
        }
        if (itemStack.isEmpty() && slot.isActive() && (identifier = slot.getNoItemIcon()) != null) {
            if (isBigSlot) {
                context.pose().pushMatrix();
                context.pose().translate((float)i, (float)j);
                context.pose().scale(2.0f, 2.0f);
                context.blitSprite(RenderPipelines.GUI_TEXTURED, identifier, 0, 0, 16, 16);
                context.pose().popMatrix();
            } else {
                context.blitSprite(RenderPipelines.GUI_TEXTURED, identifier, i, j, 16, 16);
            }
            bl2 = true;
        }
        if (!bl2) {
            if (bl) {
                context.fill(i, j, i + slotSize, j + slotSize, -2130706433);
            }
            k = slot.x + slot.y * this.imageWidth;
            if (isBigSlot) {
                context.pose().pushMatrix();
                context.pose().translate((float)(i - 8), (float)(j - 8));
                context.pose().scale(2.0f, 2.0f);
                if (slot.isFake()) {
                    context.renderFakeItem(itemStack, 0, 0, k);
                } else {
                    context.renderItem(itemStack, 0, 0, k);
                }
                if (slot.index < 1 || slot.index > 60) {
                    context.renderItemDecorations(this.font, itemStack, 0, 0, string);
                }
                context.pose().popMatrix();
            } else {
                if (slot.isFake()) {
                    context.renderFakeItem(itemStack, i, j, k);
                } else {
                    context.renderItem(itemStack, i, j, k);
                }
                if (slot.index < 1 || slot.index > 60) {
                    context.renderItemDecorations(this.font, itemStack, i, j, string);
                }
            }
        }
    }
}

