/*
 * Decompiled with CFR 0.152.
 */
package com.periut.chisel.gui;

import com.periut.chisel.Chisel;
import com.periut.chisel.gui.BigSlot;
import com.periut.chisel.inventory.ChiselInventory;
import com.periut.chisel.inventory.InventoryUtil;
import com.periut.chisel.item.ChiselItem;
import com.periut.cryonicconfig.CryonicConfig;
import java.time.LocalTime;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;

public class ChiselScreenHandler
extends AbstractContainerMenu {
    boolean compactTexture;
    private final ChiselInventory inventory;
    private final BundleContents componentInventory;
    LocalTime currentTime = LocalTime.now();

    public ChiselScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, new ChiselInventory());
    }

    public ChiselScreenHandler(int syncId, Inventory playerInventory, Container inventory) {
        this(syncId, playerInventory, inventory, new BundleContents(new ArrayList()));
    }

    public ChiselScreenHandler(int syncId, Inventory playerInventory, Container inventory, BundleContents component) {
        super(Chisel.CHISEL_SCREEN_HANDLER.get(), syncId);
        this.compactTexture = CryonicConfig.getConfig((String)"chisel").getBoolean("compact_chisel_gui", false);
        ChiselScreenHandler.checkContainerSize((Container)inventory, (int)61);
        this.inventory = (ChiselInventory)inventory;
        this.componentInventory = component;
        if (this.compactTexture) {
            int y;
            int x;
            this.addSlot(new Slot(inventory, 0, 8, 145));
            for (x = 0; x < 10; ++x) {
                for (y = 0; y < 6; ++y) {
                    this.addSlot(new SlotChiselOutput(inventory, 1 + x + 10 * y, 62 + 18 * x - 54, 8 + 18 * y + 7));
                }
            }
            for (x = 0; x < 9; ++x) {
                for (y = 0; y < 3; ++y) {
                    this.addSlot(new Slot((Container)playerInventory, 9 + x + 9 * y, 71 + 18 * x - 45, 120 + 18 * y + 7));
                }
            }
            for (x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x, 71 + 18 * x - 45, 185));
            }
        } else {
            int y;
            int x;
            this.addSlot(((BigSlot)new Slot(inventory, 0, 24, 24)).setBigSlot(true));
            for (x = 0; x < 10; ++x) {
                for (y = 0; y < 6; ++y) {
                    this.addSlot(new SlotChiselOutput(inventory, 1 + x + 10 * y, 62 + 18 * x, 8 + 18 * y));
                }
            }
            for (x = 0; x < 9; ++x) {
                for (y = 0; y < 3; ++y) {
                    this.addSlot(new Slot((Container)playerInventory, 9 + x + 9 * y, 71 + 18 * x, 120 + 18 * y));
                }
            }
            for (x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x, 71 + 18 * x, 178));
            }
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot != null && slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (originalStack.getItem().equals(Chisel.chiselSupplier.get())) {
                return ItemStack.EMPTY;
            }
            if (invSlot < this.inventory.getContainerSize()) {
                if (invSlot != 0) {
                    int count;
                    if (((Slot)this.slots.get(0)).hasItem() && (count = ((Slot)this.slots.get(0)).getItem().getCount()) > 0 && count <= 99) {
                        originalStack.setCount(count);
                    }
                    ChiselItem.chiselSound(player.level(), player.blockPosition());
                }
                if (!this.moveItemStackTo(originalStack, this.inventory.getContainerSize(), this.slots.size(), true)) {
                    this.inventory.refresh(((Slot)this.slots.get(0)).getItem().getItem());
                    return ItemStack.EMPTY;
                }
                this.inventory.clearContent();
            } else if (!this.moveItemStackTo(originalStack, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    public void removed(Player player) {
        ItemStack chiselStack;
        super.removed(player);
        ItemStack hand = player.getItemInHand(InteractionHand.MAIN_HAND);
        this.sanitizeInventory(player.getInventory());
        if (!hand.is(Chisel.chiselSupplier.get()) && (chiselStack = this.findChiselInInventory(player)) != null && !chiselStack.isEmpty() && chiselStack.getCount() > 0) {
            chiselStack = chiselStack.copyWithCount(Math.max(1, Math.min(chiselStack.getCount(), chiselStack.getMaxStackSize())));
            player.getInventory().removeItemNoUpdate(player.getInventory().findSlotMatchingItem(chiselStack));
            player.getInventory().setItem(0, chiselStack);
        }
        if (this.inventory.isEmpty()) {
            c = InventoryUtil.createBundleComponent(this.inventory);
            DataComponentPatch changes = DataComponentPatch.builder().remove(DataComponents.BUNDLE_CONTENTS).build();
            hand.applyComponentsAndValidate(changes);
        } else {
            c = InventoryUtil.createBundleComponent(this.inventory);
            DataComponentPatch changes = DataComponentPatch.builder().remove(DataComponents.BUNDLE_CONTENTS).set(DataComponents.BUNDLE_CONTENTS, (Object)c).build();
            hand.applyComponentsAndValidate(changes);
        }
    }

    private ItemStack findChiselInInventory(Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!stack.is(Chisel.chiselSupplier.get()) || stack.getCount() <= 0) continue;
            return stack;
        }
        return null;
    }

    private void sanitizeInventory(Inventory inventory) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack == null || stack.isEmpty() || stack.getCount() <= 0) {
                inventory.setItem(i, ItemStack.EMPTY);
                continue;
            }
            int sanitizedCount = Math.max(1, Math.min(stack.getCount(), stack.getMaxStackSize()));
            if (sanitizedCount == stack.getCount()) continue;
            inventory.setItem(i, stack.copyWithCount(sanitizedCount));
        }
    }

    public void clicked(int i, int j, ClickType actionType, Player playerEntity) {
        if (i >= 0 && i < this.slots.size()) {
            Slot slot = (Slot)this.slots.get(i);
            if (slot.getItem().getItem() instanceof ChiselItem) {
                return;
            }
            ItemStack outputStack = slot.getItem();
            ItemStack inputStack = ((Slot)this.slots.get(0)).getItem();
            ItemStack cursorStack = playerEntity.containerMenu.getCarried();
            if (actionType == ClickType.PICKUP && j == 1 && i > 0 && i < this.inventory.getContainerSize() && !outputStack.isEmpty() && ((Slot)this.slots.get(0)).hasItem() && inputStack.getCount() > 1) {
                int half = inputStack.getCount() / 2;
                if (!cursorStack.isEmpty()) {
                    if (!cursorStack.is(outputStack.getItem()) || cursorStack.getCount() >= cursorStack.getMaxStackSize()) {
                        return;
                    }
                    if (cursorStack.getCount() + half > cursorStack.getMaxStackSize()) {
                        inputStack.shrink(cursorStack.getMaxStackSize() - cursorStack.getCount());
                        cursorStack.grow(cursorStack.getMaxStackSize() - cursorStack.getCount());
                    } else {
                        inputStack.shrink(half);
                        cursorStack.grow(half);
                    }
                } else {
                    ItemStack newCursorStack = outputStack.copy();
                    newCursorStack.setCount(half);
                    inputStack.shrink(half);
                    playerEntity.containerMenu.setCarried(newCursorStack);
                }
                this.markSlotsAndPlaySound(slot, playerEntity);
                return;
            }
            if (actionType == ClickType.PICKUP && i > 0 && i < this.inventory.getContainerSize() && ((Slot)this.slots.get(0)).getItem().getCount() == 1 && !cursorStack.isEmpty() && cursorStack.getCount() < cursorStack.getMaxStackSize() && cursorStack.is(outputStack.getItem())) {
                ((Slot)this.slots.get(0)).setByPlayer(ItemStack.EMPTY);
                cursorStack.grow(1);
                this.markSlotsAndPlaySound(slot, playerEntity);
                return;
            }
            if (actionType == ClickType.PICKUP && j == 0 && i > 0 && i < this.inventory.getContainerSize() && !cursorStack.isEmpty() && cursorStack.getCount() < cursorStack.getMaxStackSize() && cursorStack.is(outputStack.getItem())) {
                if (cursorStack.getCount() + inputStack.getCount() > cursorStack.getMaxStackSize()) {
                    inputStack.shrink(cursorStack.getMaxStackSize() - cursorStack.getCount());
                    cursorStack.grow(cursorStack.getMaxStackSize() - cursorStack.getCount());
                } else {
                    cursorStack.grow(inputStack.getCount());
                    ((Slot)this.slots.get(0)).setByPlayer(ItemStack.EMPTY);
                }
                this.markSlotsAndPlaySound(slot, playerEntity);
                return;
            }
        }
        ItemStack before = ((Slot)this.slots.get(0)).getItem().copy();
        super.clicked(i, j, actionType, playerEntity);
        ItemStack after = ((Slot)this.slots.get(0)).getItem();
        if (!(i <= 0 || i >= this.inventory.getContainerSize() || ItemStack.isSameItem((ItemStack)before, (ItemStack)after) && before.getCount() == after.getCount())) {
            ChiselItem.chiselSound(playerEntity.level(), playerEntity.blockPosition());
        }
    }

    private void markSlotsAndPlaySound(Slot slot, Player playerEntity) {
        ((Slot)this.slots.get(0)).setChanged();
        slot.setChanged();
        ChiselItem.chiselSound(playerEntity.level(), playerEntity.blockPosition());
    }

    private static class SlotChiselOutput
    extends Slot {
        public SlotChiselOutput(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public void onTake(Player player, ItemStack stack) {
            this.container.clearContent();
            super.onTake(player, stack);
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public int getMaxStackSize() {
            return 64;
        }
    }
}

