/*
 * Decompiled with CFR 0.152.
 */
package com.periut.chisel.mixins;

import com.periut.chisel.gui.BigSlot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class HandledScreenMixin
extends Screen {
    @Shadow
    protected Slot hoveredSlot;
    @Shadow
    @Final
    private static ResourceLocation SLOT_HIGHLIGHT_BACK_SPRITE;
    @Shadow
    @Final
    private static ResourceLocation SLOT_HIGHLIGHT_FRONT_SPRITE;
    @Shadow
    protected int leftPos;

    protected HandledScreenMixin(Component title) {
        super(title);
    }

    @Shadow
    protected abstract boolean isHovering(int var1, int var2, int var3, int var4, double var5, double var7);

    @Unique
    public final void drawSlotHighlightBackBig(GuiGraphics context) {
        if (this.hoveredSlot != null && ((BigSlot)this.hoveredSlot).isBigSlot()) {
            context.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_BACK_SPRITE, this.hoveredSlot.x - 20, this.hoveredSlot.y - 20, 56, 56);
        }
    }

    @Unique
    public final void drawSlotHighlightFrontBig(GuiGraphics context) {
        if (this.hoveredSlot != null && ((BigSlot)this.hoveredSlot).isBigSlot()) {
            context.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_FRONT_SPRITE, this.hoveredSlot.x - 20, this.hoveredSlot.y - 20, 56, 56);
        }
    }

    @Inject(method={"renderContents(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderSlotHighlightBack(Lnet/minecraft/client/gui/GuiGraphics;)V")})
    void back(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        this.drawSlotHighlightBackBig(context);
    }

    @Inject(method={"renderContents(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderSlotHighlightFront(Lnet/minecraft/client/gui/GuiGraphics;)V")})
    void front(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        this.drawSlotHighlightFrontBig(context);
    }

    @Inject(method={"isHovering(Lnet/minecraft/world/inventory/Slot;DD)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isPointOverSlotBig(Slot slot, double pointX, double pointY, CallbackInfoReturnable<Boolean> cir) {
        if (((BigSlot)slot).isBigSlot()) {
            cir.setReturnValue((Object)this.isHovering(slot.x - 16, slot.y - 16, 48, 48, pointX, pointY));
        }
    }
}

