/*
 * Decompiled with CFR 0.152.
 */
package com.periut.chisel.platform.neoforge;

import com.periut.chisel.platform.RegistryHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RegistryHelperImpl {
    private static final List<Supplier<Item>> REGISTERED_ITEM_SUPPLIERS = new ArrayList<Supplier<Item>>();
    private static final Map<ResourceKey<?>, DeferredRegister<?>> DEFERRED_REGISTERS = new HashMap();
    private static IEventBus eventBus;

    private static <T> DeferredRegister<T> getOrCreateRegister(Registry<? super T> registry) {
        ResourceKey registryKey = registry.key();
        DeferredRegister deferredRegister = DEFERRED_REGISTERS.get(registryKey);
        if (deferredRegister == null) {
            deferredRegister = DeferredRegister.create((ResourceKey)registryKey, (String)"chisel");
            DEFERRED_REGISTERS.put(registryKey, deferredRegister);
            if (eventBus != null) {
                deferredRegister.register(eventBus);
            }
        }
        return deferredRegister;
    }

    public static void init(IEventBus modEventBus) {
        eventBus = modEventBus;
        DEFERRED_REGISTERS.values().forEach(register -> register.register(modEventBus));
    }

    public static <T> Supplier<T> register(Registry<? super T> registry, ResourceLocation id, Supplier<T> supplier) {
        DeferredRegister<? super T> deferredRegister = RegistryHelperImpl.getOrCreateRegister(registry);
        DeferredHolder holder = deferredRegister.register(id.getPath(), supplier);
        if (registry == BuiltInRegistries.ITEM) {
            REGISTERED_ITEM_SUPPLIERS.add((Supplier<Item>)holder);
        }
        return holder;
    }

    public static RegistryHelper.ItemGroupRegistration registerItemGroup(ResourceLocation id, Supplier<Component> displayName, Supplier<ItemStack> icon) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)id);
        DeferredRegister deferredRegister = RegistryHelperImpl.getOrCreateRegister(BuiltInRegistries.CREATIVE_MODE_TAB);
        DeferredHolder holder = deferredRegister.register(id.getPath(), () -> CreativeModeTab.builder().icon(icon).title((Component)displayName.get()).build());
        return new RegistryHelper.ItemGroupRegistration((Supplier<CreativeModeTab>)holder, (ResourceKey<CreativeModeTab>)key);
    }

    public static List<Item> getRegisteredItems() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Supplier<Item> supplier : REGISTERED_ITEM_SUPPLIERS) {
            items.add(supplier.get());
        }
        return items;
    }
}

