/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.google.common.collect.Multimap;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.SurveyorNetworking;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.NetworkHandlerSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.packet.C2SKnownLandmarksPacket;
import folk.sisby.surveyor.packet.C2SKnownStructuresPacket;
import folk.sisby.surveyor.packet.C2SKnownTerrainPacket;
import folk.sisby.surveyor.packet.S2CGroupAmendedPacket;
import folk.sisby.surveyor.packet.S2CGroupChangedPacket;
import folk.sisby.surveyor.packet.S2CGroupUpdatedPacket;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRequestedPacket;
import folk.sisby.surveyor.util.MapUtil;
import java.util.BitSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_638;

public class SurveyorClientNetworking {
    public static void init() {
        SurveyorNetworking.C2S_SENDER = p -> {
            if (!ClientPlayNetworking.canSend((class_2960)p.getId())) {
                return;
            }
            p.toBufs().forEach(buf -> ClientPlayNetworking.send((class_2960)p.getId(), (class_2540)buf));
        };
        ClientPlayNetworking.registerGlobalReceiver((class_2960)S2CUpdateRegionPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, S2CUpdateRegionPacket::read, SurveyorClientNetworking::handleTerrainAdded));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)S2CStructuresAddedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, S2CStructuresAddedPacket::read, SurveyorClientNetworking::handleStructuresAdded));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)S2CGroupChangedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, S2CGroupChangedPacket::read, SurveyorClientNetworking::handleGroupChanged));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)S2CGroupAmendedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, S2CGroupAmendedPacket::read, SurveyorClientNetworking::handleGroupAmended));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)S2CGroupUpdatedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, S2CGroupUpdatedPacket::read, SurveyorClientNetworking::handleGroupUpdated));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SyncLandmarksAddedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, SyncLandmarksAddedPacket::read, SurveyorClientNetworking::handleLandmarksAdded));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SyncLandmarksRemovedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, SyncLandmarksRemovedPacket::read, SurveyorClientNetworking::handleLandmarksRemoved));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SyncLandmarksRequestedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, SyncLandmarksRequestedPacket::read, SurveyorClientNetworking::handleLandmarksRequested));
    }

    private static void handleTerrainAdded(class_638 world, WorldSummary summary, S2CUpdateRegionPacket packet) {
        if (summary.terrain() == null) {
            return;
        }
        BitSet changed = summary.terrain().getRegion(packet.regionPos()).readUpdatePacket(packet);
        (packet.shared() ? SurveyorClient.getSharedExploration() : SurveyorClient.getPersonalExploration()).mergeRegion((class_5321<class_1937>)world.method_27983(), packet.regionPos(), packet.set());
        SurveyorEvents.Invoke.terrainUpdated((class_1937)world, packet.set().stream().mapToObj(i -> packet.regionPos().toChunk(i)).toList());
        if (changed.cardinality() > 1) {
            Surveyor.LOGGER.info("[Surveyor] Received {} chunks in {} from the server.", (Object)changed.cardinality(), (Object)packet.regionPos());
        }
    }

    private static void handleStructuresAdded(class_638 world, WorldSummary summary, S2CStructuresAddedPacket packet) {
        if (summary.structures() == null) {
            return;
        }
        Multimap<class_5321<class_3195>, class_1923> keySet = summary.structures().readUpdatePacket((class_1937)world, packet);
        if (class_310.method_1551().field_1724 != null && !keySet.isEmpty()) {
            SurveyorExploration exploration = packet.shared() ? SurveyorClient.getSharedExploration() : SurveyorClient.getPersonalExploration();
            keySet.forEach((key, pos) -> exploration.addStructure((class_5321<class_1937>)world.method_27983(), (class_5321<class_3195>)key, (class_1923)pos));
            Surveyor.LOGGER.info("[Surveyor] Received {} structures from the server - {}", (Object)keySet.size(), (Object)keySet.keySet().stream().map(r -> r.method_29177().toString()).collect(Collectors.joining(", ")));
        }
    }

    private static void handleGroupChanged(class_638 world, WorldSummary summary, S2CGroupChangedPacket packet) {
        if (!SurveyorClient.getSharedExploration().groupPlayers().equals(packet.players().keySet())) {
            SurveyorClient.getSharedExploration().groupPlayers().clear();
            SurveyorClient.getSharedExploration().groupPlayers().addAll(packet.players().keySet());
        }
        NetworkHandlerSummary.of(class_310.method_1551().method_1562()).matchSummaries(packet.players());
        SurveyorClient.getSharedExploration().replaceTerrain((class_5321<class_1937>)world.method_27983(), packet.regionBits());
        SurveyorClient.getSharedExploration().replaceStructures((class_5321<class_1937>)world.method_27983(), packet.structureKeys());
        SurveyorClient.getExploration().updateClientForLandmarks((class_1937)world);
        if (summary != null) {
            if (summary.terrain() != null && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SOLO)) {
                new C2SKnownTerrainPacket(summary.terrain().bitSet(null)).send();
            }
            if (summary.structures() != null && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.SOLO)) {
                new C2SKnownStructuresPacket(summary.structures().keySet(null)).send();
            }
            if (summary.landmarks() != null && Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.SOLO)) {
                new C2SKnownLandmarksPacket(summary.landmarks().keySet(null)).send();
            }
            Surveyor.LOGGER.info("[Surveyor] Received updated share group of {} from the server - {}", (Object)packet.players().size(), (Object)packet.players().values().stream().map(PlayerSummary::username).collect(Collectors.joining(", ")));
        }
    }

    private static void handleGroupAmended(class_638 world, WorldSummary summary, S2CGroupAmendedPacket packet) {
        SurveyorClient.getSharedExploration().groupPlayers().add(packet.player());
        class_1657 player = world.method_18470(packet.player());
        Surveyor.LOGGER.info("[Surveyor] Received additional share group player {}", player == null ? packet.player() : player.method_7334().getName());
    }

    private static void handleGroupUpdated(class_638 world, WorldSummary summary, S2CGroupUpdatedPacket packet) {
        NetworkHandlerSummary.of(class_310.method_1551().method_1562()).mergeSummaries(packet.players());
    }

    private static void handleLandmarksAdded(class_638 world, WorldSummary summary, SyncLandmarksAddedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().readUpdatePacket((class_1937)world, packet, null);
        Multimap<UUID, class_2960> keys = MapUtil.keyMultiMap(packet.landmarks());
        Surveyor.LOGGER.info("[Surveyor] Received {} landmarks from the server - {}", (Object)keys.size(), (Object)keys.values().stream().map(class_2960::toString).collect(Collectors.joining(", ")));
    }

    private static void handleLandmarksRemoved(class_638 world, WorldSummary summary, SyncLandmarksRemovedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().readUpdatePacket((class_1937)world, packet, null);
        Surveyor.LOGGER.info("[Surveyor] Received {} landmark removals from the server - {}", (Object)packet.landmarks().size(), (Object)packet.landmarks().values().stream().map(class_2960::toString).collect(Collectors.joining(", ")));
    }

    private static void handleLandmarksRequested(class_638 world, WorldSummary summary, SyncLandmarksRequestedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().createUpdatePacket(packet.landmarks()).send();
        Surveyor.LOGGER.info("[Surveyor] Received {} landmark requests from the server - {}", (Object)packet.landmarks().size(), (Object)packet.landmarks().values().stream().map(class_2960::toString).collect(Collectors.joining(", ")));
    }

    private static <T extends S2CPacket> void handleClient(class_2540 buf, Function<class_2540, T> reader, ClientPacketHandler<T> handler) {
        WorldSummary summary;
        S2CPacket packet = (S2CPacket)reader.apply(buf);
        WorldSummary worldSummary = summary = class_310.method_1551().field_1687 == null ? null : WorldSummary.of((class_1937)class_310.method_1551().field_1687);
        if (summary != null && !summary.isClient()) {
            return;
        }
        class_310.method_1551().execute(() -> handler.handle(class_310.method_1551().field_1687, summary, packet));
    }

    public static interface ClientPacketHandler<T> {
        public void handle(class_638 var1, WorldSummary var2, T var3);
    }
}

