/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.landmark;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.landmark.component.LandmarkComponentHolder;
import folk.sisby.surveyor.landmark.component.LandmarkComponentMap;
import folk.sisby.surveyor.landmark.component.LandmarkComponentType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.slf4j.Logger;

public record Landmark(UUID owner, class_2960 id, LandmarkComponentMap components) implements LandmarkComponentHolder
{
    public static Codec<Landmark> createCodec(UUID uuid, class_2960 id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)LandmarkComponentMap.CODEC.fieldOf("components").forGetter(Landmark::components)).apply((Applicative)instance, components -> new Landmark(uuid, id, (LandmarkComponentMap)components)));
    }

    public static Landmark create(UUID owner, class_2960 id, UnaryOperator<LandmarkComponentMap.Builder> componentChanges) {
        return new Landmark(owner, id, ((LandmarkComponentMap.Builder)componentChanges.apply(LandmarkComponentMap.builder())).build());
    }

    public static Landmark global(class_2960 id, UnaryOperator<LandmarkComponentMap.Builder> componentChanges) {
        return Landmark.create(WorldLandmarks.GLOBAL, id, componentChanges);
    }

    public static Landmark createIncremental(WorldLandmarks landmarks, UUID uuid, class_2960 prefix, UnaryOperator<LandmarkComponentMap.Builder> componentChanges) {
        int i = 1;
        while (landmarks.contains(uuid, class_2960.method_43902((String)prefix.method_12836(), (String)(prefix.method_12832() + "/" + i)))) {
            ++i;
        }
        return Landmark.create(uuid, class_2960.method_43902((String)prefix.method_12836(), (String)(prefix.method_12832() + "/" + i)), componentChanges);
    }

    public static Landmark globalIncremental(WorldLandmarks landmarks, class_2960 prefix, UnaryOperator<LandmarkComponentMap.Builder> componentChanges) {
        return Landmark.createIncremental(landmarks, WorldLandmarks.GLOBAL, prefix, componentChanges);
    }

    public List<class_2561> toText() {
        ArrayList<class_2561> outList = new ArrayList<class_2561>();
        for (LandmarkComponentType type : this.components.keySet().stream().sorted(Comparator.comparing(LandmarkComponentType::id)).toList()) {
            outList.add((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)type.id().toString().replace("surveyor:", "")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)": ").method_10852(this.getView(type))));
        }
        return outList;
    }

    public class_2520 toNbt() {
        return (class_2520)Landmark.createCodec(this.owner, this.id).encodeStart((DynamicOps)class_2509.field_11560, (Object)this).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).orElseThrow();
    }
}

