/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import folk.sisby.surveyor.terrain.LayerSummary;
import folk.sisby.surveyor.terrain.SectionSummary;
import folk.sisby.surveyor.util.ChunkUtil;
import folk.sisby.surveyor.util.RegistryPalette;
import folk.sisby.surveyor.util.uints.UInts;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3620;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;

public class ChunkSummary {
    public static final int MINIMUM_AIR_DEPTH = 2;
    public static final String KEY_AIR_COUNT = "air";
    public static final String KEY_LAYERS = "layers";
    protected final Integer airCount;
    protected final TreeMap<Integer, @Nullable LayerSummary> layers = new TreeMap();

    public ChunkSummary(class_1937 world, class_2818 chunk, int[] layerHeights, RegistryPalette<class_1959> biomePalette, RegistryPalette<class_2248> blockPalette, boolean countAir) {
        this.airCount = countAir ? ChunkUtil.airCount((class_2791)chunk) : null;
        LayerSummary.FloorSummary[][] layerFloors = new LayerSummary.FloorSummary[layerHeights.length - 1][256];
        class_2826[] rawSections = chunk.method_12006();
        SectionSummary[] sections = new SectionSummary[rawSections.length];
        for (int i = 0; i < rawSections.length; ++i) {
            sections[i] = SectionSummary.ofSection(rawSections[i]);
        }
        int chunkX = chunk.method_12004().method_8326();
        int chunkZ = chunk.method_12004().method_8328();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int walkspaceHeight = 2;
                int waterDepth = 0;
                class_2248 carpetBlock = null;
                class_2338 carpetPos = new class_2338(chunkX + x, Integer.MAX_VALUE, chunkZ + z);
                for (int layerIndex = 0; layerIndex < layerHeights.length - 1; ++layerIndex) {
                    LayerSummary.FloorSummary foundFloor = null;
                    for (int y = layerHeights[layerIndex]; y > layerHeights[layerIndex + 1]; --y) {
                        int sectionIndex = chunk.method_31602(y);
                        SectionSummary section = sections[sectionIndex];
                        if (section == null) {
                            int sectionBottom = class_4076.method_18688((int)chunk.method_31604(sectionIndex));
                            walkspaceHeight += y - sectionBottom + 1;
                            waterDepth = 0;
                            y = sectionBottom;
                            continue;
                        }
                        class_2338 pos = new class_2338(chunkX + x, y, chunkZ + z);
                        class_2680 state = section.getBlockState(x, y, z);
                        class_3611 fluid = state.method_26227().method_15772();
                        if (!state.method_51366() && fluid.method_15780(class_3612.field_15906)) {
                            waterDepth = 0;
                            if (++walkspaceHeight < 2 || state.method_26205((class_1922)world, pos) == class_3620.field_16008) continue;
                            carpetPos = pos;
                            carpetBlock = state.method_26204();
                            continue;
                        }
                        if (fluid.method_15780((class_3611)class_3612.field_15910) || fluid.method_15780((class_3611)class_3612.field_15909)) {
                            ++waterDepth;
                            continue;
                        }
                        if (foundFloor == null) {
                            if (carpetPos.method_10264() == y + 1) {
                                foundFloor = new LayerSummary.FloorSummary(carpetPos.method_10264(), biomePalette.findOrAdd((class_1959)section.getBiomeEntry(x, carpetPos.method_10264(), z, world.method_31607(), world.method_31600()).comp_349()), blockPalette.findOrAdd(carpetBlock), world.method_8314(class_1944.field_9282, carpetPos), waterDepth, waterDepth == 0 ? 0 : world.method_8314(class_1944.field_9282, pos.method_10084().method_10086(waterDepth)));
                                if (carpetPos.method_10264() > layerHeights[layerIndex]) {
                                    if (layerFloors[layerIndex - 1][x * 16 + z] == null) {
                                        layerFloors[layerIndex - 1][x * 16 + z] = foundFloor;
                                    }
                                    foundFloor = null;
                                }
                                walkspaceHeight = 0;
                                waterDepth = 0;
                            } else if (walkspaceHeight >= 2 && state.method_26205((class_1922)world, pos) != class_3620.field_16008) {
                                foundFloor = new LayerSummary.FloorSummary(y, biomePalette.findOrAdd((class_1959)section.getBiomeEntry(x, y, z, world.method_31607(), world.method_31600()).comp_349()), blockPalette.findOrAdd(state.method_26204()), world.method_8314(class_1944.field_9282, pos.method_10084()), waterDepth, waterDepth == 0 ? 0 : world.method_8314(class_1944.field_9282, pos.method_10084().method_10086(waterDepth)));
                            }
                        }
                        if (state.method_26205((class_1922)world, pos) == class_3620.field_16008) continue;
                        walkspaceHeight = 0;
                        waterDepth = 0;
                    }
                    layerFloors[layerIndex][x * 16 + z] = foundFloor;
                }
            }
        }
        for (int i = 0; i < layerFloors.length; ++i) {
            this.layers.put(layerHeights[i], LayerSummary.fromSummaries(layerFloors[i], layerHeights[i]));
        }
    }

    public ChunkSummary(class_2487 nbt) {
        this.airCount = nbt.method_10545(KEY_AIR_COUNT) ? Integer.valueOf(nbt.method_10550(KEY_AIR_COUNT)) : null;
        class_2487 layersCompound = nbt.method_10562(KEY_LAYERS);
        for (String key : layersCompound.method_10541()) {
            int layerY = Integer.parseInt(key);
            this.layers.put(layerY, LayerSummary.fromNbt(layersCompound.method_10562(key)));
        }
    }

    public ChunkSummary(class_2540 buf) {
        this.layers.putAll(buf.method_34067(class_2540::method_10816, b -> {
            if (b.readByte() == 0) {
                return null;
            }
            return LayerSummary.fromBuf(buf);
        }));
        this.airCount = -1;
    }

    public class_2487 writeNbt(class_2487 nbt) {
        if (this.airCount != null) {
            nbt.method_10569(KEY_AIR_COUNT, this.airCount.intValue());
        }
        class_2487 layersCompound = new class_2487();
        this.layers.forEach((layerY, layerSummary) -> {
            class_2487 layerCompound = new class_2487();
            if (layerSummary != null) {
                layerSummary.writeNbt(layerCompound);
            }
            layersCompound.method_10566(String.valueOf(layerY), (class_2520)layerCompound);
        });
        nbt.method_10566(KEY_LAYERS, (class_2520)layersCompound);
        return nbt;
    }

    public void writeBuf(class_2540 buf) {
        buf.method_34063(this.layers, class_2540::method_10804, (b, summary) -> {
            if (summary == null) {
                b.writeByte(0);
            } else {
                b.writeByte(1);
                summary.writeBuf(buf);
            }
        });
    }

    public void remap(Map<Integer, Integer> biomeRemap, Map<Integer, Integer> blockRemap) {
        HashMap newLayers = new HashMap();
        this.layers.forEach((y, layer) -> newLayers.put(y, layer == null ? null : new LayerSummary(layer.found, layer.depth, UInts.remap(layer.biome, biomeRemap::get, 0, layer.found.cardinality()), UInts.remap(layer.block, blockRemap::get, 0, layer.found.cardinality()), layer.light, layer.water, layer.glint)));
        this.layers.clear();
        this.layers.putAll(newLayers);
    }

    public Integer getAirCount() {
        return this.airCount;
    }

    @Nullable
    public LayerSummary.Raw toSingleLayer(Integer minY, Integer maxY, int worldHeight) {
        LayerSummary.Raw outRaw = new LayerSummary.Raw(new BitSet(256), new int[256], new int[256], new int[256], new int[256], new int[256], new int[256]);
        this.layers.descendingMap().forEach((y, layer) -> {
            if (layer != null) {
                layer.fillEmptyFloors(worldHeight - y, maxY == null ? Integer.MIN_VALUE : y - maxY, minY == null ? Integer.MAX_VALUE : y - minY, outRaw);
            }
        });
        return outRaw.exists().cardinality() == 0 ? null : outRaw;
    }

    @Nullable
    public LayerSummary.Raw toSingleLayerBelow(Integer minY, int[] depthsAbove, int worldHeight) {
        LayerSummary.Raw outRaw = new LayerSummary.Raw(new BitSet(256), new int[256], new int[256], new int[256], new int[256], new int[256], new int[256]);
        this.layers.descendingMap().forEach((y, layer) -> {
            if (layer != null) {
                layer.fillEmptyFloorsUnder(worldHeight - y, depthsAbove, minY == null ? Integer.MAX_VALUE : y - minY, outRaw);
            }
        });
        return outRaw.exists().cardinality() == 0 ? null : outRaw;
    }
}

