/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorCommands;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.landmark.component.LandmarkComponentTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2262;
import net.minecraft.class_2280;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_7157;
import net.minecraft.class_746;

public class SurveyorClientCommands {
    private static int getLandmarks(WorldSummary summary, SurveyorExploration exploration, Consumer<class_2561> feedback, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        Map landmarks = summary.landmarks().asMap(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), SurveyorClient.getExploration());
        if (landmarks.isEmpty()) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"There are no landmarks in this world!").method_27692(class_124.field_1054)));
            return 0;
        }
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"World %s:".formatted(global ? "Landmarks" : "Waypoints"))));
        for (Landmark landmark : landmarks.values()) {
            feedback.accept((class_2561)SurveyorCommands.indent().method_10852((class_2561)class_2561.method_43470((String)"%s:".formatted(landmark.id().method_12836())).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)landmark.id().method_12832())).method_10852((class_2561)(!landmark.components().contains(LandmarkComponentTypes.NAME) ? class_2561.method_30163((String)"") : class_2561.method_43470((String)": \"").method_10852((class_2561)landmark.components().get(LandmarkComponentTypes.NAME).method_27661().method_27694(s -> s.method_36139(landmark.components().contains(LandmarkComponentTypes.COLOR) ? 0xFFFFFF & landmark.components().get(LandmarkComponentTypes.COLOR) : class_124.field_1060.method_532()))).method_10852((class_2561)class_2561.method_43470((String)"\"")))));
        }
        return landmarks.size();
    }

    private static int viewLandmark(WorldSummary summary, Consumer<class_2561> feedback, class_2960 id, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (!summary.landmarks().contains(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), id)) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"No landmark exists of that id!").method_27692(class_124.field_1054)));
            return 0;
        }
        Landmark landmark = summary.landmarks().get(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), id);
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)(landmark.owner().equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint ")).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)id.toString())).method_10852((class_2561)class_2561.method_43470((String)": ")));
        landmark.toText().forEach(t -> feedback.accept((class_2561)SurveyorCommands.indent().method_10852(t)));
        return 1;
    }

    private static int rawLandmark(WorldSummary summary, Consumer<class_2561> feedback, class_2960 id, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (!summary.landmarks().contains(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), id)) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"No landmark exists of that id!").method_27692(class_124.field_1054)));
            return 0;
        }
        Landmark landmark = summary.landmarks().get(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), id);
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)(landmark.owner().equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint ")).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)id.toString())).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852((class_2561)class_2561.method_43470((String)landmark.toNbt().toString()).method_27692(class_124.field_1075)));
        return 1;
    }

    private static int removeLandmark(WorldSummary summary, class_1937 world, Consumer<class_2561> feedback, class_2960 type, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (!summary.landmarks().contains(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), type)) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"No landmark exists of that id!").method_27692(class_124.field_1054)));
            return 0;
        }
        Landmark landmark = summary.landmarks().get(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), type);
        summary.landmarks().remove(world, global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), type);
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"%s %s removed successfully!".formatted(landmark.owner().equals(WorldLandmarks.GLOBAL) ? "Landmark" : "Waypoint")).method_27692(class_124.field_1060)));
        return 1;
    }

    private static int addBlockLandmark(WorldSummary summary, class_1937 world, Consumer<class_2561> feedback, class_2338 pos, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        class_2960 id = Surveyor.id("block/%s/%s/%s".formatted(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        if (summary.landmarks().contains(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), id)) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"A landmark with this ID already exists! Replacing...").method_27692(class_124.field_1054)));
        }
        summary.landmarks().put(world, Landmark.create(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), id, builder -> LandmarkComponentTypes.forBlock(builder, (class_1936)world, pos)));
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"Added new %s %s!".formatted(global ? "Landmark" : "Waypoint", id)).method_27692(class_124.field_1060)));
        return 1;
    }

    public static <T> T map(CommandContext<FabricClientCommandSource> context, SurveyorCommandExecutor<T> executor, boolean feedback) {
        class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
        SurveyorExploration exploration = SurveyorClient.getExploration();
        try {
            return executor.execute(WorldSummary.of((class_1937)((FabricClientCommandSource)context.getSource()).getWorld()), player, ((FabricClientCommandSource)context.getSource()).getWorld(), exploration, t -> ((FabricClientCommandSource)context.getSource()).sendFeedback(t));
        }
        catch (Exception e) {
            if (feedback) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Command failed! Check log for details.").method_27692(class_124.field_1061));
            }
            if (feedback) {
                Surveyor.LOGGER.error("[Surveyor] Error while executing command: {}", (Object)context.getInput(), (Object)e);
            }
            return null;
        }
    }

    public static int execute(CommandContext<FabricClientCommandSource> context, SurveyorCommandExecutor<Integer> executor) {
        return Objects.requireNonNullElse(SurveyorClientCommands.map(context, executor, true), 0);
    }

    private static class_2168 sourceForPos(FabricClientCommandSource source) {
        return new class_2168(null, source.getPosition(), source.getRotation(), null, 0, null, null, null, source.getEntity());
    }

    public static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"waypointsc").requires(c -> !c.getClient().method_1542() && c.getClient().method_1562().method_2886().findNode(List.of("surveyor")) == null)).requires(c -> Surveyor.CONFIG.landmarks != SystemMode.DISABLED)).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> SurveyorClientCommands.getLandmarks(w, e, f, false)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"new").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(ClientCommandManager.literal((String)"block").then(ClientCommandManager.argument((String)"pos", (ArgumentType)class_2262.method_9698()).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> SurveyorClientCommands.addBlockLandmark(w, (class_1937)sw, f, ((class_2280)c.getArgument("pos", class_2280.class)).method_9704(SurveyorClientCommands.sourceForPos((FabricClientCommandSource)c.getSource())), false))))))).then(ClientCommandManager.literal((String)"view").then(ClientCommandManager.argument((String)"id", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270((Iterable)SurveyorClientCommands.map((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> w.landmarks() == null ? new HashSet() : w.landmarks().asMap(SurveyorClient.getClientUuid(), p.method_64475(2) ? null : e).keySet(), false), (SuggestionsBuilder)b)).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> SurveyorClientCommands.viewLandmark(w, f, (class_2960)c.getArgument("id", class_2960.class), false)))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"raw").requires(c -> Surveyor.CONFIG.debugCommands)).then(ClientCommandManager.argument((String)"id", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270((Iterable)SurveyorClientCommands.map((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> w.landmarks() == null ? new HashSet() : w.landmarks().asMap(SurveyorClient.getClientUuid(), p.method_64475(2) ? null : e).keySet(), false), (SuggestionsBuilder)b)).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> SurveyorClientCommands.rawLandmark(w, f, (class_2960)c.getArgument("id", class_2960.class), false)))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(ClientCommandManager.argument((String)"id", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270((Iterable)SurveyorClientCommands.map((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> w.landmarks() == null ? new HashSet() : w.landmarks().asMap(SurveyorClient.getClientUuid(), p.method_64475(2) ? null : e).keySet(), false), (SuggestionsBuilder)b)).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> SurveyorClientCommands.removeLandmark(w, (class_1937)sw, f, (class_2960)c.getArgument("id", class_2960.class), false))))));
    }

    public static interface SurveyorCommandExecutor<T> {
        public T execute(WorldSummary var1, class_746 var2, class_638 var3, SurveyorExploration var4, Consumer<class_2561> var5);
    }
}

