/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.DimensionSupport;
import folk.sisby.surveyor.util.RegionPos;
import folk.sisby.surveyor.util.RegistryPalette;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.class_8911;
import org.jetbrains.annotations.Nullable;

public class RegionSummary {
    public static final String KEY_BIOMES = "biomes";
    public static final String KEY_BLOCKS = "blocks";
    public static final String KEY_BIOME_WATER = "biomeWater";
    public static final String KEY_BIOME_FOLIAGE = "biomeFoliage";
    public static final String KEY_BIOME_GRASS = "biomeGrass";
    public static final String KEY_BLOCK_COLORS = "blockColors";
    public static final String KEY_CHUNKS = "chunks";
    protected final RegionPos regionPos;
    protected final File saveFile;
    protected final class_5455 manager;
    @Nullable
    protected RegistryPalette<class_1959> biomePalette;
    @Nullable
    protected RegistryPalette<class_2248> blockPalette;
    @Nullable
    protected ChunkSummary[][] chunks;
    @Nullable
    protected BitSet bitSet;
    protected boolean dirty = false;
    protected boolean saving = false;

    private RegionSummary(class_5455 manager, File saveFile, RegionPos regionPos, ChunkSummary[][] chunks, BitSet bitSet, RegistryPalette<class_1959> biomePalette, RegistryPalette<class_2248> blockPalette) {
        this.manager = manager;
        this.biomePalette = biomePalette;
        this.blockPalette = blockPalette;
        this.saveFile = saveFile;
        this.regionPos = regionPos;
        this.chunks = chunks;
        this.bitSet = bitSet;
        if (bitSet == null) {
            this.readNbt(regionPos, true);
        }
    }

    public static <T, O> List<O> mapIterable(Iterable<T> palette, Function<T, O> mapper) {
        ArrayList<O> list = new ArrayList<O>();
        for (T value : palette) {
            list.add(mapper.apply(value));
        }
        return list;
    }

    public static RegionSummary fromEmpty(File folder, RegionPos rPos, class_5455 manager) {
        return new RegionSummary(manager, new File(folder, "c.%d.%d.dat".formatted(rPos.x(), rPos.z())), rPos, new ChunkSummary[32][32], new BitSet(1024), new RegistryPalette<class_1959>(manager.method_30530(class_7924.field_41236)), new RegistryPalette<class_2248>(manager.method_30530(class_7924.field_41254)));
    }

    public static RegionSummary fromFile(File file, class_5455 manager, RegionPos rPos) {
        return new RegionSummary(manager, file, rPos, null, null, null, null);
    }

    protected void readNbt(RegionPos pos, boolean bitsOnly) {
        class_2378 biomeRegistry = this.manager.method_30530(class_7924.field_41236);
        class_2378 blockRegistry = this.manager.method_30530(class_7924.field_41254);
        class_2487 nbt = new class_2487();
        try {
            nbt = class_2507.method_30613((Path)this.saveFile.toPath(), (class_2505)class_2505.method_53898());
        }
        catch (IOException | class_8911 e) {
            Surveyor.LOGGER.error("[Surveyor] Error reading region summary file {}.", (Object)this.saveFile.getName(), (Object)e);
        }
        class_2487 chunksCompound = nbt.method_10562(KEY_CHUNKS).orElse(new class_2487());
        this.bitSet = new BitSet(1024);
        if (bitsOnly) {
            for (String posKey : chunksCompound.method_10541()) {
                int x = RegionPos.regionRelative(Integer.parseInt(posKey.split(",")[0]));
                int z = RegionPos.regionRelative(Integer.parseInt(posKey.split(",")[1]));
                this.bitSet.set(RegionPos.chunkToBit(x, z));
            }
            return;
        }
        this.biomePalette = new RegistryPalette(this.manager.method_30530(class_7924.field_41236));
        this.blockPalette = new RegistryPalette(this.manager.method_30530(class_7924.field_41254));
        this.chunks = new ChunkSummary[32][32];
        class_2499 biomeList = nbt.method_10554(KEY_BIOMES).orElse(new class_2499());
        Int2IntArrayMap biomeRemap = new Int2IntArrayMap(biomeList.size());
        for (int i = 0; i < biomeList.size(); ++i) {
            class_2960 biomeId = class_2960.method_12829((String)((String)((class_2520)biomeList.get(i)).method_68658().orElseThrow()));
            class_1959 biome = (class_1959)biomeRegistry.method_63535(biomeId);
            class_1959 newBiome = biome == null ? (class_1959)biomeRegistry.method_29107(class_1972.field_9473) : biome;
            int newIndex = this.biomePalette.findOrAdd(newBiome);
            if (biome != null && newIndex == i) continue;
            if (biome == null) {
                Surveyor.LOGGER.warn("[Surveyor] Remapping biome palette in region {}: {} (#{}) is now {} (#{})", new Object[]{pos, biomeId, i, biomeRegistry.method_10221((Object)newBiome), newIndex});
            }
            biomeRemap.put(i, newIndex);
            this.dirty();
        }
        class_2499 blockList = nbt.method_10554(KEY_BLOCKS).orElse(new class_2499());
        Int2IntArrayMap blockRemap = new Int2IntArrayMap(blockList.size());
        for (int i = 0; i < blockList.size(); ++i) {
            class_2960 blockId = class_2960.method_12829((String)((String)((class_2520)blockList.get(i)).method_68658().orElseThrow()));
            class_2248 block = (class_2248)blockRegistry.method_63535(blockId);
            class_2248 newBlock = block == null ? class_2246.field_10124 : block;
            int newIndex = this.blockPalette.findOrAdd(newBlock);
            if (block != null && newIndex == i) continue;
            if (block == null) {
                Surveyor.LOGGER.warn("[Surveyor] Remapping block palette in region {}: {} (#{}) is now {} (#{})", new Object[]{pos, ((class_2520)blockList.get(i)).method_68658(), i, blockRegistry.method_10221((Object)newBlock), newIndex});
            }
            blockRemap.put(i, newIndex);
            this.dirty();
        }
        if (this.biomePalette.view().method_10204() == 0 || this.blockPalette.view().method_10204() == 0) {
            Surveyor.LOGGER.warn("[Surveyor] Palette was empty in region {}, skipping data load!", (Object)this.regionPos);
            return;
        }
        for (String posKey : chunksCompound.method_10541()) {
            int x = RegionPos.regionRelative(Integer.parseInt(posKey.split(",")[0]));
            int z = RegionPos.regionRelative(Integer.parseInt(posKey.split(",")[1]));
            ChunkSummary summary = new ChunkSummary((class_2487)chunksCompound.method_10562(posKey).orElseThrow());
            this.set(x, z, summary);
            if (biomeRemap.isEmpty() && blockRemap.isEmpty()) continue;
            summary.remap((Map<Integer, Integer>)biomeRemap, (Map<Integer, Integer>)blockRemap);
        }
    }

    public boolean contains(class_1923 pos) {
        return this.bitSet().get(RegionPos.chunkToBit(pos));
    }

    public ChunkSummary get(class_1923 pos) {
        if (!this.contains(pos)) {
            return null;
        }
        return this.get(RegionPos.regionRelative(pos.field_9181), RegionPos.regionRelative(pos.field_9180));
    }

    @Nullable
    protected ChunkSummary get(int x, int z) {
        if (this.chunks == null) {
            this.readNbt(this.regionPos, false);
        }
        return this.chunks[x][z];
    }

    protected void set(int x, int z, ChunkSummary summary) {
        if (this.chunks == null || this.bitSet == null) {
            this.readNbt(this.regionPos, false);
        }
        this.chunks[x][z] = summary;
        this.bitSet.set(RegionPos.chunkToBit(x, z), summary != null);
    }

    public BitSet bitSet() {
        if (this.bitSet == null) {
            this.readNbt(this.regionPos, true);
        }
        return (BitSet)this.bitSet.clone();
    }

    public void putChunk(class_1937 world, class_2818 chunk) {
        if (Surveyor.CONFIG.terrain == SystemMode.FROZEN) {
            return;
        }
        if (world.method_31605() == 0) {
            return;
        }
        if (this.chunks == null) {
            this.readNbt(this.regionPos, false);
        }
        this.set(RegionPos.regionRelative(chunk.method_12004().field_9181), RegionPos.regionRelative(chunk.method_12004().field_9180), new ChunkSummary(world, chunk, DimensionSupport.getSummaryLayers(world), this.biomePalette, this.blockPalette, !(world instanceof class_3218)));
        this.dirty();
    }

    public boolean isUnloaded(class_1937 world) {
        return this.regionPos.toChunks().stream().noneMatch(c -> world.method_8393(c.field_9181, c.field_9180));
    }

    public void save(boolean unload) {
        if (this.saving) {
            return;
        }
        if (!this.isDirty()) {
            if (unload) {
                this.chunks = null;
            }
            return;
        }
        class_2487 nbt = new class_2487();
        class_2378 biomeRegistry = this.manager.method_30530(class_7924.field_41236);
        class_2378 blockRegistry = this.manager.method_30530(class_7924.field_41254);
        nbt.method_10566(KEY_BIOMES, (class_2520)new class_2499(RegionSummary.mapIterable(this.biomePalette.view(), b -> class_2519.method_23256((String)biomeRegistry.method_10221(b).toString()))));
        nbt.method_10566(KEY_BLOCKS, (class_2520)new class_2499(RegionSummary.mapIterable(this.blockPalette.view(), b -> class_2519.method_23256((String)blockRegistry.method_10221(b).toString()))));
        nbt.method_10539(KEY_BIOME_WATER, RegionSummary.mapIterable(this.biomePalette.view(), class_1959::method_8687).stream().mapToInt(i -> i).toArray());
        nbt.method_10539(KEY_BIOME_FOLIAGE, RegionSummary.mapIterable(this.biomePalette.view(), class_1959::method_8698).stream().mapToInt(i -> i).toArray());
        nbt.method_10539(KEY_BIOME_GRASS, RegionSummary.mapIterable(this.biomePalette.view(), b -> b.method_8711(0.0, 0.0)).stream().mapToInt(i -> i).toArray());
        nbt.method_10539(KEY_BLOCK_COLORS, RegionSummary.mapIterable(this.blockPalette.view(), b -> b.method_26403().field_16011).stream().mapToInt(i -> i).toArray());
        class_2487 chunksCompound = new class_2487();
        this.regionPos.forXZ((x, z) -> {
            ChunkSummary chunk = this.get((int)x, (int)z);
            if (chunk != null) {
                class_1923 pos = this.regionPos.toChunk((int)x, (int)z);
                chunksCompound.method_10566("%s,%s".formatted(pos.field_9181, pos.field_9180), (class_2520)chunk.writeNbt(new class_2487()));
            }
        });
        nbt.method_10566(KEY_CHUNKS, (class_2520)chunksCompound);
        this.dirty = false;
        this.saving = true;
        class_156.method_27958().execute(() -> {
            try {
                class_2507.method_30614((class_2487)nbt, (Path)this.saveFile.toPath());
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error writing region summary file {}.", (Object)this.saveFile.getName(), (Object)e);
            }
            finally {
                if (unload && !this.dirty) {
                    this.chunks = null;
                }
                this.saving = false;
            }
        });
    }

    public BitSet readUpdatePacket(S2CUpdateRegionPacket packet) {
        if (Surveyor.CONFIG.terrain == SystemMode.FROZEN) {
            return new BitSet();
        }
        if (this.chunks == null) {
            this.readNbt(this.regionPos, false);
        }
        if (packet.biomePalette().isEmpty() || packet.blockPalette().isEmpty()) {
            return new BitSet();
        }
        class_2378 biomeRegistry = this.manager.method_30530(class_7924.field_41236);
        class_2378 blockRegistry = this.manager.method_30530(class_7924.field_41254);
        Int2IntArrayMap biomeRemap = new Int2IntArrayMap();
        for (int i = 0; i < packet.biomePalette().size(); ++i) {
            biomeRemap.put(i, this.biomePalette.findOrAdd((class_1959)biomeRegistry.method_10200(packet.biomePalette().get(i).intValue())));
        }
        Int2IntArrayMap blockRemap = new Int2IntArrayMap();
        for (int i = 0; i < packet.blockPalette().size(); ++i) {
            blockRemap.put(i, this.blockPalette.findOrAdd((class_2248)blockRegistry.method_10200(packet.blockPalette().get(i).intValue())));
        }
        int[] indices = packet.set().stream().toArray();
        for (int i = 0; i < packet.chunks().size(); ++i) {
            ChunkSummary summary = packet.chunks().get(i);
            summary.remap((Map<Integer, Integer>)biomeRemap, (Map<Integer, Integer>)blockRemap);
            this.set(RegionPos.bitToX(indices[i]), RegionPos.bitToZ(indices[i]), summary);
        }
        this.dirty();
        return packet.set();
    }

    public S2CUpdateRegionPacket createUpdatePacket(boolean shared, RegionPos rPos, BitSet set) {
        if (this.chunks == null) {
            this.readNbt(this.regionPos, false);
        }
        return new S2CUpdateRegionPacket(shared, rPos, RegionSummary.mapIterable(this.biomePalette, i -> i), RegionSummary.mapIterable(this.blockPalette, i -> i), set, set.stream().mapToObj(i -> this.get(RegionPos.bitToX(i), RegionPos.bitToZ(i))).toList());
    }

    public RegistryPalette.ValueView getBiomePalette() {
        if (this.chunks == null) {
            this.readNbt(this.regionPos, false);
        }
        return this.biomePalette.view();
    }

    public RegistryPalette.ValueView getBlockPalette() {
        if (this.chunks == null) {
            this.readNbt(this.regionPos, false);
        }
        return this.blockPalette.view();
    }

    public boolean isLoaded() {
        return this.chunks != null;
    }

    public boolean isDirty() {
        return this.dirty && Surveyor.CONFIG.terrain != SystemMode.FROZEN;
    }

    private void dirty() {
        this.dirty = true;
    }
}

