/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.SurveyorPlayer;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.terrain.RegionSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.ArrayUtil;
import folk.sisby.surveyor.util.RegionPos;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.server.MinecraftServer;

public interface PlayerSummary {
    public static final String KEY_DATA = "surveyor";
    public static final String KEY_USERNAME = "username";

    public static PlayerSummary of(class_3222 player) {
        return ((SurveyorPlayer)player).surveyor$getSummary();
    }

    public static PlayerSummary of(UUID uuid, MinecraftServer server) {
        return ServerSummary.of(server).getPlayer(uuid, server);
    }

    public SurveyorExploration exploration();

    public String username();

    public class_5321<class_1937> dimension();

    public class_243 pos();

    public float yaw();

    public int viewDistance();

    public boolean online();

    default public void copyFrom(PlayerSummary oldSummary) {
        this.exploration().copyFrom(oldSummary.exploration());
    }

    public static class ServerPlayerEntitySummary
    extends PlayerEntitySummary
    implements PlayerSummary {
        private final ServerPlayerExploration exploration;

        public ServerPlayerEntitySummary(class_3222 player) {
            super((class_1657)player);
            this.exploration = new ServerPlayerExploration(player, new ConcurrentHashMap<class_5321<class_1937>, Map<RegionPos, BitSet>>(), new ConcurrentHashMap<class_5321<class_1937>, Map<class_5321<class_3195>, LongSet>>());
        }

        @Override
        public SurveyorExploration exploration() {
            return this.exploration;
        }

        @Override
        public int viewDistance() {
            return ((class_3222)this.player).method_52371();
        }

        public void copyExploration(ServerPlayerEntitySummary oldSummary) {
            this.exploration.copyFrom(oldSummary.exploration);
        }

        public void read(class_11368 view) {
            this.exploration.read(view.method_71426(PlayerSummary.KEY_DATA, class_2487.field_25128).orElse(new class_2487()));
        }

        public void writeNbt(class_11372 view) {
            class_2487 surveyorNbt = new class_2487();
            this.exploration.write(surveyorNbt);
            surveyorNbt.method_10582(PlayerSummary.KEY_USERNAME, this.username());
            view.method_71468(PlayerSummary.KEY_DATA, class_2487.field_25128, (Object)surveyorNbt);
        }

        public record ServerPlayerExploration(class_3222 player, Map<class_5321<class_1937>, Map<RegionPos, BitSet>> terrain, Map<class_5321<class_1937>, Map<class_5321<class_3195>, LongSet>> structures) implements SurveyorExploration
        {
            @Override
            public Set<UUID> sharedPlayers() {
                return Set.of(Surveyor.getUuid(this.player));
            }

            @Override
            public boolean personal() {
                return true;
            }

            @Override
            public void mergeRegion(class_5321<class_1937> worldKey, RegionPos regionPos, BitSet bitSet) {
                SurveyorExploration.super.mergeRegion(worldKey, regionPos, bitSet);
                if (this.player.method_5682().method_19466(this.player.method_7334())) {
                    this.updateClientForMergeRegion((class_1937)this.player.method_51469(), regionPos, bitSet);
                }
                if (Surveyor.CONFIG.networking.terrain.atMost(NetworkMode.SOLO)) {
                    return;
                }
                for (class_3222 friend : ServerSummary.of(this.player.method_5682()).groupOtherServerPlayers(Surveyor.getUuid(this.player), this.player.method_5682())) {
                    if (!friend.method_51469().method_27983().equals(worldKey)) continue;
                    SurveyorExploration friendExploration = SurveyorExploration.of(friend);
                    BitSet sendSet = (BitSet)bitSet.clone();
                    if (friendExploration.terrain().containsKey(worldKey) && friendExploration.terrain().get(worldKey).containsKey(regionPos)) {
                        sendSet.andNot(friendExploration.terrain().get(worldKey).get(regionPos));
                    }
                    WorldTerrainSummary summary = WorldSummary.of((class_1937)this.player.method_51469()).terrain();
                    if (sendSet.isEmpty() || summary == null) continue;
                    S2CUpdateRegionPacket.of(true, regionPos, summary.getRegion(regionPos), sendSet).send(friend);
                }
            }

            @Override
            public void addChunk(class_5321<class_1937> worldKey, class_1923 pos) {
                SurveyorExploration.super.addChunk(worldKey, pos);
                if (this.player.method_5682().method_19466(this.player.method_7334())) {
                    this.updateClientForAddChunk((class_1937)this.player.method_51469(), pos);
                }
                if (Surveyor.CONFIG.networking.terrain.atMost(NetworkMode.SOLO)) {
                    return;
                }
                for (class_3222 friend : ServerSummary.of(this.player.method_5682()).groupOtherServerPlayers(Surveyor.getUuid(this.player), this.player.method_5682())) {
                    if (!friend.method_51469().method_27983().equals(worldKey) || SurveyorExploration.of(friend).exploredChunk(worldKey, pos)) continue;
                    RegionPos regionPos = RegionPos.of(pos);
                    WorldTerrainSummary summary = WorldSummary.of((class_1937)this.player.method_5682().method_3847(worldKey)).terrain();
                    if (summary == null) continue;
                    RegionSummary region = summary.getRegion(regionPos);
                    BitSet sendSet = new BitSet();
                    sendSet.set(RegionPos.chunkToBit(pos));
                    S2CUpdateRegionPacket.of(true, regionPos, region, sendSet).send(friend);
                }
            }

            @Override
            public void addStructure(class_5321<class_1937> worldKey, class_5321<class_3195> structureKey, class_1923 pos) {
                SurveyorExploration.super.addStructure(worldKey, structureKey, pos);
                class_3218 world = this.player.method_51469();
                if (this.player.method_5682().method_19466(this.player.method_7334())) {
                    this.updateClientForAddStructure((class_1937)world, structureKey, pos);
                }
                WorldStructureSummary summary = WorldSummary.of((class_1937)world).structures();
                if (Surveyor.CONFIG.networking.structures.atMost(NetworkMode.NONE)) {
                    return;
                }
                S2CStructuresAddedPacket.of(false, structureKey, pos, summary).send(this.player);
                if (Surveyor.CONFIG.networking.structures.atMost(NetworkMode.SOLO)) {
                    return;
                }
                for (class_3222 friend : ServerSummary.of(this.player.method_5682()).groupOtherServerPlayers(Surveyor.getUuid(this.player), this.player.method_5682())) {
                    if (!friend.method_51469().method_27983().equals(worldKey) || SurveyorExploration.of(friend).exploredStructure(worldKey, structureKey, pos)) continue;
                    S2CStructuresAddedPacket.of(true, structureKey, pos, summary).send(friend);
                }
            }
        }
    }

    public static class PlayerEntitySummary
    implements PlayerSummary {
        protected final class_1657 player;

        public PlayerEntitySummary(class_1657 player) {
            this.player = player;
        }

        @Override
        public SurveyorExploration exploration() {
            return null;
        }

        @Override
        public String username() {
            return this.player.method_7334().getName();
        }

        @Override
        public class_5321<class_1937> dimension() {
            return this.player.method_37908().method_27983();
        }

        @Override
        public class_243 pos() {
            return this.player.method_19538();
        }

        @Override
        public float yaw() {
            return this.player.method_36454();
        }

        @Override
        public int viewDistance() {
            return 0;
        }

        @Override
        public boolean online() {
            return true;
        }
    }

    public record OfflinePlayerSummary(SurveyorExploration exploration, String username, class_5321<class_1937> dimension, class_243 pos, float yaw, boolean online) implements PlayerSummary
    {
        public OfflinePlayerSummary(UUID uuid, class_2487 nbt, boolean online) {
            this(OfflinePlayerExploration.from(uuid, nbt.method_10562(PlayerSummary.KEY_DATA).orElse(new class_2487())), nbt.method_10562(PlayerSummary.KEY_DATA).isPresent() && ((class_2487)nbt.method_10562(PlayerSummary.KEY_DATA).get()).method_10558(PlayerSummary.KEY_USERNAME).isPresent() ? (String)((class_2487)nbt.method_10562(PlayerSummary.KEY_DATA).get()).method_10558(PlayerSummary.KEY_USERNAME).get() : "???", (class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)nbt.method_10558("Dimension").orElse(class_1937.field_25179.method_29177().toString()))), nbt.method_10554("Pos").isPresent() ? ArrayUtil.toVec3d(((class_2499)nbt.method_10554("Pos").get()).stream().mapToDouble(e -> ((class_2489)e).method_10697()).toArray()) : new class_243(0.0, 0.0, 0.0), nbt.method_10554("Rotation").isPresent() ? ((class_2499)nbt.method_10554("Rotation").get()).method_10604(0).orElse(Float.valueOf(0.0f)).floatValue() : 0.0f, online);
        }

        public OfflinePlayerSummary(class_3222 player) {
            this(OfflinePlayerExploration.ofMerged(Set.of(SurveyorExploration.of(player))), player.method_7334().getName(), (class_5321<class_1937>)player.method_51469().method_27983(), player.method_19538(), player.method_36454(), true);
        }

        public static void writeBuf(PlayerSummary summary, class_9129 buf) {
            buf.method_10814(summary.username());
            buf.method_44116(summary.dimension());
            buf.method_52955(summary.pos());
            buf.method_52941(summary.yaw());
            buf.method_52964(summary.online());
        }

        public static PlayerSummary readBuf(class_9129 buf) {
            return new OfflinePlayerSummary(null, buf.method_19772(), (class_5321<class_1937>)buf.method_44112(class_7924.field_41223), buf.method_52996(), buf.readFloat(), buf.readBoolean());
        }

        @Override
        public int viewDistance() {
            return 0;
        }

        public record OfflinePlayerExploration(Set<UUID> sharedPlayers, Map<class_5321<class_1937>, Map<RegionPos, BitSet>> terrain, Map<class_5321<class_1937>, Map<class_5321<class_3195>, LongSet>> structures, boolean personal) implements SurveyorExploration
        {
            public static OfflinePlayerExploration empty(UUID uuid) {
                return new OfflinePlayerExploration(Set.of(uuid), new HashMap<class_5321<class_1937>, Map<RegionPos, BitSet>>(), new HashMap<class_5321<class_1937>, Map<class_5321<class_3195>, LongSet>>(), true);
            }

            public static OfflinePlayerExploration ofMerged(Set<SurveyorExploration> explorations) {
                HashSet<UUID> sharedPlayers = new HashSet<UUID>();
                HashMap<class_5321<class_1937>, Map<RegionPos, BitSet>> terrain = new HashMap<class_5321<class_1937>, Map<RegionPos, BitSet>>();
                HashMap<class_5321<class_1937>, Map<class_5321<class_3195>, LongSet>> structures = new HashMap<class_5321<class_1937>, Map<class_5321<class_3195>, LongSet>>();
                OfflinePlayerExploration outExploration = new OfflinePlayerExploration(sharedPlayers, terrain, structures, false);
                for (SurveyorExploration exploration : explorations) {
                    sharedPlayers.addAll(exploration.sharedPlayers());
                    exploration.terrain().forEach((wKey, map) -> map.forEach((rPos, bits) -> outExploration.mergeRegion((class_5321<class_1937>)wKey, (RegionPos)rPos, (BitSet)bits)));
                    exploration.structures().forEach((wKey, map) -> map.forEach((sKey, longs) -> outExploration.mergeStructures((class_5321<class_1937>)wKey, (class_5321<class_3195>)sKey, (LongSet)longs)));
                }
                return outExploration;
            }

            public static SurveyorExploration from(UUID uuid, class_2487 nbt) {
                OfflinePlayerExploration mutable = new OfflinePlayerExploration(new HashSet<UUID>(Set.of(uuid)), new HashMap<class_5321<class_1937>, Map<RegionPos, BitSet>>(), new HashMap<class_5321<class_1937>, Map<class_5321<class_3195>, LongSet>>(), true);
                mutable.read(nbt);
                return mutable;
            }
        }
    }
}

