/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.Multimap;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.MapUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class SurveyorEvents {
    private static final Map<class_2960, WorldLoad> worldLoad = new HashMap<class_2960, WorldLoad>();
    private static final Map<class_2960, TerrainUpdated> terrainUpdated = new HashMap<class_2960, TerrainUpdated>();
    private static final Map<class_2960, StructuresAdded> structuresAdded = new HashMap<class_2960, StructuresAdded>();
    private static final Map<class_2960, LandmarksAdded> landmarksAdded = new HashMap<class_2960, LandmarksAdded>();
    private static final Map<class_2960, LandmarksRemoved> landmarksRemoved = new HashMap<class_2960, LandmarksRemoved>();

    public static class Register {
        public static void worldLoad(class_2960 id, WorldLoad handler) {
            worldLoad.put(id, handler);
        }

        public static void terrainUpdated(class_2960 id, TerrainUpdated handler) {
            terrainUpdated.put(id, handler);
        }

        public static void structuresAdded(class_2960 id, StructuresAdded handler) {
            structuresAdded.put(id, handler);
        }

        public static void landmarksAdded(class_2960 id, LandmarksAdded handler) {
            landmarksAdded.put(id, handler);
        }

        public static void landmarksRemoved(class_2960 id, LandmarksRemoved handler) {
            landmarksRemoved.put(id, handler);
        }
    }

    public static class Invoke {
        public static void worldLoad(class_3218 world) {
            if (worldLoad.isEmpty()) {
                return;
            }
            WorldSummary summary = WorldSummary.of((class_1937)world);
            worldLoad.forEach((id, handler) -> handler.onWorldLoad(world, summary));
        }

        public static void terrainUpdated(class_1937 world, Collection<class_1923> chunks) {
            if (terrainUpdated.isEmpty() || chunks.isEmpty()) {
                return;
            }
            WorldTerrainSummary summary = WorldSummary.of(world).terrain();
            terrainUpdated.forEach((id, handler) -> handler.onTerrainUpdated(world, summary, chunks));
        }

        public static void terrainUpdated(class_1937 world, class_1923 pos) {
            Invoke.terrainUpdated(world, List.of(pos));
        }

        public static void structuresAdded(class_1937 world, Multimap<class_5321<class_3195>, class_1923> structures) {
            if (structuresAdded.isEmpty() || structures.isEmpty()) {
                return;
            }
            WorldStructureSummary summary = WorldSummary.of(world).structures();
            structuresAdded.forEach((id, handler) -> handler.onStructuresAdded(world, summary, structures));
        }

        public static void structuresAdded(class_1937 world, class_5321<class_3195> key, class_1923 pos) {
            Invoke.structuresAdded(world, MapUtil.asMultiMap(Map.of(key, List.of(pos))));
        }

        public static void landmarksAdded(class_1937 world, Multimap<UUID, class_2960> landmarks) {
            if (landmarksAdded.isEmpty() || landmarks.isEmpty()) {
                return;
            }
            WorldLandmarks summary = WorldSummary.of(world).landmarks();
            landmarksAdded.forEach((id, handler) -> handler.onLandmarksAdded(world, summary, landmarks));
        }

        public static void landmarksRemoved(class_1937 world, Multimap<UUID, class_2960> landmarks) {
            if (landmarksRemoved.isEmpty() || landmarks.isEmpty()) {
                return;
            }
            WorldLandmarks summary = WorldSummary.of(world).landmarks();
            landmarksRemoved.forEach((id, handler) -> handler.onLandmarksRemoved(world, summary, landmarks));
        }
    }

    @FunctionalInterface
    public static interface LandmarksRemoved {
        public void onLandmarksRemoved(class_1937 var1, WorldLandmarks var2, Multimap<UUID, class_2960> var3);
    }

    @FunctionalInterface
    public static interface LandmarksAdded {
        public void onLandmarksAdded(class_1937 var1, WorldLandmarks var2, Multimap<UUID, class_2960> var3);
    }

    @FunctionalInterface
    public static interface StructuresAdded {
        public void onStructuresAdded(class_1937 var1, WorldStructureSummary var2, Multimap<class_5321<class_3195>, class_1923> var3);
    }

    @FunctionalInterface
    public static interface TerrainUpdated {
        public void onTerrainUpdated(class_1937 var1, WorldTerrainSummary var2, Collection<class_1923> var3);
    }

    @FunctionalInterface
    public static interface WorldLoad {
        public void onWorldLoad(class_3218 var1, WorldSummary var2);
    }
}

