/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.google.common.collect.Multimap;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.SurveyorNetworking;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.NetworkHandlerSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.packet.C2SKnownLandmarksPacket;
import folk.sisby.surveyor.packet.C2SKnownStructuresPacket;
import folk.sisby.surveyor.packet.C2SKnownTerrainPacket;
import folk.sisby.surveyor.packet.S2CGroupAmendedPacket;
import folk.sisby.surveyor.packet.S2CGroupChangedPacket;
import folk.sisby.surveyor.packet.S2CGroupUpdatedPacket;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRequestedPacket;
import folk.sisby.surveyor.util.MapUtil;
import java.util.BitSet;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_8710;

public class SurveyorClientNetworking {
    public static void init() {
        SurveyorNetworking.C2S_SENDER = (r, p) -> {
            if (!ClientPlayNetworking.canSend((class_8710.class_9154)p.method_56479())) {
                return;
            }
            p.toPayloads((class_5455)r).forEach(ClientPlayNetworking::send);
        };
        ClientPlayNetworking.registerGlobalReceiver(S2CStructuresAddedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleStructuresAdded));
        ClientPlayNetworking.registerGlobalReceiver(S2CUpdateRegionPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleTerrainAdded));
        ClientPlayNetworking.registerGlobalReceiver(S2CGroupChangedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleGroupChanged));
        ClientPlayNetworking.registerGlobalReceiver(S2CGroupAmendedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleGroupAmended));
        ClientPlayNetworking.registerGlobalReceiver(S2CGroupUpdatedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleGroupUpdated));
        ClientPlayNetworking.registerGlobalReceiver(SyncLandmarksAddedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleLandmarksAdded));
        ClientPlayNetworking.registerGlobalReceiver(SyncLandmarksRemovedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleLandmarksRemoved));
        ClientPlayNetworking.registerGlobalReceiver(SyncLandmarksRequestedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleLandmarksRequested));
    }

    private static void handleTerrainAdded(class_638 world, WorldSummary summary, S2CUpdateRegionPacket packet) {
        if (summary.terrain() == null) {
            return;
        }
        BitSet changed = summary.terrain().getRegion(packet.regionPos()).readUpdatePacket(packet);
        (packet.shared() ? SurveyorClient.getSharedExploration() : SurveyorClient.getPersonalExploration()).mergeRegion((class_5321<class_1937>)world.method_27983(), packet.regionPos(), packet.set());
        SurveyorEvents.Invoke.terrainUpdated((class_1937)world, packet.set().stream().mapToObj(i -> packet.regionPos().toChunk(i)).toList());
        if (changed.cardinality() > 1) {
            Surveyor.LOGGER.info("[Surveyor] Received {} chunks in {} from the server.", (Object)changed.cardinality(), (Object)packet.regionPos());
        }
    }

    private static void handleStructuresAdded(class_638 world, WorldSummary summary, S2CStructuresAddedPacket packet) {
        if (summary.structures() == null) {
            return;
        }
        Multimap<class_5321<class_3195>, class_1923> keySet = summary.structures().readUpdatePacket((class_1937)world, packet);
        if (class_310.method_1551().field_1724 != null && !keySet.isEmpty()) {
            SurveyorExploration exploration = packet.shared() ? SurveyorClient.getSharedExploration() : SurveyorClient.getPersonalExploration();
            keySet.forEach((key, pos) -> exploration.addStructure((class_5321<class_1937>)world.method_27983(), (class_5321<class_3195>)key, (class_1923)pos));
            Surveyor.LOGGER.info("[Surveyor] Received {} structures from the server - {}", (Object)keySet.size(), (Object)keySet.keySet().stream().map(r -> r.method_29177().toString()).collect(Collectors.joining(", ")));
        }
    }

    private static void handleGroupChanged(class_638 world, WorldSummary summary, S2CGroupChangedPacket packet) {
        if (!SurveyorClient.getSharedExploration().groupPlayers().equals(packet.players().keySet())) {
            SurveyorClient.getSharedExploration().groupPlayers().clear();
            SurveyorClient.getSharedExploration().groupPlayers().addAll(packet.players().keySet());
        }
        NetworkHandlerSummary.of(class_310.method_1551().method_1562()).matchSummaries(packet.players());
        SurveyorClient.getSharedExploration().replaceTerrain((class_5321<class_1937>)world.method_27983(), packet.regionBits());
        SurveyorClient.getSharedExploration().replaceStructures((class_5321<class_1937>)world.method_27983(), packet.structureKeys());
        SurveyorClient.getExploration().updateClientForLandmarks((class_1937)world);
        if (summary != null) {
            if (summary.terrain() != null && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SOLO)) {
                new C2SKnownTerrainPacket(summary.terrain().bitSet(null)).send(world.method_30349());
            }
            if (summary.structures() != null && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.SOLO)) {
                new C2SKnownStructuresPacket(summary.structures().keySet(null)).send(world.method_30349());
            }
            if (summary.landmarks() != null && Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.SOLO)) {
                new C2SKnownLandmarksPacket(summary.landmarks().keySet(null)).send(world.method_30349());
            }
            Surveyor.LOGGER.info("[Surveyor] Received updated share group of {} from the server - {}", (Object)packet.players().size(), (Object)packet.players().values().stream().map(PlayerSummary::username).collect(Collectors.joining(", ")));
        }
    }

    private static void handleGroupAmended(class_638 world, WorldSummary summary, S2CGroupAmendedPacket packet) {
        SurveyorClient.getSharedExploration().groupPlayers().add(packet.player());
        class_1657 player = world.method_18470(packet.player());
        Surveyor.LOGGER.info("[Surveyor] Received additional share group player {}", player == null ? packet.player() : player.method_7334().getName());
    }

    private static void handleGroupUpdated(class_638 world, WorldSummary summary, S2CGroupUpdatedPacket packet) {
        NetworkHandlerSummary.of(class_310.method_1551().method_1562()).mergeSummaries(packet.players());
    }

    private static void handleLandmarksAdded(class_638 world, WorldSummary summary, SyncLandmarksAddedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().readUpdatePacket((class_1937)world, packet, null);
        Multimap<UUID, class_2960> keys = MapUtil.keyMultiMap(packet.landmarks());
        Surveyor.LOGGER.info("[Surveyor] Received {} landmarks from the server - {}", (Object)keys.size(), (Object)keys.values().stream().map(class_2960::toString).collect(Collectors.joining(", ")));
    }

    private static void handleLandmarksRemoved(class_638 world, WorldSummary summary, SyncLandmarksRemovedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().readUpdatePacket((class_1937)world, packet, null);
        Surveyor.LOGGER.info("[Surveyor] Received {} landmark removals from the server - {}", (Object)packet.landmarks().size(), (Object)packet.landmarks().values().stream().map(class_2960::toString).collect(Collectors.joining(", ")));
    }

    private static void handleLandmarksRequested(class_638 world, WorldSummary summary, SyncLandmarksRequestedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().createUpdatePacket(packet.landmarks()).send(world.method_30349());
        Surveyor.LOGGER.info("[Surveyor] Received {} landmark requests from the server - {}", (Object)packet.landmarks().size(), (Object)packet.landmarks().values().stream().map(class_2960::toString).collect(Collectors.joining(", ")));
    }

    private static <T extends S2CPacket> void handleClient(T packet, ClientPlayNetworking.Context context, ClientPacketHandler<T> handler) {
        WorldSummary summary;
        class_638 world = context.client().field_1687;
        WorldSummary worldSummary = summary = world == null ? null : WorldSummary.of((class_1937)world);
        if (summary != null && !summary.isClient()) {
            return;
        }
        class_310.method_1551().execute(() -> handler.handle(world, summary, packet));
    }

    public static interface ClientPacketHandler<T> {
        public void handle(class_638 var1, WorldSummary var2, T var3);
    }
}

