/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.packet.SurveyorPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public interface S2CPacket
extends SurveyorPacket {
    default public void send(Collection<class_3222> players) {
        if (players.isEmpty()) {
            return;
        }
        List<SurveyorPacket> split = this.toPayloads(players.stream().findFirst().orElseThrow().method_56673());
        if (split.isEmpty()) {
            return;
        }
        for (class_3222 player : players) {
            if (!ServerPlayNetworking.canSend((class_3222)player, (class_8710.class_9154)this.method_56479()) || player.method_5682().method_19466(player.method_7334())) continue;
            split.forEach(p -> ServerPlayNetworking.send((class_3222)player, (class_8710)p));
        }
    }

    default public void send(class_3222 player) {
        this.send(List.of(player));
    }

    default public void send(class_3218 world) {
        this.send(world.method_18456());
    }

    default public void send(class_3222 sender, class_3218 world) {
        ArrayList<class_3222> players = new ArrayList<class_3222>(world.method_18456());
        players.remove(sender);
        this.send(players);
    }

    default public void send(class_3222 sender, MinecraftServer server, Collection<class_3222> allPlayers, NetworkMode mode) {
        if (mode.atMost(NetworkMode.NONE) || sender != null && mode.atMost(NetworkMode.SOLO)) {
            return;
        }
        ArrayList<class_3222> players = new ArrayList<class_3222>(allPlayers);
        players.remove(sender);
        if (sender != null && mode.atMost(NetworkMode.GROUP)) {
            Set<class_3222> group = ServerSummary.of(server).groupOtherServerPlayers(Surveyor.getUuid(sender), server);
            players.removeIf(p -> !group.contains(p));
        }
        this.send(players);
    }

    default public void send(class_3222 sender, class_3218 world, NetworkMode mode) {
        this.send(sender, world.method_8503(), world.method_18456(), mode);
    }

    default public void send(MinecraftServer server) {
        this.send(server.method_3760().method_14571());
    }

    default public void send(class_3222 sender, MinecraftServer server) {
        ArrayList<class_3222> players = new ArrayList<class_3222>(server.method_3760().method_14571());
        players.remove(sender);
        this.send(players);
    }
}

