/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.structure;

import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.structure.JigsawPieceSummary;
import folk.sisby.surveyor.structure.StructurePieceSummary;
import folk.sisby.surveyor.structure.StructureStartSummary;
import folk.sisby.surveyor.util.MapUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3773;
import net.minecraft.class_5321;
import net.minecraft.class_6625;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class RegionStructureSummary {
    public static final String KEY_STRUCTURES = "structures";
    public static final String KEY_STARTS = "starts";
    public static final String KEY_PIECES = "pieces";
    protected final Map<class_5321<class_3195>, Map<class_1923, StructureStartSummary>> structures = new ConcurrentHashMap<class_5321<class_3195>, Map<class_1923, StructureStartSummary>>();
    protected boolean dirty = false;

    RegionStructureSummary() {
    }

    RegionStructureSummary(Map<class_5321<class_3195>, Map<class_1923, StructureStartSummary>> structures) {
        this.structures.putAll(structures);
    }

    protected static StructureStartSummary summarisePieces(class_6625 context, class_3449 start) {
        ArrayList<StructurePieceSummary> pieces = new ArrayList<StructurePieceSummary>();
        for (class_3443 piece : start.method_14963()) {
            if (piece.method_16653().equals((Object)class_3773.field_25840)) {
                pieces.addAll(JigsawPieceSummary.tryFromPiece(piece));
                continue;
            }
            pieces.add(StructurePieceSummary.fromPiece(context, piece, start.method_14963().size() <= 10));
        }
        return new StructureStartSummary(pieces);
    }

    public static StructurePieceSummary readStructurePieceNbt(class_2487 nbt) {
        if (nbt.method_10558("id").equals(class_7923.field_41146.method_10221((Object)class_3773.field_25840).toString())) {
            return new JigsawPieceSummary(nbt);
        }
        return new StructurePieceSummary(nbt);
    }

    protected static RegionStructureSummary readNbt(class_2487 nbt) {
        ConcurrentHashMap<class_5321<class_3195>, Map<class_1923, StructureStartSummary>> structures = new ConcurrentHashMap<class_5321<class_3195>, Map<class_1923, StructureStartSummary>>();
        class_2487 structuresCompound = nbt.method_10562(KEY_STRUCTURES).orElse(new class_2487());
        for (String structureId : structuresCompound.method_10541()) {
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60654((String)structureId));
            class_2487 structureCompound = structuresCompound.method_10562(structureId).orElse(new class_2487());
            class_2487 startsCompound = structureCompound.method_10562(KEY_STARTS).orElse(new class_2487());
            for (String posKey : startsCompound.method_10541()) {
                int x = Integer.parseInt(posKey.split(",")[0]);
                int z = Integer.parseInt(posKey.split(",")[1]);
                class_2487 startCompound = startsCompound.method_10562(posKey).orElse(new class_2487());
                ArrayList<StructurePieceSummary> pieces = new ArrayList<StructurePieceSummary>();
                for (class_2520 pieceElement : startCompound.method_10554(KEY_PIECES).orElse(new class_2499())) {
                    pieces.add(RegionStructureSummary.readStructurePieceNbt((class_2487)pieceElement));
                }
                structures.computeIfAbsent((class_5321<class_3195>)key, p -> new ConcurrentHashMap()).put(new class_1923(x, z), new StructureStartSummary(pieces));
            }
        }
        return new RegionStructureSummary(structures);
    }

    public boolean contains(class_1937 world, class_3449 start) {
        class_5321 key = world.method_30349().method_30530(class_7924.field_41246).method_29113((Object)start.method_16656()).orElse(null);
        if (key == null) {
            Surveyor.LOGGER.error("Encountered an unregistered structure! {} | {}", (Object)start, (Object)start.method_16656());
            return true;
        }
        return this.structures.containsKey(key) && this.structures.get(key).containsKey(start.method_34000());
    }

    public boolean contains(class_5321<class_3195> key, class_1923 pos) {
        return this.structures.containsKey(key) && this.structures.get(key).containsKey(pos);
    }

    public StructureStartSummary get(class_5321<class_3195> key, class_1923 pos) {
        return this.structures.get(key).get(pos);
    }

    public Multimap<class_5321<class_3195>, class_1923> keySet() {
        return MapUtil.keyMultiMap(this.structures);
    }

    public void put(class_3218 world, class_3449 start) {
        class_5321 key = (class_5321)world.method_30349().method_30530(class_7924.field_41246).method_29113((Object)start.method_16656()).orElseThrow();
        this.structures.computeIfAbsent((class_5321<class_3195>)key, k -> new ConcurrentHashMap());
        class_1923 pos = start.method_34000();
        StructureStartSummary summary = RegionStructureSummary.summarisePieces(class_6625.method_38713((class_3218)world), start);
        this.structures.get(key).put(pos, summary);
        this.dirty();
    }

    public void put(class_5321<class_3195> key, class_1923 pos, StructureStartSummary summary) {
        this.structures.computeIfAbsent(key, k -> new ConcurrentHashMap()).put(pos, summary);
        this.dirty();
    }

    protected class_2487 writeNbt(class_2487 nbt) {
        class_2487 structuresCompound = new class_2487();
        this.structures.forEach((key, starts) -> {
            class_2487 structureCompound = new class_2487();
            class_2487 startsCompound = new class_2487();
            starts.forEach((pos, summary) -> {
                class_2499 pieceList = new class_2499(summary.getChildren().stream().map(p -> p.toNbt()).toList());
                class_2487 startCompound = new class_2487();
                startCompound.method_10566(KEY_PIECES, (class_2520)pieceList);
                startsCompound.method_10566("%s,%s".formatted(pos.field_9181, pos.field_9180), (class_2520)startCompound);
            });
            structureCompound.method_10566(KEY_STARTS, (class_2520)startsCompound);
            structuresCompound.method_10566(key.method_29177().toString(), (class_2520)structureCompound);
        });
        nbt.method_10566(KEY_STRUCTURES, (class_2520)structuresCompound);
        return nbt;
    }

    public boolean isDirty() {
        return this.dirty && Surveyor.CONFIG.structures != SystemMode.FROZEN;
    }

    private void dirty() {
        this.dirty = true;
    }
}

