/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.SurveyorServer;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.packet.S2CGroupAmendedPacket;
import folk.sisby.surveyor.packet.S2CGroupChangedPacket;
import folk.sisby.surveyor.packet.S2CGroupUpdatedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.util.RegionPos;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_148;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3324;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class ServerSummary {
    public static final String KEY_GROUPS = "groups";
    public static final UUID HOST = UUID.fromString("00000000-0000-0000-0000-000000000000");
    private final Map<UUID, PlayerSummary> offlineSummaries;
    private final Map<UUID, Set<UUID>> shareGroups;
    private boolean dirty = false;

    public ServerSummary(Map<UUID, PlayerSummary> offlineSummaries, @Nullable Map<UUID, Set<UUID>> shareGroups) {
        this.offlineSummaries = offlineSummaries;
        this.shareGroups = shareGroups;
    }

    public static ServerSummary of(MinecraftServer server) {
        return ((SurveyorServer)server).surveyor$getSummary();
    }

    public static Map<UUID, Set<UUID>> loadShareGroups(MinecraftServer server) {
        File folder = Surveyor.getSavePath((class_5321<class_1937>)class_1937.field_25179, server);
        class_2487 sharingNbt = new class_2487();
        File sharingFile = new File(folder, "sharing.dat");
        if (sharingFile.exists()) {
            try {
                sharingNbt = class_2507.method_30613((File)sharingFile);
            }
            catch (IOException | class_148 e) {
                Surveyor.LOGGER.error("[Surveyor] Error loading sharing file.", e);
            }
        }
        ConcurrentHashMap<UUID, Set<UUID>> shareGroups = new ConcurrentHashMap<UUID, Set<UUID>>();
        sharingNbt.method_10554(KEY_GROUPS, 9).stream().map(l -> ((class_2499)l).stream().map(s -> UUID.fromString(s.method_10714())).collect(Collectors.toCollection(HashSet::new))).forEach(set -> {
            for (UUID uuid : set) {
                shareGroups.put(uuid, (Set<UUID>)set);
            }
        });
        return shareGroups;
    }

    public static ServerSummary load(MinecraftServer server) {
        Map<UUID, Set<UUID>> shareGroups = Surveyor.CONFIG.networking.globalSharing ? null : ServerSummary.loadShareGroups(server);
        File playerFolder = server.method_27050(class_5218.field_24182).toFile();
        ConcurrentHashMap<UUID, PlayerSummary> offlineSummaries = new ConcurrentHashMap<UUID, PlayerSummary>();
        class_2487 hostData = server.method_27728().method_226();
        UUID hostProfile = Optional.ofNullable(server.method_43824()).map(GameProfile::getId).orElse(null);
        if (hostData != null) {
            if (hostProfile != null) {
                hostData.method_10582("username", server.method_43824().getName());
            }
            offlineSummaries.put(HOST, new PlayerSummary.OfflinePlayerSummary(HOST, hostData, false));
        }
        for (File file : Optional.ofNullable(playerFolder.listFiles((dir, name) -> name.endsWith(".dat"))).orElse(new File[0])) {
            UUID uuid;
            try {
                uuid = UUID.fromString(file.getName().substring(0, file.getName().length() - ".dat".length()));
                if (uuid.equals(hostProfile)) {
                }
            }
            catch (IllegalArgumentException ex) {}
            continue;
            if (shareGroups != null && !shareGroups.containsKey(uuid)) continue;
            try {
                class_2487 playerNbt = class_2507.method_30613((File)file);
                offlineSummaries.put(uuid, new PlayerSummary.OfflinePlayerSummary(uuid, playerNbt, false));
            }
            catch (IOException | class_148 e) {
                Surveyor.LOGGER.error("[Surveyor] Error loading offline player data for {}!", (Object)uuid, (Object)e);
            }
        }
        if (shareGroups != null) {
            for (UUID uuid : shareGroups.keySet()) {
                if (offlineSummaries.containsKey(uuid)) continue;
                Surveyor.LOGGER.warn("[Surveyor] Player data was missing for shared player {}! Removing from groups...", (Object)uuid);
                shareGroups.get(uuid).remove(uuid);
                shareGroups.remove(uuid);
            }
        }
        return new ServerSummary(offlineSummaries, shareGroups);
    }

    public static void onPlayerJoin(class_3244 handler, PacketSender sender, MinecraftServer server) {
        class_3222 player = handler.method_32311();
        ServerSummary serverSummary = ServerSummary.of(server);
        UUID uuid = Surveyor.getUuid(player);
        boolean known = serverSummary.offlineSummaries.containsKey(uuid);
        if (!known) {
            serverSummary.createPlayer(player);
        }
        if (serverSummary.getGroup(uuid).size() > 1) {
            SurveyorExploration groupExploration = serverSummary.groupExploration(uuid, server);
            Map<UUID, PlayerSummary> groupSummaries = serverSummary.getGroupSummaries(uuid, server);
            new S2CGroupChangedPacket(groupSummaries, groupExploration.terrain().getOrDefault(player.method_37908().method_27983(), new HashMap()), groupExploration.structures().getOrDefault(player.method_37908().method_27983(), new HashMap())).send(player);
            new S2CGroupUpdatedPacket(groupSummaries).send(player);
        }
        if (!known && Surveyor.CONFIG.networking.globalSharing) {
            new S2CGroupAmendedPacket(uuid).send(player, server, server.method_3760().method_14571(), NetworkMode.GROUP);
        }
    }

    public static void onTick(MinecraftServer server) {
        if (server.method_3780() % Surveyor.CONFIG.networking.positionTicks != 0) {
            return;
        }
        ServerSummary serverSummary = ServerSummary.of(server);
        for (Set<UUID> group : serverSummary.getPositionGroups()) {
            HashMap<UUID, PlayerSummary> onlinePlayers = new HashMap<UUID, PlayerSummary>();
            for (UUID uuid : group) {
                class_3222 player = server.method_3760().method_14602(uuid);
                if (player == null) continue;
                onlinePlayers.put(uuid, PlayerSummary.of(player));
            }
            if (onlinePlayers.size() <= 1) continue;
            new S2CGroupUpdatedPacket(onlinePlayers).send(null, server, onlinePlayers.keySet().stream().map(arg_0 -> ((class_3324)server.method_3760()).method_14602(arg_0)).toList(), Surveyor.CONFIG.networking.positions);
        }
    }

    public void save(MinecraftServer server, boolean force, boolean suppressLogs) {
        if (!this.isDirty() && StreamSupport.stream(server.method_3738().spliterator(), false).map(WorldSummary::of).noneMatch(WorldSummary::isDirty)) {
            return;
        }
        if (!suppressLogs) {
            Surveyor.LOGGER.info("[Surveyor] Saving server data...");
        }
        for (class_3218 world : server.method_3738()) {
            if (world.field_13957 && !force) continue;
            WorldSummary.of((class_1937)world).save((class_1937)world, Surveyor.getSavePath((class_5321<class_1937>)world.method_27983(), server), suppressLogs);
        }
        File folder = Surveyor.getSavePath((class_5321<class_1937>)class_1937.field_25179, server);
        if (this.isDirty()) {
            File sharingFile = new File(folder, "sharing.dat");
            try {
                class_2507.method_30614((class_2487)this.writeNbt(new class_2487()), (File)sharingFile);
                this.dirty = false;
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error writing sharing file.", (Throwable)e);
            }
        }
        if (!suppressLogs) {
            Surveyor.LOGGER.info("[Surveyor] Finished saving server data.");
        }
    }

    private class_2487 writeNbt(class_2487 nbt) {
        if (this.shareGroups != null) {
            nbt.method_10566(KEY_GROUPS, (class_2520)new class_2499(this.shareGroups.values().stream().filter(s -> s.size() > 1).map(s -> new class_2499(s.stream().map(u -> class_2519.method_23256((String)u.toString())).toList(), 8)).toList(), 9));
        }
        return nbt;
    }

    public PlayerSummary getPlayer(UUID uuid, MinecraftServer server) {
        class_3222 player = Surveyor.getPlayer(server, uuid);
        if (player != null) {
            return PlayerSummary.of(player);
        }
        return this.offlineSummaries.get(uuid);
    }

    public SurveyorExploration getExploration(UUID player, MinecraftServer server) {
        PlayerSummary summary = this.getPlayer(player, server);
        return summary == null ? null : summary.exploration();
    }

    public void createPlayer(class_3222 player) {
        this.offlineSummaries.put(Surveyor.getUuid(player), new PlayerSummary.OfflinePlayerSummary(player));
    }

    public void updatePlayer(UUID uuid, class_2487 nbt, boolean online, MinecraftServer server) {
        PlayerSummary.OfflinePlayerSummary newSummary = new PlayerSummary.OfflinePlayerSummary(uuid, nbt, online);
        this.offlineSummaries.put(uuid, newSummary);
        S2CGroupUpdatedPacket.of(uuid, newSummary).send(null, server, server.method_3760().method_14571(), Surveyor.CONFIG.networking.positions);
    }

    public Set<Set<UUID>> getPositionGroups() {
        return Surveyor.CONFIG.networking.positions.atLeast(NetworkMode.SERVER) ? Set.of(this.offlineSummaries.keySet()) : (Surveyor.CONFIG.networking.positions.atMost(NetworkMode.SOLO) ? Set.of() : this.getGroups());
    }

    public Set<Set<UUID>> getGroups() {
        return this.shareGroups == null ? new HashSet<HashSet<UUID>>(Set.of(new HashSet<UUID>(this.offlineSummaries.keySet()))) : new HashSet<Set<UUID>>(this.shareGroups.values());
    }

    public Set<UUID> getGroup(UUID player) {
        return this.shareGroups == null ? new HashSet<UUID>(this.offlineSummaries.keySet()) : this.shareGroups.computeIfAbsent(player, p -> new HashSet<UUID>(Set.of(p)));
    }

    public Map<UUID, PlayerSummary> getAllSummaries(MinecraftServer server) {
        HashMap<UUID, PlayerSummary> map = new HashMap<UUID, PlayerSummary>();
        for (UUID u : this.offlineSummaries.keySet()) {
            if (this.getPlayer(u, server) == null) continue;
            map.put(u, this.getPlayer(u, server));
        }
        return map;
    }

    public Map<UUID, PlayerSummary> getGroupSummaries(UUID player, MinecraftServer server) {
        HashMap<UUID, PlayerSummary> map = new HashMap<UUID, PlayerSummary>();
        for (UUID u : this.getGroup(player)) {
            if (this.getPlayer(u, server) == null) continue;
            map.put(u, this.getPlayer(u, server));
        }
        return map;
    }

    public void joinGroup(UUID player1, UUID player2, MinecraftServer server) {
        if (this.shareGroups == null) {
            return;
        }
        if (this.getGroup(player1).size() > 1 && this.getGroup(player2).size() > 1) {
            throw new IllegalStateException("Can't merge two groups!");
        }
        if (this.getGroup(player1).size() > 1) {
            this.getGroup(player1).add(player2);
            this.shareGroups.put(player2, this.getGroup(player1));
        } else {
            this.getGroup(player2).add(player1);
            this.shareGroups.put(player1, this.getGroup(player2));
        }
        SurveyorExploration groupExploration = this.groupExploration(player1, server);
        for (class_3222 friend : this.groupServerPlayers(player1, server)) {
            new S2CGroupChangedPacket(this.getGroupSummaries(player1, server), groupExploration.terrain().getOrDefault(friend.method_37908().method_27983(), new HashMap()), groupExploration.structures().getOrDefault(friend.method_37908().method_27983(), new HashMap())).send(friend);
            WorldLandmarks landmarks = WorldSummary.of(friend.method_37908()).landmarks();
            if (landmarks == null || Surveyor.CONFIG.networking.landmarks.atMost(NetworkMode.SOLO)) continue;
            Multimap<UUID, class_2960> sharedLandmarks = landmarks.keySet(groupExploration);
            landmarks.keySet(SurveyorExploration.of(friend)).forEach((arg_0, arg_1) -> sharedLandmarks.remove(arg_0, arg_1));
            if (!sharedLandmarks.isEmpty()) {
                SyncLandmarksAddedPacket.of(sharedLandmarks, landmarks).send(friend);
            }
            Multimap<UUID, class_2960> removedLandmarks = landmarks.removed();
            removedLandmarks.keySet().removeIf(uuid -> !groupExploration.sharedPlayers().contains(uuid));
            if (removedLandmarks.isEmpty()) continue;
            new SyncLandmarksRemovedPacket(removedLandmarks).send(friend);
        }
        this.dirty();
    }

    public void leaveGroup(UUID player, MinecraftServer server) {
        if (this.shareGroups == null) {
            return;
        }
        this.getGroup(player).remove(player);
        SurveyorExploration groupExploration = this.groupExploration(player, server);
        for (class_3222 friend : this.groupOtherServerPlayers(player, server)) {
            new S2CGroupChangedPacket(this.getGroupSummaries(Surveyor.getUuid(friend), server), groupExploration.terrain().getOrDefault(friend.method_37908().method_27983(), new HashMap()), groupExploration.structures().getOrDefault(friend.method_37908().method_27983(), new HashMap())).send(friend);
        }
        this.shareGroups.put(player, new HashSet());
        this.getGroup(player).add(player);
        class_3222 serverPlayer = Surveyor.getPlayer(server, player);
        if (serverPlayer != null) {
            new S2CGroupChangedPacket(this.getGroupSummaries(player, server), new HashMap<RegionPos, BitSet>(), new HashMap<class_5321<class_3195>, LongSet>()).send(serverPlayer);
        }
        this.dirty();
    }

    public int groupSize(UUID player) {
        return this.getGroup(player).size();
    }

    public Set<PlayerSummary> groupPlayers(UUID player, MinecraftServer server) {
        return this.getGroup(player).stream().map(u -> this.getPlayer((UUID)u, server)).collect(Collectors.toSet());
    }

    public SurveyorExploration groupExploration(UUID player, MinecraftServer server) {
        return PlayerSummary.OfflinePlayerSummary.OfflinePlayerExploration.ofMerged(this.getGroup(player).stream().map(u -> this.getExploration((UUID)u, server)).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public Set<class_3222> groupServerPlayers(UUID player, MinecraftServer server) {
        return this.getGroup(player).stream().map(uuid -> Surveyor.getPlayer(server, uuid)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<class_3222> allOtherServerPlayers(UUID player, MinecraftServer server) {
        return server.method_3760().method_14571().stream().filter(p -> !Surveyor.getUuid(p).equals(player)).collect(Collectors.toSet());
    }

    public Set<class_3222> groupOtherServerPlayers(UUID player, MinecraftServer server) {
        return this.getGroup(player).stream().filter(u -> !u.equals(player)).map(arg_0 -> ((class_3324)server.method_3760()).method_14602(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean isDirty() {
        return this.dirty && this.shareGroups != null;
    }

    private void dirty() {
        this.dirty = true;
    }
}

