/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.structure.StructureStartSummary;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.util.MapUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1923;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7151;
import net.minecraft.class_7924;

public record S2CStructuresAddedPacket(boolean shared, Map<class_5321<class_3195>, Map<class_1923, StructureStartSummary>> structures, Map<class_5321<class_3195>, class_5321<class_7151<?>>> types, Multimap<class_5321<class_3195>, class_6862<class_3195>> tags) implements S2CPacket
{
    public static final class_2960 ID = Surveyor.id("s2c_structures_added");

    public static S2CStructuresAddedPacket of(boolean shared, Multimap<class_5321<class_3195>, class_1923> keys, WorldStructureSummary summary) {
        return summary.createUpdatePacket(shared, keys);
    }

    public static S2CStructuresAddedPacket of(boolean shared, class_5321<class_3195> key, class_1923 pos, WorldStructureSummary summary) {
        return S2CStructuresAddedPacket.of(shared, MapUtil.asMultiMap(Map.of(key, List.of(pos))), summary);
    }

    public static S2CStructuresAddedPacket read(class_2540 buf) {
        return new S2CStructuresAddedPacket(buf.readBoolean(), buf.method_34067(b -> b.method_44112(class_7924.field_41246), b -> b.method_34067(class_2540::method_36133, b2 -> new StructureStartSummary(b2.method_34066(b3 -> WorldStructureSummary.readStructurePieceNbt(Objects.requireNonNull(b3.method_10798())))))), buf.method_34067(b -> b.method_44112(class_7924.field_41246), b -> b.method_44112(class_7924.field_41231)), MapUtil.asMultiMap(buf.method_34067(b -> b.method_44112(class_7924.field_41246), b -> b.method_34066(b2 -> class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)b2.method_10810())))));
    }

    @Override
    public void writeBuf(class_2540 buf) {
        buf.writeBoolean(this.shared);
        buf.method_34063(this.structures, class_2540::method_44116, (b, posMap) -> b.method_34063(posMap, class_2540::method_36130, (b2, summary) -> b2.method_34062(summary.getChildren(), (b3, piece) -> b3.method_10794(piece.toNbt()))));
        buf.method_34063(this.types, class_2540::method_44116, class_2540::method_44116);
        buf.method_34063(this.tags.asMap(), class_2540::method_44116, (b, c) -> b.method_34062(c, (b2, t) -> b2.method_10812(t.comp_327())));
    }

    @Override
    public Collection<class_2540> toBufs() {
        ArrayList<class_2540> bufs = new ArrayList<class_2540>();
        class_2540 buf = new class_2540(Unpooled.buffer());
        this.writeBuf(buf);
        if (buf.readableBytes() < 0x100000) {
            bufs.add(buf);
        } else {
            Multimap<class_5321<class_3195>, class_1923> keySet = MapUtil.keyMultiMap(this.structures);
            if (keySet.size() == 1) {
                Surveyor.LOGGER.error("Couldn't create a structure update packet for {} - an individual structure would be too large to send!", (Object)((class_5321)keySet.keys().stream().findFirst().orElseThrow()).method_29177());
                return List.of();
            }
            HashMultimap firstHalf = HashMultimap.create();
            HashMultimap secondHalf = HashMultimap.create();
            keySet.forEach((arg_0, arg_1) -> S2CStructuresAddedPacket.lambda$toBufs$14((Multimap)firstHalf, keySet, (Multimap)secondHalf, arg_0, arg_1));
            bufs.addAll(new S2CStructuresAddedPacket(this.shared, MapUtil.splitByKeyMap(this.structures, firstHalf), MapUtil.splitByKeySet(this.types, firstHalf.keySet()), MapUtil.asMultiMap(MapUtil.splitByKeySet(this.tags.asMap(), firstHalf.keySet()))).toBufs());
            bufs.addAll(new S2CStructuresAddedPacket(this.shared, MapUtil.splitByKeyMap(this.structures, secondHalf), MapUtil.splitByKeySet(this.types, secondHalf.keySet()), MapUtil.asMultiMap(MapUtil.splitByKeySet(this.tags.asMap(), secondHalf.keySet()))).toBufs());
        }
        return bufs;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    private static /* synthetic */ void lambda$toBufs$14(Multimap firstHalf, Multimap keySet, Multimap secondHalf, class_5321 key, class_1923 pos) {
        if (firstHalf.size() < keySet.size() / 2) {
            firstHalf.put((Object)key, (Object)pos);
        } else {
            secondHalf.put((Object)key, (Object)pos);
        }
    }
}

