/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.util;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.util.RegionPos;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_148;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2791;

public class ChunkUtil {
    public static Integer airCount(class_2791 chunk) {
        return Arrays.stream(chunk.method_12006()).mapToInt(s -> 4096 - s.field_12877).sum();
    }

    public static Map<RegionPos, File> getRegionFiles(File folder, String prefix) {
        HashMap<RegionPos, File> files = new HashMap<RegionPos, File>();
        for (File file : Objects.requireNonNullElse(folder.listFiles(), new File[0])) {
            String[] split = file.getName().split("\\.");
            if (split.length != 4 || !split[0].equals(prefix) || !split[3].equals("dat")) continue;
            try {
                files.put(new RegionPos(Integer.parseInt(split[1]), Integer.parseInt(split[2])), file);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return files;
    }

    public static Map<RegionPos, class_2487> getRegionNbt(File folder, String prefix) {
        Map<RegionPos, File> regionFiles = ChunkUtil.getRegionFiles(folder, prefix);
        HashMap<RegionPos, class_2487> regions = new HashMap<RegionPos, class_2487>();
        for (RegionPos regionPos : regionFiles.keySet()) {
            class_2487 regionCompound = null;
            try {
                regionCompound = class_2507.method_30613((File)regionFiles.get(regionPos));
            }
            catch (IOException | class_148 e) {
                Surveyor.LOGGER.error("[Surveyor] Error loading region nbt file {}.", (Object)regionFiles.get(regionPos).getName(), (Object)e);
            }
            if (regionCompound == null) continue;
            regions.put(regionPos, regionCompound);
        }
        return regions;
    }
}

