/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.util.uints;

import folk.sisby.surveyor.util.ArrayUtil;
import folk.sisby.surveyor.util.uints.UInts;
import java.util.BitSet;
import java.util.function.Function;

public interface ArrayUInts
extends UInts {
    @Override
    default public int[] getUnmasked(BitSet mask) {
        int[] unmasked = new int[mask.size()];
        int maskedIndex = 0;
        for (int i = 0; i < unmasked.length; ++i) {
            if (!mask.get(i)) continue;
            unmasked[i] = this.get(maskedIndex);
            ++maskedIndex;
        }
        return unmasked;
    }

    @Override
    default public UInts remap(Function<Integer, Integer> remapping, int defaultValue, int cardinality) {
        int[] newArray = ArrayUtil.ofSingle(defaultValue, cardinality);
        for (int i = 0; i < newArray.length; ++i) {
            int val = this.get(i);
            Integer mapped = remapping.apply(val);
            newArray[i] = mapped == null ? val : mapped;
        }
        return UInts.fromUInts(newArray, defaultValue);
    }
}

