/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DataResult;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.landmark.component.LandmarkComponentType;
import folk.sisby.surveyor.landmark.component.LandmarkComponentTypes;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.TextUtil;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2178;
import net.minecraft.class_2181;
import net.minecraft.class_2232;
import net.minecraft.class_2262;
import net.minecraft.class_2280;
import net.minecraft.class_2287;
import net.minecraft.class_2290;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public class SurveyorCommands {
    private static final Multimap<UUID, UUID> requests = HashMultimap.create();

    public static class_5250 prefix() {
        return class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079));
    }

    public static class_5250 indent() {
        return class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"|| ").method_27692(class_124.field_1079));
    }

    private static void informGroup(class_3222 player, Set<PlayerSummary> group, Consumer<class_2561> feedback) {
        feedback.accept((class_2561)class_2561.method_43470((String)"You're sharing your map with ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(group.size() - 1)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(" other" + (group.size() - 1 > 1 ? " players:" : " player:"))).method_27692(class_124.field_1065)));
        feedback.accept((class_2561)TextUtil.highlightStrings(group.stream().map(PlayerSummary::username).filter(u -> !u.equals(player.method_7334().getName())).toList(), s -> class_124.field_1068).method_27692(class_124.field_1065));
    }

    private static boolean playerMissing(@Nullable class_3222 player, Consumer<class_2561> feedback) {
        if (player == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"Can't run this command as a non-player!")));
            return true;
        }
        return false;
    }

    private static int informGlobal(MinecraftServer server, @Nullable class_3222 player, @Nullable SurveyorExploration exploration, Consumer<class_2561> feedback) {
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"The server has global sharing enabled!").method_27692(class_124.field_1054)));
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"You can't leave or modify the global sharing group!").method_27692(class_124.field_1054)));
        if (SurveyorCommands.playerMissing(player, feedback)) {
            return 0;
        }
        SurveyorCommands.informGroup(player, ServerSummary.of(server).groupPlayers(Surveyor.getUuid(player), player.method_5682()), feedback);
        return 0;
    }

    private static int info(MinecraftServer server, @Nullable class_3222 player, @Nullable SurveyorExploration exploration, Consumer<class_2561> feedback) {
        Set<PlayerSummary> group = player == null ? null : ServerSummary.of(server).groupPlayers(Surveyor.getUuid(player), player.method_5682());
        SurveyorExploration groupExploration = player == null ? null : SurveyorExploration.ofShared(player);
        HashSet landmarks = new HashSet();
        HashSet waypoints = new HashSet();
        HashSet groupLandmarks = new HashSet();
        HashSet groupWaypoints = new HashSet();
        int chunks = exploration == null ? 0 : exploration.chunkCount();
        int structures = exploration == null ? 0 : exploration.structureCount();
        for (class_3218 world : server.method_3738()) {
            WorldLandmarks worldLandmarks = WorldSummary.of((class_1937)world).landmarks();
            if (worldLandmarks != null) {
                worldLandmarks.asMap(exploration).forEach((type, inner) -> inner.forEach((id, landmark) -> (landmark.owner().equals(WorldLandmarks.GLOBAL) ? landmarks : waypoints).add(landmark)));
                if (groupExploration != null) {
                    worldLandmarks.asMap(groupExploration).forEach((type, inner) -> inner.forEach((id, landmark) -> (landmark.owner().equals(WorldLandmarks.GLOBAL) ? groupLandmarks : groupWaypoints).add(landmark)));
                }
            }
            if (exploration != null) continue;
            WorldTerrainSummary terrainSummary = WorldSummary.of((class_1937)world).terrain();
            WorldStructureSummary structureSummary = WorldSummary.of((class_1937)world).structures();
            if (terrainSummary != null) {
                chunks += terrainSummary.bitSet(null).values().stream().mapToInt(BitSet::cardinality).sum();
            }
            if (structureSummary == null) continue;
            structures += structureSummary.keySet(null).size();
        }
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)(player == null ? "Surveyor Data Summary:" : "Map Exploration Summary:"))));
        feedback.accept((class_2561)SurveyorCommands.indent().method_10852((class_2561)class_2561.method_43470((String)(player == null ? "Mapped " : "You've explored ")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(chunks)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" total chunks!").method_27692(class_124.field_1075)).method_10852((class_2561)(group == null || group.size() <= 1 ? class_2561.method_43473() : class_2561.method_43470((String)" (").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupExploration.chunkCount())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" with friends)").method_27692(class_124.field_1075)))));
        feedback.accept((class_2561)SurveyorCommands.indent().method_10852((class_2561)class_2561.method_43470((String)(player == null ? "Mapped " : "You've discovered ")).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(structures)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" structures!").method_27692(class_124.field_1076)).method_10852((class_2561)(group == null || group.size() <= 1 ? class_2561.method_43473() : class_2561.method_43470((String)" (").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupExploration.structureCount())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" with friends)").method_27692(class_124.field_1076)))));
        feedback.accept((class_2561)SurveyorCommands.indent().method_10852((class_2561)class_2561.method_43470((String)(player == null ? "Mapped " : "You've discovered ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(landmarks.size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" landmarks!").method_27692(class_124.field_1060)).method_10852((class_2561)(group == null || group.size() <= 1 ? class_2561.method_43473() : class_2561.method_43470((String)" (").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupLandmarks.size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" with friends)").method_27692(class_124.field_1060)))));
        feedback.accept((class_2561)SurveyorCommands.indent().method_10852((class_2561)class_2561.method_43470((String)(player == null ? "Recorded " : "...and created ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(waypoints.size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" waypoints!").method_27692(class_124.field_1060)).method_10852((class_2561)(group == null || group.size() <= 1 ? class_2561.method_43473() : class_2561.method_43470((String)" (").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupWaypoints.size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" with friends)").method_27692(class_124.field_1060)))));
        if (group != null && group.size() > 1) {
            SurveyorCommands.informGroup(player, group, feedback);
        }
        return 1;
    }

    private static int share(MinecraftServer server, @Nullable class_3222 player, @Nullable SurveyorExploration exploration, Consumer<class_2561> feedback, String username) {
        if (SurveyorCommands.playerMissing(player, feedback)) {
            return 0;
        }
        ServerSummary serverSummary = ServerSummary.of(server);
        class_3222 sharePlayer = server.method_3760().method_14566(username);
        if (sharePlayer == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"Can't find an online player named ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)username).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1054)));
            return 0;
        }
        if (sharePlayer == player) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"You can't share map exploration with yourself!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (requests.containsEntry((Object)Surveyor.getUuid(player), (Object)Surveyor.getUuid(sharePlayer))) {
            if (serverSummary.groupSize(Surveyor.getUuid(player)) > 1 && serverSummary.groupSize(Surveyor.getUuid(sharePlayer)) > 1) {
                feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"You're in a group! leave your group first with:").method_27692(class_124.field_1054)));
                feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"/surveyor unshare").method_27692(class_124.field_1065)));
                return 0;
            }
            requests.removeAll((Object)Surveyor.getUuid(player));
            ServerSummary.of(player.method_5682()).joinGroup(Surveyor.getUuid(player), Surveyor.getUuid(sharePlayer), player.method_5682());
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"You're now sharing map exploration with ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)) - 1)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(serverSummary.groupSize(Surveyor.getUuid(player)) - 1 > 1 ? " players:" : " player:")).method_27692(class_124.field_1060)));
            feedback.accept((class_2561)TextUtil.highlightStrings(serverSummary.groupPlayers(Surveyor.getUuid(player), player.method_5682()).stream().map(PlayerSummary::username).filter(u -> !u.equals(player.method_7334().getName())).toList(), s -> class_124.field_1068).method_27692(class_124.field_1060));
            for (class_3222 friend : serverSummary.groupOtherServerPlayers(Surveyor.getUuid(player), player.method_5682())) {
                friend.method_43496((class_2561)SurveyorCommands.prefix().method_10852((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" is now sharing their map with you.").method_27692(class_124.field_1075)));
                friend.method_43496((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"You're now sharing map exploration with ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)) - 1)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(serverSummary.groupSize(Surveyor.getUuid(player)) - 1 > 1 ? " players:" : " player:")).method_27692(class_124.field_1075)));
                friend.method_43496((class_2561)TextUtil.highlightStrings(serverSummary.groupPlayers(Surveyor.getUuid(player), player.method_5682()).stream().map(PlayerSummary::username).filter(u -> !u.equals(friend.method_7334().getName())).toList(), s -> class_124.field_1068).method_27692(class_124.field_1075));
            }
            return 1;
        }
        if (!requests.containsEntry((Object)Surveyor.getUuid(sharePlayer), (Object)Surveyor.getUuid(player))) {
            requests.put((Object)Surveyor.getUuid(sharePlayer), (Object)Surveyor.getUuid(player));
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"Share request sent to ").method_27692(class_124.field_1060)).method_10852((class_2561)sharePlayer.method_5476().method_27661().method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)));
            sharePlayer.method_43496((class_2561)SurveyorCommands.prefix().method_10852((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" wants to share map exploration!").method_27692(class_124.field_1075)));
            if (serverSummary.groupSize(Surveyor.getUuid(player)) <= 1 && serverSummary.groupSize(Surveyor.getUuid(sharePlayer)) <= 1) {
                feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"If accepted, you'll share your map exploration.").method_27692(class_124.field_1060)));
                sharePlayer.method_43496((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"To share your explored map area, enter:").method_27692(class_124.field_1075)));
            } else if (serverSummary.groupSize(Surveyor.getUuid(player)) <= 1) {
                feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"If accepted, you'll share with their group of ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(sharePlayer)))).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)));
                sharePlayer.method_43496((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"To share your group of ").method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(sharePlayer)))).method_27692(class_124.field_1068)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)", enter:").method_27692(class_124.field_1075)));
            } else {
                feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"If accepted, they'll share with your group of ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)))).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)));
                sharePlayer.method_43496((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"To share with their group of ").method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)))).method_27692(class_124.field_1068)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)", enter:").method_27692(class_124.field_1075)));
            }
            sharePlayer.method_43496((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"/surveyor share %s".formatted(player.method_7334().getName())).method_27692(class_124.field_1065)));
            return 1;
        }
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"You've already sent this player a share request!").method_27692(class_124.field_1054)));
        return 0;
    }

    private static int unshare(MinecraftServer server, @Nullable class_3222 player, @Nullable SurveyorExploration exploration, Consumer<class_2561> feedback) {
        if (SurveyorCommands.playerMissing(player, feedback)) {
            return 0;
        }
        ServerSummary serverSummary = ServerSummary.of(server);
        int shareNumber = serverSummary.groupSize(Surveyor.getUuid(player)) - 1;
        if (shareNumber == 0) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"You're not sharing map exploration with anyone!").method_27692(class_124.field_1054)));
            return 0;
        }
        Set<class_3222> friends = serverSummary.groupOtherServerPlayers(Surveyor.getUuid(player), player.method_5682());
        ServerSummary.of(player.method_5682()).leaveGroup(Surveyor.getUuid(player), player.method_5682());
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"Stopped sharing map exploration with ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(shareNumber)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(shareNumber > 1 ? " players." : " player.")).method_27692(class_124.field_1060)));
        for (class_3222 friend : friends) {
            int groupSize = serverSummary.groupSize(Surveyor.getUuid(friend)) - 1;
            friend.method_43496((class_2561)SurveyorCommands.prefix().method_10852((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" is no longer sharing with you.").method_27692(class_124.field_1075)));
            friend.method_43496((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"You're now sharing map exploration with ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupSize)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(groupSize == 0 ? " players." : (groupSize > 1 ? " players:" : " player:"))).method_27692(class_124.field_1075)));
            if (groupSize <= 0) continue;
            friend.method_43496((class_2561)TextUtil.highlightStrings(serverSummary.groupPlayers(Surveyor.getUuid(friend), friend.method_5682()).stream().map(PlayerSummary::username).filter(u -> !u.equals(friend.method_7334().getName())).toList(), s -> class_124.field_1068).method_27692(class_124.field_1075));
        }
        return 1;
    }

    private static int getLandmarks(MinecraftServer server, @Nullable class_3222 player, @Nullable SurveyorExploration exploration, Consumer<class_2561> feedback, boolean global) {
        Object landmarks;
        LinkedHashMap<class_2960, Collection<Landmark>> dimensionLandmarks = new LinkedHashMap<class_2960, Collection<Landmark>>();
        boolean op = player == null || player.method_5687(2);
        for (class_3218 world : server.method_3738()) {
            WorldSummary summary = WorldSummary.of((class_1937)world);
            if (summary.landmarks() == null) {
                feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
                return 0;
            }
            landmarks = summary.landmarks().asMap(op ? null : (Surveyor.CONFIG.networking.waypoints.atLeast(NetworkMode.GROUP) ? SurveyorExploration.ofShared(player) : SurveyorExploration.of(player)));
            if (global) {
                if (!landmarks.containsKey(WorldLandmarks.GLOBAL)) continue;
                dimensionLandmarks.put(world.method_27983().method_29177(), landmarks.get(WorldLandmarks.GLOBAL).values());
                continue;
            }
            landmarks.remove(WorldLandmarks.GLOBAL);
            dimensionLandmarks.put(world.method_27983().method_29177(), landmarks.values().stream().flatMap(m -> m.values().stream()).toList());
        }
        int numLandmarks = dimensionLandmarks.values().stream().mapToInt(Collection::size).sum();
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"%s %d %s:".formatted(op ? "There are" : "You've discovered", numLandmarks, global ? "Landmarks" : "Waypoints"))));
        for (class_2960 dim : dimensionLandmarks.keySet()) {
            landmarks = (Collection)dimensionLandmarks.get(dim);
            if (!landmarks.isEmpty()) {
                feedback.accept((class_2561)SurveyorCommands.indent().method_10852((class_2561)SurveyorCommands.indent()).method_10852((class_2561)class_2561.method_43470((String)"%s:".formatted(WordUtils.capitalize((String)dim.method_12832().replaceAll("[/_-]", " "))))));
            }
            Iterator iterator = landmarks.iterator();
            while (iterator.hasNext()) {
                Landmark landmark = (Landmark)iterator.next();
                class_5250 idText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"%s:".formatted(landmark.id().method_12836())).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)landmark.id().method_12832()));
                Integer color = landmark.get(LandmarkComponentTypes.COLOR);
                String command = global ? "/landmarks view %s %s".formatted(dim, landmark.id()) : "/waypoints view %s %s%s".formatted(dim, landmark.id(), player != null && landmark.owner().equals(Surveyor.getUuid(player)) ? "" : " " + String.valueOf(landmark.owner()));
                feedback.accept((class_2561)SurveyorCommands.indent().method_10852((class_2561)(player == null || global ? class_2561.method_43473() : class_2561.method_43470((String)"%s | ".formatted(Optional.ofNullable(ServerSummary.of(server).getPlayer(landmark.owner(), server)).map(PlayerSummary::username).orElse(landmark.owner().toString()))).method_27692(class_124.field_1080))).method_10852((class_2561)(player == null && landmark.contains(LandmarkComponentTypes.NAME) ? idText.method_27661().method_27693(" ") : class_2561.method_43473())).method_10852((class_2561)(landmark.contains(LandmarkComponentTypes.NAME) ? class_2561.method_43470((String)"\"").method_10852(landmark.get(LandmarkComponentTypes.NAME)).method_27693("\"") : idText).method_27661().method_27694(arg_0 -> SurveyorCommands.lambda$getLandmarks$13(color, player, global, landmark, (class_2561)idText, command, arg_0))));
            }
        }
        return numLandmarks;
    }

    private static int viewLandmark(MinecraftServer server, @Nullable class_3222 player, @Nullable SurveyorExploration exploration, Consumer<class_2561> feedback, class_3218 world, UUID owner, class_2960 id, boolean raw) {
        boolean cantModify;
        WorldSummary summary = WorldSummary.of((class_1937)world);
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        Landmark landmark = summary.landmarks().get(owner, id);
        if (landmark == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"No landmark exists of that id!").method_27692(class_124.field_1054)));
            return 0;
        }
        boolean bl = cantModify = player != null && !player.method_5687(2) && !landmark.owner().equals(Surveyor.getUuid(player));
        String command = landmark.owner().equals(WorldLandmarks.GLOBAL) ? "/landmarks remove %s %s".formatted(world.method_27983().method_29177(), landmark.id()) : "/waypoints remove %s %s%s".formatted(world.method_27983().method_29177(), landmark.id(), player == null || !landmark.owner().equals(Surveyor.getUuid(player)) ? " " + String.valueOf(landmark.owner()) : "");
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)(owner.equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint ")).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)id.toString())).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)(cantModify ? class_2561.method_43473() : class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"<").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"remove").method_27692(class_124.field_1075).method_27694(s -> s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)command).method_27692(class_124.field_1075))).method_10958(new class_2558(class_2558.class_2559.field_11750, command)))).method_10852((class_2561)class_2561.method_43470((String)">").method_27692(class_124.field_1080)))));
        if (raw) {
            feedback.accept((class_2561)SurveyorCommands.indent().method_10852((class_2561)class_2561.method_43470((String)landmark.toNbt().toString())));
        } else {
            landmark.toText().forEach(t -> feedback.accept((class_2561)SurveyorCommands.indent().method_10852(t)));
        }
        return 1;
    }

    private static int removeLandmark(MinecraftServer server, @Nullable class_3222 player, @Nullable SurveyorExploration exploration, Consumer<class_2561> feedback, class_3218 world, UUID owner, class_2960 id) {
        WorldSummary summary = WorldSummary.of((class_1937)world);
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        Landmark landmark = summary.landmarks().get(owner, id);
        if (landmark == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"No landmark exists of that id!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (!WorldLandmarks.canModify(owner, (class_1937)world, player)) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"You don't have permission to modify that landmark!").method_27692(class_124.field_1054)));
            return 0;
        }
        summary.landmarks().remove((class_1937)world, owner, id);
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)(owner.equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)id.toString())).method_10852((class_2561)class_2561.method_43470((String)" removed successfully!").method_27692(class_124.field_1060)));
        return 1;
    }

    private static int trimLandmark(MinecraftServer server, @Nullable class_3222 player, @Nullable SurveyorExploration exploration, Consumer<class_2561> feedback, class_3218 world, UUID owner, class_2960 id, class_2960 componentType) {
        WorldSummary summary = WorldSummary.of((class_1937)world);
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        Landmark landmark = summary.landmarks().get(owner, id);
        if (landmark == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"No landmark exists of that id!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (!WorldLandmarks.canModify(owner, (class_1937)world, player)) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"You don't have permission to modify that landmark!").method_27692(class_124.field_1054)));
            return 0;
        }
        landmark.components().remove(LandmarkComponentType.getType(componentType));
        summary.landmarks().put((class_1937)world, landmark);
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)(owner.equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)id.toString())).method_10852((class_2561)class_2561.method_43470((String)" trimmed successfully!").method_27692(class_124.field_1060)));
        return 1;
    }

    private static int appendColor(MinecraftServer server, @Nullable class_3222 player, @Nullable SurveyorExploration exploration, Consumer<class_2561> feedback, class_3218 world, UUID owner, class_2960 id, String colorString) {
        WorldSummary summary = WorldSummary.of((class_1937)world);
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        Landmark landmark = summary.landmarks().get(owner, id);
        if (landmark == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"No landmark exists of that id!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (!WorldLandmarks.canModify(landmark.owner(), (class_1937)world, player)) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"You don't have permission to modify that landmark!").method_27692(class_124.field_1054)));
            return 0;
        }
        DataResult color = class_5251.method_27719((String)colorString);
        if (color.isError()) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"Not a valid color! Use color names or hex codes").method_27692(class_124.field_1054)));
            return 0;
        }
        landmark.components().set(LandmarkComponentTypes.COLOR, ((class_5251)color.getOrThrow()).method_27716());
        summary.landmarks().put((class_1937)world, landmark);
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)(owner.equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)id.toString())).method_10852((class_2561)class_2561.method_43470((String)" appended successfully!").method_27692(class_124.field_1060)));
        return 1;
    }

    private static int addBlockLandmark(MinecraftServer server, @Nullable class_3222 player, @Nullable SurveyorExploration exploration, Consumer<class_2561> feedback, class_3218 world, UUID owner, class_2338 pos) {
        WorldSummary summary = WorldSummary.of((class_1937)world);
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (!WorldLandmarks.canModify(owner, (class_1937)world, player)) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"You don't have permission to add that landmark!").method_27692(class_124.field_1054)));
            return 0;
        }
        class_2960 id = Surveyor.id("block/%s/%s/%s".formatted(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        if (summary.landmarks().contains(owner, id)) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"A landmark with this ID already exists! Replacing...").method_27692(class_124.field_1054)));
        }
        summary.landmarks().put((class_1937)world, Landmark.create(owner, id, builder -> LandmarkComponentTypes.forBlock(builder, (class_1936)world, pos)));
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)("Added new " + (owner.equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint "))).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)id.toString())).method_10852((class_2561)class_2561.method_43470((String)"!").method_27692(class_124.field_1060)));
        return 1;
    }

    private static int addIdLandmark(WorldSummary summary, class_3222 player, class_3218 world, Consumer<class_2561> feedback, class_2960 id, class_2338 pos, class_2290 stack, class_2561 name, class_2561 lore, boolean global) throws CommandSyntaxException {
        class_1799 icon = stack.method_9781(1, false);
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (global && !player.method_5687(2)) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"You don't have permission to add that landmark!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (summary.landmarks().contains(global ? WorldLandmarks.GLOBAL : Surveyor.getUuid(player), id)) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"A landmark with this ID already exists! Replacing...").method_27692(class_124.field_1054)));
        }
        summary.landmarks().put((class_1937)world, Landmark.create(global ? WorldLandmarks.GLOBAL : Surveyor.getUuid(player), id, builder -> builder.add(LandmarkComponentTypes.POS, pos).add(LandmarkComponentTypes.STACK, icon).add(LandmarkComponentTypes.NAME, name).add(LandmarkComponentTypes.LORE, List.of(lore))));
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"Added new %s %s!".formatted(global ? "Landmark" : "Waypoint", id)).method_27692(class_124.field_1060)));
        return 1;
    }

    private static int addIdLandmark(MinecraftServer server, @Nullable class_3222 player, @Nullable SurveyorExploration exploration, Consumer<class_2561> feedback, class_3218 world, UUID owner, class_2960 id, class_2338 pos, class_2290 stack, class_2561 name, class_2561 lore) {
        class_1799 icon;
        try {
            icon = stack.method_9781(1, false);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        WorldSummary summary = WorldSummary.of((class_1937)world);
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (!WorldLandmarks.canModify(owner, (class_1937)world, player)) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"You don't have permission to add that landmark!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (summary.landmarks().contains(owner, id)) {
            feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"A landmark with this ID already exists! Replacing...").method_27692(class_124.field_1054)));
        }
        summary.landmarks().put((class_1937)world, Landmark.create(owner, id, builder -> builder.add(LandmarkComponentTypes.POS, pos).add(LandmarkComponentTypes.STACK, icon).add(LandmarkComponentTypes.NAME, name).add(LandmarkComponentTypes.LORE, lore == null ? null : List.of(lore))));
        feedback.accept((class_2561)SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)("Added new " + (owner.equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint "))).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)id.toString())).method_10852((class_2561)class_2561.method_43470((String)"!").method_27692(class_124.field_1060)));
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestLandmarks(CommandContext<class_2168> c, SuggestionsBuilder b, boolean global) {
        class_3218 world;
        class_3222 player = ((class_2168)c.getSource()).method_44023();
        if (player == null) {
            return b.buildFuture();
        }
        boolean op = player.method_5687(2);
        SurveyorExploration exploration = op ? null : (Surveyor.CONFIG.networking.waypoints.atLeast(NetworkMode.GROUP) ? SurveyorExploration.ofShared(player) : SurveyorExploration.of(player));
        try {
            world = class_2181.method_9289(c, (String)"dim");
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        WorldLandmarks landmarks = WorldSummary.of((class_1937)world).landmarks();
        if (landmarks == null) {
            return b.buildFuture();
        }
        return class_2172.method_9270(global ? landmarks.asMap(WorldLandmarks.GLOBAL, exploration).keySet() : landmarks.asMap(exploration).values().stream().flatMap(m -> m.keySet().stream()).toList(), (SuggestionsBuilder)b);
    }

    private static CompletableFuture<Suggestions> suggestOwners(CommandContext<class_2168> c, SuggestionsBuilder b) {
        class_2960 id;
        class_3218 world;
        class_3222 player = ((class_2168)c.getSource()).method_44023();
        if (player == null) {
            return b.buildFuture();
        }
        boolean op = player.method_5687(2);
        SurveyorExploration exploration = op ? null : (Surveyor.CONFIG.networking.waypoints.atLeast(NetworkMode.GROUP) ? SurveyorExploration.ofShared(player) : SurveyorExploration.of(player));
        try {
            world = class_2181.method_9289(c, (String)"dim");
            id = (class_2960)c.getArgument("id", class_2960.class);
        }
        catch (CommandSyntaxException e2) {
            throw new RuntimeException(e2);
        }
        WorldLandmarks landmarks = WorldSummary.of((class_1937)world).landmarks();
        if (landmarks == null) {
            return b.buildFuture();
        }
        return class_2172.method_9265(landmarks.asMap(exploration).entrySet().stream().filter(e -> ((Map)e.getValue()).containsKey(id)).map(e -> ((UUID)e.getKey()).toString()).toList(), (SuggestionsBuilder)b);
    }

    public static <T> T map(CommandContext<class_2168> context, SurveyorCommandExecutor<T> executor, boolean feedback) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        SurveyorExploration exploration = player == null ? null : SurveyorExploration.of(player);
        try {
            return executor.execute(((class_2168)context.getSource()).method_9211(), player, exploration, t -> ((class_2168)context.getSource()).method_9226(() -> t, false));
        }
        catch (Exception e) {
            if (feedback) {
                ((class_2168)context.getSource()).method_9226(() -> SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"Command failed! Check log for details.").method_27692(class_124.field_1061)), false);
            }
            if (feedback) {
                Surveyor.LOGGER.error("[Surveyor] Error while executing command: {}", (Object)context.getInput(), (Object)e);
            }
            return null;
        }
    }

    public static int execute(CommandContext<class_2168> context, SurveyorCommandExecutor<Integer> executor) {
        return Objects.requireNonNullElse(SurveyorCommands.map(context, executor, true), 0);
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"surveyor").executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, SurveyorCommands::info))).then(Surveyor.CONFIG.networking.globalSharing ? class_2170.method_9247((String)"share").executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, SurveyorCommands::informGlobal)) : class_2170.method_9247((String)"share").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9264(((class_2168)c.getSource()).method_9211().method_3760().method_14571().stream().filter(p -> ((class_2168)c.getSource()).method_44023() != p).map(p -> p.method_7334().getName()), (SuggestionsBuilder)b)).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> SurveyorCommands.share(s, p, e, f, (String)c.getArgument("player", String.class))))))).then(Surveyor.CONFIG.networking.globalSharing ? class_2170.method_9247((String)"unshare").executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, SurveyorCommands::informGlobal)) : class_2170.method_9247((String)"unshare").executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, SurveyorCommands::unshare))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"landmarks").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.DISABLED)).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> SurveyorCommands.getLandmarks(s, p, e, f, true)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"new").requires(c -> c.method_9259(2) && Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(class_2170.method_9247((String)"block").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.addBlockLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), WorldLandmarks.GLOBAL, ((class_2280)c.getArgument("pos", class_2280.class)).method_9704((class_2168)c.getSource()));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            if (p == null) {
                f.accept(SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"missing UUID argument for server console").method_27692(class_124.field_1061)));
                return 0;
            }
            return SurveyorCommands.addBlockLandmark(s, p, e, f, p.method_51469(), WorldLandmarks.GLOBAL, ((class_2280)c.getArgument("pos", class_2280.class)).method_9704((class_2168)c.getSource()));
        }))))).then(class_2170.method_9247((String)"id").then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"icon", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"lore", (ArgumentType)class_2178.method_9281((class_7157)registryAccess)).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.addIdLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), WorldLandmarks.GLOBAL, (class_2960)c.getArgument("id", class_2960.class), ((class_2280)c.getArgument("pos", class_2280.class)).method_9704((class_2168)c.getSource()), class_2287.method_9777((CommandContext)c, (String)"icon"), class_2561.method_30163((String)((String)c.getArgument("name", String.class))), (class_2561)c.getArgument("lore", class_2561.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }))))))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"append").requires(c -> c.method_9259(2))).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<class_2168>)c, b, true)).then(class_2170.method_9247((String)"surveyor:color").then(class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.greedyString()).suggests((c, s) -> class_2172.method_9265((Iterable)class_124.method_540((boolean)true, (boolean)false), (SuggestionsBuilder)s)).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.appendColor(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), WorldLandmarks.GLOBAL, (class_2960)c.getArgument("id", class_2960.class), (String)c.getArgument("color", String.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"trim").requires(c -> c.method_9259(2))).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<class_2168>)c, b, true)).then(class_2170.method_9244((String)"component", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270(LandmarkComponentType.keySet(), (SuggestionsBuilder)b)).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.trimLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), WorldLandmarks.GLOBAL, (class_2960)c.getArgument("id", class_2960.class), (class_2960)c.getArgument("component", class_2960.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))))).then(class_2170.method_9247((String)"view").then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<class_2168>)c, b, true)).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.viewLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), WorldLandmarks.GLOBAL, (class_2960)c.getArgument("id", class_2960.class), false);
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"raw").requires(c -> Surveyor.CONFIG.debugCommands)).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<class_2168>)c, b, true)).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.viewLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), WorldLandmarks.GLOBAL, (class_2960)c.getArgument("id", class_2960.class), true);
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(c -> c.method_9259(2) && Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<class_2168>)c, b, true)).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.removeLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), WorldLandmarks.GLOBAL, (class_2960)c.getArgument("id", class_2960.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"waypoints").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.DISABLED)).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> SurveyorCommands.getLandmarks(s, p, e, f, false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"new").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(class_2170.method_9247((String)"block").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"owner", (ArgumentType)class_5242.method_27643()).suggests(SurveyorCommands::suggestOwners).requires(c -> c.method_9259(2))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.addBlockLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), class_5242.method_27645((CommandContext)c, (String)"owner"), ((class_2280)c.getArgument("pos", class_2280.class)).method_9704((class_2168)c.getSource()));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                if (p == null) {
                    f.accept(SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"missing UUID argument for server console").method_27692(class_124.field_1061)));
                    return 0;
                }
                return SurveyorCommands.addBlockLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), Surveyor.getUuid(p), ((class_2280)c.getArgument("pos", class_2280.class)).method_9704((class_2168)c.getSource()));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            if (p == null) {
                f.accept(SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"missing UUID argument for server console").method_27692(class_124.field_1061)));
                return 0;
            }
            return SurveyorCommands.addBlockLandmark(s, p, e, f, p.method_51469(), Surveyor.getUuid(p), ((class_2280)c.getArgument("pos", class_2280.class)).method_9704((class_2168)c.getSource()));
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"id").then(class_2170.method_9244((String)"uuid", (ArgumentType)class_5242.method_27643()).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"icon", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"lore", (ArgumentType)class_2178.method_9281((class_7157)registryAccess)).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.addIdLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), class_5242.method_27645((CommandContext)c, (String)"uuid"), (class_2960)c.getArgument("id", class_2960.class), ((class_2280)c.getArgument("pos", class_2280.class)).method_9704((class_2168)c.getSource()), class_2287.method_9777((CommandContext)c, (String)"icon"), class_2561.method_30163((String)((String)c.getArgument("name", String.class))), (class_2561)c.getArgument("lore", class_2561.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))))))))).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"icon", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"lore", (ArgumentType)class_2178.method_9281((class_7157)registryAccess)).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                if (p == null) {
                    f.accept(SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"missing UUID argument for server console").method_27692(class_124.field_1061)));
                    return 0;
                }
                return SurveyorCommands.addIdLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), Surveyor.getUuid(p), (class_2960)c.getArgument("id", class_2960.class), ((class_2280)c.getArgument("pos", class_2280.class)).method_9704((class_2168)c.getSource()), class_2287.method_9777((CommandContext)c, (String)"icon"), class_2561.method_30163((String)((String)c.getArgument("name", String.class))), (class_2561)c.getArgument("lore", class_2561.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }))))))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"append").requires(c -> c.method_9259(2))).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<class_2168>)c, b, true)).then(class_2170.method_9247((String)"surveyor:color").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.greedyString()).suggests((c, s) -> class_2172.method_9265((Iterable)class_124.method_540((boolean)true, (boolean)false), (SuggestionsBuilder)s)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"owner", (ArgumentType)class_5242.method_27643()).suggests(SurveyorCommands::suggestOwners).requires(c -> c.method_9259(2))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.appendColor(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), class_5242.method_27645((CommandContext)c, (String)"owner"), (class_2960)c.getArgument("id", class_2960.class), (String)c.getArgument("color", String.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                if (p == null) {
                    f.accept(SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"missing UUID argument for server console").method_27692(class_124.field_1061)));
                    return 0;
                }
                return SurveyorCommands.appendColor(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), Surveyor.getUuid(p), (class_2960)c.getArgument("id", class_2960.class), (String)c.getArgument("color", String.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            if (p == null) {
                f.accept(SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"missing UUID argument for server console").method_27692(class_124.field_1061)));
                return 0;
            }
            return SurveyorCommands.appendColor(s, p, e, f, p.method_51469(), Surveyor.getUuid(p), (class_2960)c.getArgument("id", class_2960.class), (String)c.getArgument("color", String.class));
        }))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"trim").requires(c -> c.method_9259(2))).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<class_2168>)c, b, true)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"component", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270(LandmarkComponentType.keySet(), (SuggestionsBuilder)b)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"owner", (ArgumentType)class_5242.method_27643()).suggests(SurveyorCommands::suggestOwners).requires(c -> c.method_9259(2))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.trimLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), class_5242.method_27645((CommandContext)c, (String)"owner"), (class_2960)c.getArgument("id", class_2960.class), (class_2960)c.getArgument("component", class_2960.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                if (p == null) {
                    f.accept(SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"missing UUID argument for server console").method_27692(class_124.field_1061)));
                    return 0;
                }
                return SurveyorCommands.trimLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), Surveyor.getUuid(p), (class_2960)c.getArgument("id", class_2960.class), (class_2960)c.getArgument("component", class_2960.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            if (p == null) {
                f.accept(SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"missing UUID argument for server console").method_27692(class_124.field_1061)));
                return 0;
            }
            return SurveyorCommands.trimLandmark(s, p, e, f, p.method_51469(), Surveyor.getUuid(p), (class_2960)c.getArgument("id", class_2960.class), (class_2960)c.getArgument("component", class_2960.class));
        })))))).then(class_2170.method_9247((String)"view").then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<class_2168>)c, b, false)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"owner", (ArgumentType)class_5242.method_27643()).suggests(SurveyorCommands::suggestOwners).requires(c -> c.method_9259(2))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.viewLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), class_5242.method_27645((CommandContext)c, (String)"owner"), (class_2960)c.getArgument("id", class_2960.class), false);
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                if (p == null) {
                    f.accept(SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"missing UUID argument for server console").method_27692(class_124.field_1061)));
                    return 0;
                }
                return SurveyorCommands.viewLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), Surveyor.getUuid(p), (class_2960)c.getArgument("id", class_2960.class), false);
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"raw").requires(c -> Surveyor.CONFIG.debugCommands)).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<class_2168>)c, b, true)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"owner", (ArgumentType)class_5242.method_27643()).suggests(SurveyorCommands::suggestOwners).requires(c -> c.method_9259(2))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.viewLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), class_5242.method_27645((CommandContext)c, (String)"owner"), (class_2960)c.getArgument("id", class_2960.class), true);
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                if (p == null) {
                    f.accept(SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"missing UUID argument for server console").method_27692(class_124.field_1061)));
                    return 0;
                }
                return SurveyorCommands.viewLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), Surveyor.getUuid(p), (class_2960)c.getArgument("id", class_2960.class), true);
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<class_2168>)c, b, false)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"owner", (ArgumentType)class_5242.method_27643()).suggests(SurveyorCommands::suggestOwners).requires(c -> c.method_9259(2))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.removeLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), class_5242.method_27645((CommandContext)c, (String)"owner"), (class_2960)c.getArgument("id", class_2960.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, p, e, f) -> {
            try {
                if (p == null) {
                    f.accept(SurveyorCommands.prefix().method_10852((class_2561)class_2561.method_43470((String)"missing UUID argument for server console").method_27692(class_124.field_1061)));
                    return 0;
                }
                return SurveyorCommands.removeLandmark(s, p, e, f, class_2181.method_9289((CommandContext)c, (String)"dim"), Surveyor.getUuid(p), (class_2960)c.getArgument("id", class_2960.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }))))));
    }

    private static /* synthetic */ class_2583 lambda$getLandmarks$13(Integer color, class_3222 player, boolean global, Landmark landmark, class_2561 idText, String command, class_2583 s) {
        return s.method_36139(color == null ? 0xFFFFFF : 0xFFFFFF & color).method_10949(player == null ? null : new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43473().method_10852((class_2561)(global || landmark.owner().equals(Surveyor.getUuid(player)) ? class_2561.method_43473() : class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"owner: ").method_27692(class_124.field_1075)).method_27693(landmark.owner().toString()).method_27693("\n"))).method_10852((class_2561)class_2561.method_43470((String)"id: ").method_27692(class_124.field_1075)).method_10852(idText).method_27693("\n").method_10852(class_2564.method_37112(landmark.toText(), (class_2561)class_2561.method_30163((String)"\n"))).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)command).method_27692(class_124.field_1075)))).method_10958(new class_2558(class_2558.class_2559.field_11750, command));
    }

    public static interface SurveyorCommandExecutor<T> {
        public T execute(MinecraftServer var1, @Nullable class_3222 var2, @Nullable SurveyorExploration var3, Consumer<class_2561> var4);
    }
}

