/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.packet.C2SKnownLandmarksPacket;
import folk.sisby.surveyor.packet.C2SKnownStructuresPacket;
import folk.sisby.surveyor.packet.C2SKnownTerrainPacket;
import folk.sisby.surveyor.packet.C2SPacket;
import folk.sisby.surveyor.packet.S2CGroupAmendedPacket;
import folk.sisby.surveyor.packet.S2CGroupChangedPacket;
import folk.sisby.surveyor.packet.S2CGroupUpdatedPacket;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRequestedPacket;
import folk.sisby.surveyor.util.MapUtil;
import folk.sisby.surveyor.util.RegionPos;
import java.util.BitSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class SurveyorNetworking {
    public static Consumer<C2SPacket> C2S_SENDER = p -> {};

    public static void init() {
        PayloadTypeRegistry.playC2S().register(C2SKnownTerrainPacket.ID, C2SKnownTerrainPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(C2SKnownStructuresPacket.ID, C2SKnownStructuresPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(C2SKnownLandmarksPacket.ID, C2SKnownLandmarksPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(SyncLandmarksAddedPacket.ID, SyncLandmarksAddedPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(SyncLandmarksRemovedPacket.ID, SyncLandmarksRemovedPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(SyncLandmarksRequestedPacket.ID, SyncLandmarksRequestedPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(S2CUpdateRegionPacket.ID, S2CUpdateRegionPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(S2CStructuresAddedPacket.ID, S2CStructuresAddedPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(S2CGroupChangedPacket.ID, S2CGroupChangedPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(S2CGroupAmendedPacket.ID, S2CGroupAmendedPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(S2CGroupUpdatedPacket.ID, S2CGroupUpdatedPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(SyncLandmarksAddedPacket.ID, SyncLandmarksAddedPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(SyncLandmarksRemovedPacket.ID, SyncLandmarksRemovedPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(SyncLandmarksRequestedPacket.ID, SyncLandmarksRequestedPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(C2SKnownTerrainPacket.ID, (packet, context) -> SurveyorNetworking.handleServer(packet, context, SurveyorNetworking::handleKnownTerrain));
        ServerPlayNetworking.registerGlobalReceiver(C2SKnownStructuresPacket.ID, (packet, context) -> SurveyorNetworking.handleServer(packet, context, SurveyorNetworking::handleKnownStructures));
        ServerPlayNetworking.registerGlobalReceiver(C2SKnownLandmarksPacket.ID, (packet, context) -> SurveyorNetworking.handleServer(packet, context, SurveyorNetworking::handleKnownLandmarks));
        ServerPlayNetworking.registerGlobalReceiver(SyncLandmarksAddedPacket.ID, (packet, context) -> SurveyorNetworking.handleServer(packet, context, SurveyorNetworking::handleLandmarksAdded));
        ServerPlayNetworking.registerGlobalReceiver(SyncLandmarksRemovedPacket.ID, (packet, context) -> SurveyorNetworking.handleServer(packet, context, SurveyorNetworking::handleLandmarksRemoved));
        ServerPlayNetworking.registerGlobalReceiver(SyncLandmarksRequestedPacket.ID, (packet, context) -> SurveyorNetworking.handleServer(packet, context, SurveyorNetworking::handleLandmarksRequested));
    }

    private static void handleKnownTerrain(class_3222 player, class_3218 world, WorldSummary summary, C2SKnownTerrainPacket packet) {
        if (summary.terrain() == null || Surveyor.CONFIG.networking.terrain.atMost(NetworkMode.NONE)) {
            return;
        }
        Map<RegionPos, BitSet> serverBits = summary.terrain().bitSet(Surveyor.explorationForMode(Surveyor.CONFIG.networking.terrain, player));
        Map<RegionPos, BitSet> clientBits = packet.regionBits();
        int regions = 0;
        int chunks = 0;
        for (RegionPos rPos : serverBits.keySet()) {
            BitSet set = serverBits.get(rPos);
            if (clientBits.containsKey(rPos)) {
                set.andNot(clientBits.get(rPos));
            }
            if (set.isEmpty()) continue;
            ++regions;
            chunks += set.cardinality();
            summary.terrain().queueUpdate(world, rPos, set, player);
        }
        if (regions > 0) {
            Surveyor.LOGGER.info("[Surveyor] Syncing {} missing chunks over {} regions to player {}.", new Object[]{chunks, regions, player.method_7334().getName()});
        }
    }

    private static void handleKnownStructures(class_3222 player, class_3218 world, WorldSummary summary, C2SKnownStructuresPacket packet) {
        if (summary.structures() == null || Surveyor.CONFIG.networking.structures.atMost(NetworkMode.NONE)) {
            return;
        }
        Multimap<class_5321<class_3195>, class_1923> structures = summary.structures().keySet(Surveyor.explorationForMode(Surveyor.CONFIG.networking.structures, player));
        packet.structureKeys().forEach((arg_0, arg_1) -> structures.remove(arg_0, arg_1));
        if (structures.isEmpty()) {
            return;
        }
        SurveyorExploration personalExploration = SurveyorExploration.of(player);
        Multimap<class_5321<class_3195>, class_1923> personalStructures = personalExploration.limitStructureKeySet((class_5321<class_1937>)world.method_27983(), (Multimap<class_5321<class_3195>, class_1923>)HashMultimap.create(structures));
        if (!personalStructures.isEmpty()) {
            S2CStructuresAddedPacket.of(false, personalStructures, summary.structures()).send(player);
        }
        personalStructures.forEach((arg_0, arg_1) -> structures.remove(arg_0, arg_1));
        if (!structures.isEmpty()) {
            S2CStructuresAddedPacket.of(true, structures, summary.structures()).send(player);
        }
        if (!personalStructures.isEmpty() || !structures.isEmpty()) {
            Surveyor.LOGGER.info("[Surveyor] Syncing {} personal and {} shared structures to player {}", new Object[]{personalStructures.size(), structures.size(), player.method_7334().getName()});
        }
    }

    private static void handleKnownLandmarks(class_3222 player, class_3218 world, WorldSummary summary, C2SKnownLandmarksPacket packet) {
        if (summary.landmarks() == null || Surveyor.CONFIG.networking.landmarks.atMost(NetworkMode.NONE)) {
            return;
        }
        UUID uuid = Surveyor.getUuid(player);
        Multimap<UUID, class_2960> landmarks = summary.landmarks().keySet(Surveyor.explorationForMode(Surveyor.CONFIG.networking.landmarks, player));
        HashMultimap addLandmarks = HashMultimap.create(landmarks);
        if (!Surveyor.CONFIG.forceUpdateLandmarks) {
            packet.landmarks().forEach((arg_0, arg_1) -> ((Multimap)addLandmarks).remove(arg_0, arg_1));
        }
        if (!addLandmarks.isEmpty()) {
            SyncLandmarksAddedPacket.of((Multimap<UUID, class_2960>)addLandmarks, summary.landmarks()).send(player);
        }
        HashMultimap removeLandmarks = HashMultimap.create(packet.landmarks());
        Multimap<UUID, class_2960> removedLandmarks = summary.landmarks().removed();
        removeLandmarks.entries().removeIf(e -> !removedLandmarks.containsEntry(e.getKey(), e.getValue()) && (landmarks.containsEntry(e.getKey(), e.getValue()) || ((UUID)e.getKey()).equals(WorldLandmarks.GLOBAL) || ((UUID)e.getKey()).equals(uuid)));
        if (!removeLandmarks.isEmpty()) {
            new SyncLandmarksRemovedPacket((Multimap<UUID, class_2960>)removeLandmarks).send(player);
        }
        HashMultimap unknownWaypoints = HashMultimap.create();
        unknownWaypoints.putAll((Object)uuid, (Iterable)packet.landmarks().get((Object)uuid));
        summary.landmarks().keySet(null).get((Object)uuid).forEach(arg_0 -> SurveyorNetworking.lambda$handleKnownLandmarks$8((Multimap)unknownWaypoints, uuid, arg_0));
        removedLandmarks.get((Object)uuid).forEach(arg_0 -> SurveyorNetworking.lambda$handleKnownLandmarks$9((Multimap)unknownWaypoints, uuid, arg_0));
        if (!unknownWaypoints.isEmpty()) {
            new SyncLandmarksRequestedPacket((Multimap<UUID, class_2960>)unknownWaypoints).send(player);
        }
        if (!(addLandmarks.isEmpty() && removeLandmarks.isEmpty() && unknownWaypoints.isEmpty())) {
            Surveyor.LOGGER.info("[Surveyor] Syncing {} landmarks and {} removals and {} unknowns from player {}", new Object[]{addLandmarks.size(), removeLandmarks.size(), unknownWaypoints.size(), player.method_7334().getName()});
        }
    }

    private static void handleLandmarksAdded(class_3222 player, class_3218 world, WorldSummary summary, SyncLandmarksAddedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        Multimap<UUID, class_2960> keys = MapUtil.keyMultiMap(summary.landmarks().readUpdatePacket((class_1937)world, packet, player));
        if (!keys.isEmpty()) {
            Surveyor.LOGGER.info("[Surveyor] Adding landmark(s) from player {} - {}", (Object)player.method_7334().getName(), (Object)keys.values().stream().map(class_2960::toString).collect(Collectors.joining(", ")));
        }
    }

    private static void handleLandmarksRemoved(class_3222 player, class_3218 world, WorldSummary summary, SyncLandmarksRemovedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        Map<UUID, Map<class_2960, Landmark>> changed = summary.landmarks().readUpdatePacket((class_1937)world, packet, player);
        if (!changed.isEmpty()) {
            summary.landmarks().handleChanged((class_1937)world, changed, false, player);
            Multimap<UUID, class_2960> keys = MapUtil.keyMultiMap(changed);
            Surveyor.LOGGER.info("[Surveyor] Removing landmark(s) for player {} - {}", (Object)player.method_7334().getName(), (Object)keys.values().stream().map(class_2960::toString).collect(Collectors.joining(", ")));
        }
    }

    private static void handleLandmarksRequested(class_3222 player, class_3218 world, WorldSummary summary, SyncLandmarksRequestedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        Multimap<UUID, class_2960> allowed = SurveyorExploration.ofShared(player).limitLandmarkKeySet((class_5321<class_1937>)world.method_27983(), summary.landmarks(), (Multimap<UUID, class_2960>)HashMultimap.create(packet.landmarks()));
        if (!allowed.isEmpty()) {
            summary.landmarks().createUpdatePacket(allowed).send(player);
            Surveyor.LOGGER.info("[Surveyor] Sending requested landmark(s) to player {} - {}", (Object)player.method_7334().getName(), (Object)allowed.values().stream().map(class_2960::toString).collect(Collectors.joining(", ")));
        }
    }

    private static <T extends C2SPacket> void handleServer(T packet, ServerPlayNetworking.Context context, ServerPacketHandler<T> handler) {
        handler.handle(context.player(), context.player().method_51469(), WorldSummary.of((class_1937)context.player().method_51469()), packet);
    }

    private static /* synthetic */ void lambda$handleKnownLandmarks$9(Multimap unknownWaypoints, UUID uuid, class_2960 id) {
        unknownWaypoints.remove((Object)uuid, (Object)id);
    }

    private static /* synthetic */ void lambda$handleKnownLandmarks$8(Multimap unknownWaypoints, UUID uuid, class_2960 id) {
        unknownWaypoints.remove((Object)uuid, (Object)id);
    }

    public static interface ServerPacketHandler<T> {
        public void handle(class_3222 var1, class_3218 var2, WorldSummary var3, T var4);
    }
}

