/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.landmark;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.component.LandmarkComponentTypes;
import folk.sisby.surveyor.packet.C2SKnownLandmarksPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.util.DispatchMapCodec;
import folk.sisby.surveyor.util.MapUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_8824;
import net.minecraft.class_8911;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class WorldLandmarks {
    public static final UUID GLOBAL = UUID.fromString("99999999-9999-9999-9999-999999999999");
    public static final String KEY_LANDMARKS = "landmarks";
    public static final String KEY_REMOVED = "removed";
    public static final Codec<Map<UUID, Map<class_2960, Landmark>>> CODEC = DispatchMapCodec.of(class_4844.field_41525, uuid -> DispatchMapCodec.of(class_2960.field_25139, id -> Landmark.createCodec(uuid, id)));
    public static final Codec<Multimap<UUID, class_2960>> REMOVED_CODEC = Codec.unboundedMap((Codec)class_4844.field_41525, (Codec)Codec.list((Codec)class_2960.field_25139)).xmap(MapUtil::asMultiMap, MapUtil::asListMap);
    public static final int[] XAERO_COLORS = new int[]{-16777216, -16777046, -16733696, -16733526, -5636096, -5635926, -22016, -5592406, -11184811, -11184641, -11141291, -11141121, -65536, -43521, -171, -1};
    protected final class_5321<class_1937> worldKey;
    protected final Map<UUID, Map<class_2960, Landmark>> landmarks = new ConcurrentHashMap<UUID, Map<class_2960, Landmark>>();
    @Nullable
    protected final Multimap<UUID, class_2960> removed;
    protected boolean dirty;

    public WorldLandmarks(class_5321<class_1937> worldKey, Map<UUID, Map<class_2960, Landmark>> landmarks, Multimap<UUID, class_2960> removed, boolean dirty) {
        this.worldKey = worldKey;
        this.landmarks.putAll(landmarks);
        Multimap<UUID, class_2960> multimap = this.removed = removed == null ? null : Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create(removed));
        if (this.removed != null) {
            this.landmarks.forEach((uuid, map) -> map.keySet().forEach(id -> removed.remove(uuid, id)));
        }
        this.dirty = dirty;
    }

    public static WorldLandmarks load(class_1937 world, File folder, boolean isClient) {
        class_2487 landmarkNbt = new class_2487();
        File landmarksFile = new File(folder, "landmarks.dat");
        if (landmarksFile.exists()) {
            try {
                landmarkNbt = class_2507.method_30613((Path)landmarksFile.toPath(), (class_2505)class_2505.method_53898());
            }
            catch (IOException | class_8911 e) {
                Surveyor.LOGGER.error("[Surveyor] Error loading landmarks file for {}.", (Object)world.method_27983().method_29177(), (Object)e);
            }
        }
        WorldLandmarks worldLandmarks = WorldLandmarks.fromNbt(world, landmarkNbt, landmarksFile, isClient);
        if (!isClient) {
            worldLandmarks.tryMigrateXaeros(world, false);
        }
        return worldLandmarks;
    }

    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10566(KEY_LANDMARKS, (class_2520)CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.landmarks).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).orElseThrow());
        if (this.removed != null) {
            nbt.method_10566(KEY_REMOVED, (class_2520)REMOVED_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.removed).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).orElseThrow());
        }
        return nbt;
    }

    public static WorldLandmarks fromNbt(class_1937 world, class_2487 nbt, File landmarksFile, boolean isClient) {
        class_2487 landmarks = nbt.method_10562(KEY_LANDMARKS);
        boolean dirty = false;
        HashMap<UUID, Map<class_2960, Landmark>> outMap = new HashMap<UUID, Map<class_2960, Landmark>>();
        Multimap removedMap = null;
        if (landmarks.method_10541().stream().anyMatch(k -> k.contains(":"))) {
            Surveyor.LOGGER.warn("[Surveyor] Partially recovering landmarks from 0.X");
            try {
                Files.copy(landmarksFile.toPath(), landmarksFile.toPath().resolveSibling("landmarks.dat_v0"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException("Surveyor failed to back up v0 landmarks, was the file locked?", e);
            }
            try {
                for (String key : landmarks.method_10541()) {
                    class_2487 type = landmarks.method_10562(key);
                    class_2960 typeId = class_2960.method_12829((String)key);
                    for (String coords : type.method_10541()) {
                        class_2487 landmark = type.method_10562(coords);
                        UUID owner = landmark.method_10545("owner") ? (UUID)((Pair)class_4844.field_40825.decode((DynamicOps)class_2509.field_11560, (Object)landmark.method_10580("owner")).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).orElseThrow()).getFirst() : GLOBAL;
                        class_2338 pos = new class_2338(Integer.parseInt(coords.split(",")[0]), Integer.parseInt(coords.split(",")[1]), Integer.parseInt(coords.split(",")[2]));
                        class_1767 dye = !landmark.method_10545("color") ? null : (class_1767)class_1767.field_41600.decode((DynamicOps)class_2509.field_11560, (Object)landmark.method_10580("color")).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).map(Pair::getFirst).orElse(null);
                        class_2960 id = (landmark.method_10545("texture") ? class_2960.method_12829((String)landmark.method_10558("texture")) : typeId).method_48331((String)(dye == null ? "" : "/" + dye.method_7792()) + "/" + pos.method_10263() + (String)(pos.method_10264() == 0 ? "" : "/" + pos.method_10264()) + "/" + pos.method_10260());
                        outMap.computeIfAbsent(owner, u -> new HashMap()).put(id, Landmark.create(owner, id, b -> b.add(LandmarkComponentTypes.POS, pos).add(LandmarkComponentTypes.BOX, !landmark.method_10545("box") ? null : (class_3341)class_3341.field_29325.decode((DynamicOps)class_2509.field_11560, (Object)landmark.method_10580("box")).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).map(Pair::getFirst).orElse(null)).add(LandmarkComponentTypes.COLOR, dye == null ? null : Integer.valueOf(dye.method_7790())).add(LandmarkComponentTypes.NAME, !landmark.method_10545("name") ? null : (class_2561)class_8824.field_46597.decode((DynamicOps)class_2509.field_11560, (Object)landmark.method_10580("name")).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).map(Pair::getFirst).orElse(null)).add(LandmarkComponentTypes.SEED, !landmark.method_10545("seed") ? null : Integer.valueOf(landmark.method_10550("seed"))).add(LandmarkComponentTypes.TIME, !landmark.method_10545("created") ? null : Long.valueOf(landmark.method_10537("created")))));
                        dirty = true;
                    }
                }
                Surveyor.LOGGER.info("[Surveyor] Recovered {} landmarks from legacy data.", (Object)outMap.values().stream().mapToInt(Map::size).sum());
            }
            catch (Exception e) {
                Surveyor.LOGGER.error("[Surveyor] Encountered an error during v0 landmark migration, skipping...", (Throwable)e);
            }
        } else {
            class_2487 removed;
            if (!landmarks.method_33133()) {
                ((Map)((Pair)CODEC.decode((DynamicOps)class_2509.field_11560, (Object)landmarks).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).orElseThrow()).getFirst()).forEach((uuid, map) -> map.forEach((id, landmark) -> outMap.computeIfAbsent((UUID)uuid, u -> new HashMap()).put(id, landmark)));
            }
            if (!isClient && !(removed = nbt.method_10562(KEY_REMOVED)).method_33133()) {
                removedMap = (Multimap)((Pair)REMOVED_CODEC.decode((DynamicOps)class_2509.field_11560, (Object)removed).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).orElseThrow()).getFirst();
            }
        }
        return new WorldLandmarks((class_5321<class_1937>)world.method_27983(), outMap, removedMap, dirty);
    }

    public boolean contains(UUID uuid, class_2960 id) {
        return this.landmarks.containsKey(uuid) && this.landmarks.get(uuid).containsKey(id);
    }

    @Nullable
    public Landmark get(UUID uuid, class_2960 id) {
        return this.contains(uuid, id) ? this.landmarks.get(uuid).get(id) : null;
    }

    public <T extends Landmark> Map<class_2960, T> asMap(UUID uuid, SurveyorExploration exploration) {
        HashMap outMap = new HashMap();
        if (this.landmarks.containsKey(uuid)) {
            this.landmarks.get(uuid).forEach((id, landmark) -> {
                if (exploration == null || exploration.exploredLandmark(this.worldKey, (Landmark)landmark)) {
                    outMap.put(id, landmark);
                }
            });
        }
        return outMap;
    }

    public Map<UUID, Map<class_2960, Landmark>> asMap(SurveyorExploration exploration) {
        HashMap<UUID, Map<class_2960, Landmark>> outmap = new HashMap<UUID, Map<class_2960, Landmark>>();
        this.landmarks.forEach((uuid, map) -> map.forEach((id, landmark) -> {
            if (exploration == null || exploration.exploredLandmark(this.worldKey, (Landmark)landmark)) {
                outmap.computeIfAbsent((UUID)uuid, t -> new HashMap()).put(id, landmark);
            }
        }));
        return outmap;
    }

    public Multimap<UUID, class_2960> keySet(SurveyorExploration exploration) {
        HashMultimap outMap = HashMultimap.create();
        this.landmarks.forEach((arg_0, arg_1) -> this.lambda$keySet$15(exploration, (Multimap)outMap, arg_0, arg_1));
        return outMap;
    }

    public Multimap<UUID, class_2960> removed() {
        HashMultimap outMap = HashMultimap.create();
        if (this.removed != null) {
            outMap.putAll(this.removed);
        }
        return outMap;
    }

    public void handleChanged(class_1937 world, Map<UUID, Map<class_2960, Landmark>> changed, boolean local, @Nullable class_3222 sender) {
        if (changed.isEmpty()) {
            return;
        }
        HashMap<UUID, Map<class_2960, Landmark>> landmarksAddedChanged = new HashMap<UUID, Map<class_2960, Landmark>>();
        HashMap<UUID, Map> landmarksRemoved = new HashMap<UUID, Map>();
        changed.forEach((uuid, map) -> map.forEach((id, landmark) -> {
            if (this.contains((UUID)uuid, (class_2960)id)) {
                landmarksAddedChanged.computeIfAbsent((UUID)uuid, t -> new HashMap()).put(id, landmark);
            } else {
                landmarksRemoved.computeIfAbsent((UUID)uuid, t -> new HashMap()).put(id, landmark);
            }
        }));
        if (!landmarksRemoved.isEmpty()) {
            SurveyorEvents.Invoke.landmarksRemoved(world, MapUtil.keyMultiMap(landmarksRemoved));
        }
        if (!landmarksAddedChanged.isEmpty()) {
            SurveyorEvents.Invoke.landmarksAdded(world, MapUtil.keyMultiMap(landmarksAddedChanged));
        }
        if (!local) {
            HashMap<UUID, Map> waypointsRemoved = new HashMap<UUID, Map>();
            HashMap<UUID, Map<class_2960, Landmark>> waypointsAddedChanged = new HashMap<UUID, Map<class_2960, Landmark>>();
            landmarksRemoved.forEach((uuid, map) -> map.forEach((id, landmark) -> {
                if (!landmark.owner().equals(GLOBAL)) {
                    waypointsRemoved.computeIfAbsent((UUID)uuid, t -> new HashMap()).put(id, landmark);
                }
            }));
            waypointsRemoved.forEach((uuid, map) -> map.forEach((id, landmark) -> {
                ((Map)landmarksRemoved.get(uuid)).remove(id);
                if (((Map)landmarksRemoved.get(uuid)).isEmpty()) {
                    landmarksRemoved.remove(uuid);
                }
            }));
            landmarksAddedChanged.forEach((uuid, map) -> map.forEach((id, landmark) -> {
                if (!landmark.owner().equals(GLOBAL)) {
                    waypointsAddedChanged.computeIfAbsent((UUID)uuid, t -> new HashMap()).put(id, landmark);
                }
            }));
            waypointsAddedChanged.forEach((uuid, map) -> map.forEach((id, landmark) -> {
                ((Map)landmarksAddedChanged.get(uuid)).remove(id);
                if (((Map)landmarksAddedChanged.get(uuid)).isEmpty()) {
                    landmarksAddedChanged.remove(uuid);
                }
            }));
            if (!landmarksRemoved.isEmpty()) {
                new SyncLandmarksRemovedPacket(MapUtil.keyMultiMap(landmarksRemoved)).send(sender, world, Surveyor.CONFIG.networking.landmarks);
            }
            if (!landmarksAddedChanged.isEmpty()) {
                new SyncLandmarksAddedPacket(landmarksAddedChanged).send(sender, world, Surveyor.CONFIG.networking.landmarks);
            }
            if (!waypointsRemoved.isEmpty()) {
                new SyncLandmarksRemovedPacket(MapUtil.keyMultiMap(waypointsRemoved)).send(sender, world, Surveyor.CONFIG.networking.waypoints);
            }
            if (!waypointsAddedChanged.isEmpty()) {
                new SyncLandmarksAddedPacket(waypointsAddedChanged).send(sender, world, Surveyor.CONFIG.networking.waypoints);
            }
        }
    }

    public Map<UUID, Map<class_2960, Landmark>> putForBatch(Map<UUID, Map<class_2960, Landmark>> changed, Landmark landmark) {
        if (Surveyor.CONFIG.landmarks == SystemMode.FROZEN) {
            return changed;
        }
        this.landmarks.computeIfAbsent(landmark.owner(), t -> new ConcurrentHashMap()).put(landmark.id(), landmark);
        if (this.removed != null) {
            this.removed.remove((Object)landmark.owner(), (Object)landmark.id());
        }
        this.dirty();
        changed.computeIfAbsent(landmark.owner(), t -> new HashMap()).put(landmark.id(), landmark);
        return changed;
    }

    public void putLocal(class_1937 world, Landmark landmark) {
        this.handleChanged(world, this.putForBatch(new HashMap<UUID, Map<class_2960, Landmark>>(), landmark), true, null);
    }

    public void put(class_1937 world, Landmark landmark) {
        this.handleChanged(world, this.putForBatch(new HashMap<UUID, Map<class_2960, Landmark>>(), landmark), false, null);
    }

    public void put(class_3222 sender, class_3218 world, Landmark landmark) {
        this.handleChanged((class_1937)world, this.putForBatch(new HashMap<UUID, Map<class_2960, Landmark>>(), landmark), false, sender);
    }

    public Map<UUID, Map<class_2960, Landmark>> removeForBatch(Map<UUID, Map<class_2960, Landmark>> changed, UUID uuid, class_2960 id) {
        if (Surveyor.CONFIG.landmarks == SystemMode.FROZEN) {
            return changed;
        }
        if (!this.landmarks.containsKey(uuid) || !this.landmarks.get(uuid).containsKey(id)) {
            return changed;
        }
        Landmark landmark = this.landmarks.get(uuid).remove(id);
        if (this.removed != null) {
            this.removed.put((Object)uuid, (Object)id);
        }
        if (this.landmarks.get(uuid).isEmpty()) {
            this.landmarks.remove(uuid);
        }
        this.dirty();
        changed.computeIfAbsent(uuid, t -> new HashMap()).put(id, landmark);
        return changed;
    }

    public void removeLocal(class_1937 world, UUID uuid, class_2960 id) {
        this.handleChanged(world, this.removeForBatch(new HashMap<UUID, Map<class_2960, Landmark>>(), uuid, id), true, null);
    }

    public void remove(class_1937 world, UUID uuid, class_2960 id) {
        this.handleChanged(world, this.removeForBatch(new HashMap<UUID, Map<class_2960, Landmark>>(), uuid, id), false, null);
    }

    public void remove(class_3222 sender, class_3218 world, UUID uuid, class_2960 id) {
        this.handleChanged((class_1937)world, this.removeForBatch(new HashMap<UUID, Map<class_2960, Landmark>>(), uuid, id), false, sender);
    }

    public Map<UUID, Map<class_2960, Landmark>> removeAllForBatch(Map<UUID, Map<class_2960, Landmark>> changed, Predicate<Landmark> predicate) {
        if (Surveyor.CONFIG.landmarks == SystemMode.FROZEN) {
            return null;
        }
        HashMultimap toRemove = HashMultimap.create();
        this.landmarks.forEach((arg_0, arg_1) -> WorldLandmarks.lambda$removeAllForBatch$34(predicate, (Multimap)toRemove, arg_0, arg_1));
        toRemove.forEach((uuid, id) -> this.removeForBatch(changed, (UUID)uuid, (class_2960)id));
        return changed;
    }

    public void removeAll(class_1937 world, Predicate<Landmark> predicate) {
        this.handleChanged(world, this.removeAllForBatch(new HashMap<UUID, Map<class_2960, Landmark>>(), predicate), false, null);
    }

    public int save(class_1937 world, File folder) {
        if (this.isDirty()) {
            File landmarksFile = new File(folder, "landmarks.dat");
            class_2487 landmarksCompound = this.writeNbt(new class_2487());
            class_156.method_27958().execute(() -> {
                try {
                    class_2507.method_30614((class_2487)landmarksCompound, (Path)landmarksFile.toPath());
                }
                catch (IOException e) {
                    Surveyor.LOGGER.error("[Surveyor] Error writing landmarks file for {}.", (Object)world.method_27983().method_29177(), (Object)e);
                }
            });
            this.dirty = false;
            return this.landmarks.values().stream().mapToInt(Map::size).sum();
        }
        return 0;
    }

    public static boolean canModify(UUID landmark, class_1937 world, @Nullable class_3222 player) {
        if (world.method_8608()) {
            return landmark.equals(SurveyorClient.getClientUuid()) || Surveyor.CONFIG.networking.waypoints.atLeast(NetworkMode.GROUP) && SurveyorClient.getSharedExploration().groupPlayers().contains(landmark);
        }
        return player == null || player.method_5687(2) || landmark.equals(Surveyor.getUuid(player)) || ServerSummary.of(world.method_8503()).getGroup(Surveyor.getUuid(player)).contains(landmark);
    }

    public Map<UUID, Map<class_2960, Landmark>> readUpdatePacket(class_1937 world, SyncLandmarksAddedPacket packet, @Nullable class_3222 sender) {
        HashMap<UUID, Map<class_2960, Landmark>> changed = new HashMap<UUID, Map<class_2960, Landmark>>();
        packet.landmarks().forEach((uuid, map) -> map.forEach((id, landmark) -> {
            boolean waypoint;
            boolean bl = waypoint = !landmark.owner().equals(GLOBAL);
            if (sender == null || WorldLandmarks.canModify(landmark.owner(), world, sender) && (waypoint && Surveyor.CONFIG.networking.waypoints.atLeast(NetworkMode.SOLO) || !waypoint && Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.SOLO))) {
                this.putForBatch(changed, (Landmark)landmark);
            }
        }));
        if (!changed.isEmpty()) {
            this.handleChanged(world, changed, sender == null, sender);
        }
        return changed;
    }

    public Map<UUID, Map<class_2960, Landmark>> readUpdatePacket(class_1937 world, SyncLandmarksRemovedPacket packet, @Nullable class_3222 sender) {
        HashMap<UUID, Map<class_2960, Landmark>> changed = new HashMap<UUID, Map<class_2960, Landmark>>();
        packet.landmarks().forEach((uuid, id) -> {
            boolean waypoint;
            Landmark landmark = this.get((UUID)uuid, (class_2960)id);
            if (landmark == null) {
                return;
            }
            boolean bl = waypoint = !landmark.owner().equals(GLOBAL);
            if (sender == null || WorldLandmarks.canModify(landmark.owner(), world, sender) && (waypoint && Surveyor.CONFIG.networking.waypoints.atLeast(NetworkMode.SOLO) || !waypoint && Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.SOLO))) {
                this.removeForBatch((Map<UUID, Map<class_2960, Landmark>>)changed, (UUID)uuid, (class_2960)id);
            }
        });
        if (!changed.isEmpty()) {
            this.handleChanged(world, changed, sender == null, sender);
        }
        return changed;
    }

    public SyncLandmarksAddedPacket createUpdatePacket(Multimap<UUID, class_2960> keySet) {
        HashMap<UUID, Map<class_2960, Landmark>> landmarks = new HashMap<UUID, Map<class_2960, Landmark>>();
        keySet.forEach((uuid, id) -> landmarks.computeIfAbsent((UUID)uuid, k -> new HashMap()).put(id, this.get((UUID)uuid, (class_2960)id)));
        return new SyncLandmarksAddedPacket(landmarks);
    }

    public boolean isDirty() {
        return this.dirty && Surveyor.CONFIG.landmarks != SystemMode.FROZEN;
    }

    private void dirty() {
        this.dirty = true;
    }

    private void tryMigrateXaeros(class_1937 world, boolean handleChanged) {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        File saveFolder = SurveyorClient.getXaerosSavePath(world);
        if (saveFolder != null) {
            HashMap<UUID, Map<class_2960, Landmark>> changed = new HashMap<UUID, Map<class_2960, Landmark>>();
            Surveyor.LOGGER.info("[Surveyor] Attempting to parse xaero's waypoints from {}/{}", (Object)saveFolder.getParentFile().getName(), (Object)saveFolder.getName());
            try {
                Files.createFile(saveFolder.toPath().resolve(".surveyor_migrated"), new FileAttribute[0]);
                for (File file : Objects.requireNonNullElse(saveFolder.listFiles(f -> f.getName().endsWith(".txt")), new File[0])) {
                    for (String line : Files.readAllLines(file.toPath())) {
                        try {
                            if (!line.startsWith("waypoint:")) continue;
                            String[] split = line.split(":");
                            class_2338 pos = new class_2338(Integer.parseInt(split[3]), split[4].equals("~") ? 0 : Integer.parseInt(split[4]), Integer.parseInt(split[5]));
                            class_2960 id = class_2960.method_60655((String)"xaeros", (String)"waypoint/%d/%d/%d".formatted(pos.method_10263(), pos.method_10264(), pos.method_10260()));
                            this.putForBatch(changed, Landmark.create(SurveyorClient.getClientUuid(), id, b -> b.add(LandmarkComponentTypes.POS, pos).add(LandmarkComponentTypes.COLOR, XAERO_COLORS[Integer.parseInt(split[6])]).add(LandmarkComponentTypes.NAME, class_2561.method_43470((String)split[1]))));
                            this.dirty = true;
                        }
                        catch (Exception e) {
                            Surveyor.LOGGER.error("[Surveyor] Error parsing xaeros waypoint: {}", (Object)line, (Object)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                Surveyor.LOGGER.error("[Surveyor] Error parsing xaeros data from {}", (Object)saveFolder, (Object)e);
            }
            Surveyor.LOGGER.info("[Surveyor] Migrated {} waypoints from xaeros data.", (Object)changed.values().stream().mapToInt(Map::size).sum());
            if (handleChanged) {
                this.handleChanged(world, changed, Surveyor.CONFIG.networking.landmarks.atMost(NetworkMode.SOLO), null);
            }
        }
    }

    public void clientInitialized(class_1937 world) {
        this.tryMigrateXaeros(world, true);
        if (Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.SOLO)) {
            new C2SKnownLandmarksPacket(this.keySet(null)).send();
        }
    }

    private static /* synthetic */ void lambda$removeAllForBatch$34(Predicate predicate, Multimap toRemove, UUID uuid, Map map) {
        map.forEach((id, landmark) -> {
            if (predicate.test(landmark)) {
                toRemove.put((Object)uuid, id);
            }
        });
    }

    private /* synthetic */ void lambda$keySet$15(SurveyorExploration exploration, Multimap outMap, UUID uuid, Map map) {
        map.forEach((id, landmark) -> {
            if (exploration == null || exploration.exploredLandmark(this.worldKey, (Landmark)landmark)) {
                outMap.put((Object)uuid, id);
            }
        });
    }
}

