/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.RegionSummary;
import folk.sisby.surveyor.util.ChunkUtil;
import folk.sisby.surveyor.util.RegionPos;
import folk.sisby.surveyor.util.RegistryPalette;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5455;

public class WorldTerrainSummary {
    protected final class_5321<class_1937> worldKey;
    protected final class_5455 registryManager;
    protected final Map<RegionPos, RegionSummary> regions = new ConcurrentHashMap<RegionPos, RegionSummary>();
    protected final File folder;
    protected final Map<RegionPos, Map<UUID, BitSet>> queuedUpdates = new LinkedHashMap<RegionPos, Map<UUID, BitSet>>();

    public WorldTerrainSummary(class_5321<class_1937> worldKey, class_5455 registryManager, Map<RegionPos, RegionSummary> regions, File folder) {
        this.worldKey = worldKey;
        this.registryManager = registryManager;
        this.regions.putAll(regions);
        this.folder = folder;
    }

    public static Set<class_1923> toKeys(Map<RegionPos, BitSet> bitSets) {
        return WorldTerrainSummary.toKeys(bitSets, Comparator.comparingInt(pos -> pos.x() + pos.z()));
    }

    public static Set<class_1923> toKeys(Map<RegionPos, BitSet> bitSets, class_1923 originChunk) {
        class_1923 oPos = new class_1923(RegionPos.chunkToRegion(originChunk.field_9181), RegionPos.chunkToRegion(originChunk.field_9180));
        return WorldTerrainSummary.toKeys(bitSets, Comparator.comparingDouble(pos -> (oPos.field_9181 - pos.x()) * (oPos.field_9181 - pos.x()) + (oPos.field_9180 - pos.z()) * (oPos.field_9180 - pos.z())));
    }

    public static Set<class_1923> toKeys(Map<RegionPos, BitSet> bitSets, Comparator<RegionPos> regionComparator) {
        LinkedHashSet<class_1923> set = new LinkedHashSet<class_1923>();
        bitSets.entrySet().stream().sorted(Map.Entry.comparingByKey(regionComparator)).forEach(e -> ((BitSet)e.getValue()).stream().forEach(i -> set.add(((RegionPos)e.getKey()).toChunk(i))));
        return set;
    }

    public static WorldTerrainSummary load(class_1937 world, File folder) {
        HashMap<RegionPos, RegionSummary> regions = new HashMap<RegionPos, RegionSummary>();
        ChunkUtil.getRegionFiles(folder, "c").forEach((pos, file) -> regions.put((RegionPos)pos, RegionSummary.fromFile(file, world.method_30349(), pos)));
        return new WorldTerrainSummary((class_5321<class_1937>)world.method_27983(), world.method_30349(), regions, folder);
    }

    public static void onChunkLoad(class_1937 world, class_2818 chunk) {
        WorldSummary summary = WorldSummary.of(world);
        if (!(summary.terrain() == null || summary.terrain().contains(chunk.method_12004()) && Surveyor.CONFIG.lazyClientUpdating && ChunkUtil.airCount((class_2791)chunk).equals(summary.terrain().get(chunk.method_12004()).getAirCount()))) {
            summary.terrain().put(world, chunk);
        }
    }

    public static void onChunkUnload(class_1937 world, class_2818 chunk) {
        WorldSummary summary = WorldSummary.of(world);
        if (summary.terrain() != null && chunk.method_12044()) {
            summary.terrain().put(world, chunk);
        }
    }

    public boolean contains(class_1923 pos) {
        RegionPos regionPos = RegionPos.of(pos);
        return this.regions.containsKey(regionPos) && this.regions.get(regionPos).contains(pos);
    }

    public ChunkSummary get(class_1923 pos) {
        RegionPos regionPos = RegionPos.of(pos);
        return this.regions.containsKey(regionPos) ? this.regions.get(regionPos).get(pos) : null;
    }

    public RegionSummary getRegion(RegionPos regionPos) {
        return this.regions.computeIfAbsent(regionPos, k -> RegionSummary.fromEmpty(this.folder, regionPos, this.registryManager));
    }

    public RegistryPalette.ValueView getBiomePalette(class_1923 pos) {
        RegionPos regionPos = RegionPos.of(pos);
        return this.regions.get(regionPos).getBiomePalette();
    }

    public RegistryPalette.ValueView getBlockPalette(class_1923 pos) {
        RegionPos regionPos = RegionPos.of(pos);
        return this.regions.get(regionPos).getBlockPalette();
    }

    public Map<RegionPos, BitSet> bitSet(SurveyorExploration exploration) {
        HashMap<RegionPos, BitSet> map = new HashMap<RegionPos, BitSet>();
        this.regions.forEach((p, r) -> map.put((RegionPos)p, r.bitSet()));
        return exploration == null ? map : exploration.limitTerrainBitset(this.worldKey, map);
    }

    public void put(class_1937 world, class_2818 chunk) {
        if (Surveyor.CONFIG.terrain == SystemMode.FROZEN) {
            return;
        }
        this.regions.computeIfAbsent(RegionPos.of(chunk.method_12004()), k -> RegionSummary.fromEmpty(this.folder, RegionPos.of(chunk.method_12004()), this.registryManager)).putChunk(world, chunk);
        SurveyorEvents.Invoke.terrainUpdated(world, chunk.method_12004());
    }

    public static void onTick(class_3218 world) {
        WorldTerrainSummary summary = WorldSummary.of((class_1937)world).terrain();
        if (summary != null) {
            summary.serverTick(world);
        }
    }

    public void sendUpdateForRegion(class_1937 world, RegionPos rPos, class_3222 player, BitSet set) {
        RegionSummary region = this.getRegion(rPos);
        SurveyorExploration personalExploration = SurveyorExploration.of(player);
        BitSet personalSet = personalExploration.limitTerrainBitset((class_5321<class_1937>)world.method_27983(), rPos, (BitSet)set.clone());
        if (!personalSet.isEmpty()) {
            S2CUpdateRegionPacket.of(false, rPos, region, personalSet).send(player);
        }
        set.andNot(personalSet);
        if (!set.isEmpty()) {
            S2CUpdateRegionPacket.of(true, rPos, region, set).send(player);
        }
    }

    public void serverTick(class_3218 world) {
        if (world.method_8503().method_3780() % Surveyor.CONFIG.networking.terrainTicks != 0) {
            return;
        }
        this.queuedUpdates.keySet().stream().findFirst().ifPresent(rPos -> {
            RegionSummary region = this.getRegion((RegionPos)rPos);
            this.queuedUpdates.get(rPos).forEach((uuid, set) -> {
                class_3222 player = world.method_8503().method_3760().method_14602(uuid);
                if (player != null) {
                    this.sendUpdateForRegion((class_1937)world, (RegionPos)rPos, player, (BitSet)set);
                }
            });
            this.queuedUpdates.remove(rPos);
            if (region.isLoaded() && region.isUnloaded((class_1937)world)) {
                region.save(true);
            }
        });
    }

    public void queueUpdate(class_3218 world, RegionPos rPos, BitSet set, class_3222 player) {
        if (this.getRegion(rPos).isLoaded()) {
            this.sendUpdateForRegion((class_1937)world, rPos, player, set);
        } else {
            this.queuedUpdates.computeIfAbsent(rPos, k -> new LinkedHashMap()).put(player.method_5667(), set);
        }
    }

    public int save(class_1937 world) {
        ArrayList savedRegions = new ArrayList();
        this.regions.forEach((pos, summary) -> {
            if (summary.isLoaded()) {
                if (summary.isDirty()) {
                    savedRegions.add(pos);
                }
                summary.save(summary.isUnloaded(world));
            }
        });
        return savedRegions.size();
    }

    public boolean isDirty() {
        return this.regions.values().stream().anyMatch(RegionSummary::isDirty);
    }
}

