/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.NetworkHandlerSummary;
import folk.sisby.surveyor.client.SurveyorClientCommands;
import folk.sisby.surveyor.client.SurveyorClientEvents;
import folk.sisby.surveyor.client.SurveyorClientNetworking;
import folk.sisby.surveyor.client.SurveyorNetworkHandler;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.packet.C2SKnownStructuresPacket;
import folk.sisby.surveyor.packet.C2SKnownTerrainPacket;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.RegionPos;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1132;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_642;
import net.minecraft.class_8911;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public class SurveyorClient
implements ClientModInitializer {
    public static final String SERVERS_FILE_NAME = "servers.txt";
    private static final Multimap<class_5321<class_1937>, class_2818> LOADING_CHUNKS = HashMultimap.create();

    public static File getSavePath(class_1937 world) {
        String saveFolder = String.valueOf(world.method_22385().field_20641);
        Path savePath = FabricLoader.getInstance().getGameDir().resolve("data").resolve("surveyor").resolve(saveFolder);
        savePath.toFile().mkdirs();
        File serversFile = savePath.resolve(SERVERS_FILE_NAME).toFile();
        try {
            class_642 info = class_310.method_1551().method_1558();
            if (!(info == null || serversFile.exists() && FileUtils.readFileToString((File)serversFile, (Charset)StandardCharsets.UTF_8).contains(info.field_3752 + "\n" + info.field_3761))) {
                FileUtils.writeStringToFile((File)serversFile, (String)(info.field_3752 + "\n" + info.field_3761 + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
            }
        }
        catch (IOException e) {
            Surveyor.LOGGER.error("[Surveyor] Error writing servers file for save {}.", (Object)savePath, (Object)e);
        }
        return savePath.toFile();
    }

    public static File getWorldSavePath(class_1937 world) {
        String dimNamespace = world.method_27983().method_29177().method_12836();
        String dimPath = world.method_27983().method_29177().method_12832();
        return SurveyorClient.getSavePath(world).toPath().resolve(dimNamespace).resolve(dimPath).toFile();
    }

    @Nullable
    public static File getXaerosSavePath(class_1937 world) {
        File baseFolder = FabricLoader.getInstance().getGameDir().resolve("xaero").resolve("minimap").toFile();
        if (!baseFolder.exists()) {
            return null;
        }
        String id = null;
        try {
            id = class_310.method_1551().method_1558() != null ? class_310.method_1551().method_1558().field_3761 : class_310.method_1551().method_1576().method_27050(class_5218.field_24188).getParent().toFile().getName();
            String sanitized = (class_310.method_1551().method_1558() != null ? "Multiplayer_" : "") + (id.contains(":") ? id.substring(0, id.indexOf(":")) : id).replace("_", "%us%").replace("\\", "%bs%").replace("/", "%fs%").replace(":", "\u00a7").replace("[", "%lb%").replace("]", "%rb%");
            File saveFolder = baseFolder.toPath().resolve(sanitized).toFile();
            if (!saveFolder.exists()) {
                return null;
            }
            String sanitizedDim = world.method_27983() == class_1937.field_25179 ? "dim%0" : (world.method_27983() == class_1937.field_25180 ? "dim%-1" : (world.method_27983() == class_1937.field_25181 ? "dim%1" : "dim%" + world.method_27983().toString().replace(":", "$").replace('/', '%')));
            File dimFolder = saveFolder.toPath().resolve(sanitizedDim).toFile();
            if (!dimFolder.exists() || dimFolder.toPath().resolve(".surveyor_migrated").toFile().exists()) {
                return null;
            }
            return dimFolder;
        }
        catch (Exception e) {
            Surveyor.LOGGER.error("[Surveyor] Error fetching xaeros data for {} {}", new Object[]{id, world.method_27983(), e});
            return null;
        }
    }

    public static boolean serverSupported() {
        return ClientPlayNetworking.canSend(C2SKnownTerrainPacket.ID);
    }

    public static Map<UUID, PlayerSummary> getFriends() {
        if (class_310.method_1551().method_1496()) {
            class_1132 server = class_310.method_1551().method_1576();
            return ServerSummary.of((MinecraftServer)server).getGroupSummaries(SurveyorClient.getClientUuid(), (MinecraftServer)server);
        }
        class_634 handler = class_310.method_1551().method_1562();
        if (handler == null) {
            return new HashMap<UUID, PlayerSummary>();
        }
        return NetworkHandlerSummary.of(handler).players(ClientExploration.SHARED.sharedPlayers());
    }

    public static SurveyorExploration getExploration() {
        if (class_310.method_1551().method_1496()) {
            return SurveyorExploration.ofShared(SurveyorClient.getClientUuid(), (MinecraftServer)class_310.method_1551().method_1576());
        }
        HashSet<SurveyorExploration> set = new HashSet<SurveyorExploration>();
        set.add(ClientExploration.INSTANCE);
        set.add(ClientExploration.SHARED);
        return PlayerSummary.OfflinePlayerSummary.OfflinePlayerExploration.ofMerged(set);
    }

    public static SurveyorExploration getPersonalExploration() {
        if (class_310.method_1551().method_1496()) {
            return SurveyorExploration.of(SurveyorClient.getClientUuid(), (MinecraftServer)class_310.method_1551().method_1576());
        }
        return ClientExploration.INSTANCE;
    }

    public static ClientExploration getSharedExploration() {
        if (class_310.method_1551().method_1496()) {
            throw new IllegalStateException("You can't edit shared exploration in singleplayer!");
        }
        return ClientExploration.SHARED;
    }

    public static UUID getClientUuid() {
        if (class_310.method_1551().method_1496()) {
            return ServerSummary.HOST;
        }
        GameProfile profile = ((SurveyorNetworkHandler)class_310.method_1551().method_1562()).getProfile();
        return profile.getId();
    }

    public static class_3218 stealServerWorld(class_5321<class_1937> worldKey) {
        class_1132 integratedServer = class_310.method_1551().method_1576();
        if (integratedServer == null) {
            return null;
        }
        return integratedServer.method_3847(worldKey);
    }

    public void onInitializeClient() {
        SurveyorClientNetworking.init();
        ClientCommandRegistrationCallback.EVENT.register(SurveyorClientCommands::registerCommands);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> client.execute(ClientExploration::onLoad));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            LOADING_CHUNKS.clear();
            ClientExploration.onUnload();
        });
        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (WorldSummary.of((class_1937)world).isClient()) {
                LOADING_CHUNKS.put((Object)world.method_27983(), (Object)chunk);
            }
        });
        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> {
            if (WorldSummary.of((class_1937)world).isClient()) {
                WorldTerrainSummary.onChunkUnload((class_1937)world, chunk);
            }
        });
        ClientTickEvents.END_WORLD_TICK.register(world -> {
            if (class_310.method_1551().field_1769.method_3246() <= 10 || !class_310.method_1551().field_1769.method_3281()) {
                return;
            }
            for (class_2818 chunk : new HashSet(LOADING_CHUNKS.get((Object)world.method_27983()))) {
                WorldTerrainSummary.onChunkLoad((class_1937)world, chunk);
                ClientExploration.INSTANCE.addChunk((class_5321<class_1937>)world.method_27983(), chunk.method_12004());
                LOADING_CHUNKS.remove((Object)world.method_27983(), (Object)chunk);
            }
        });
        ClientTickEvents.END_WORLD_TICK.register(world -> {
            if (!SurveyorClientEvents.INITIALIZING_WORLD) {
                return;
            }
            if (class_310.method_1551().field_1724 != null && SurveyorClient.getExploration() != null) {
                SurveyorClientEvents.INITIALIZING_WORLD = false;
                if (WorldSummary.of((class_1937)world).isClient()) {
                    WorldSummary summary = WorldSummary.of((class_1937)world);
                    if (summary.terrain() != null && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SOLO)) {
                        new C2SKnownTerrainPacket(summary.terrain().bitSet(null)).send(world.method_30349());
                    }
                    if (summary.structures() != null && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.SOLO)) {
                        new C2SKnownStructuresPacket(summary.structures().keySet(null)).send(world.method_30349());
                    }
                    if (summary.landmarks() != null) {
                        summary.landmarks().clientInitialized((class_1937)world);
                    }
                }
                SurveyorClientEvents.Invoke.worldLoad(class_310.method_1551().field_1724.field_17892, class_310.method_1551().field_1724);
            }
        });
        SurveyorEvents.Register.landmarksAdded(Surveyor.id("client"), (world, worldLandmarks, landmarks) -> {
            SurveyorExploration exploration = SurveyorClient.getExploration();
            if (exploration != null) {
                SurveyorClientEvents.Invoke.landmarksAdded(world, exploration.limitLandmarkKeySet((class_5321<class_1937>)world.method_27983(), worldLandmarks, (Multimap<UUID, class_2960>)HashMultimap.create((Multimap)landmarks)));
            }
        });
        SurveyorEvents.Register.landmarksRemoved(Surveyor.id("client"), (world, summary, landmarks) -> SurveyorClientEvents.Invoke.landmarksRemoved(world, (Multimap<UUID, class_2960>)landmarks));
        Surveyor.LOGGER.info("[Surveyor Client] is not a map mod either");
    }

    public record ClientExploration(Set<UUID> groupPlayers, Map<class_5321<class_1937>, Map<RegionPos, BitSet>> terrain, Map<class_5321<class_1937>, Map<class_5321<class_3195>, LongSet>> structures) implements SurveyorExploration
    {
        public static final String KEY_SHARED = "shared";
        public static final ClientExploration INSTANCE = new ClientExploration(new HashSet<UUID>(), new HashMap<class_5321<class_1937>, Map<RegionPos, BitSet>>(), new HashMap<class_5321<class_1937>, Map<class_5321<class_3195>, LongSet>>());
        public static final ClientExploration SHARED = new ClientExploration(new HashSet<UUID>(), new HashMap<class_5321<class_1937>, Map<RegionPos, BitSet>>(), new HashMap<class_5321<class_1937>, Map<class_5321<class_3195>, LongSet>>());
        public static File saveFile = null;

        public static void onLoad() {
            if (WorldSummary.of((class_1937)class_310.method_1551().field_1687).isClient()) {
                saveFile = SurveyorClient.getSavePath((class_1937)class_310.method_1551().field_1687).toPath().resolve(SurveyorClient.getClientUuid().toString() + ".dat").toFile();
                class_2487 explorationNbt = new class_2487();
                if (saveFile.exists()) {
                    try {
                        explorationNbt = class_2507.method_30613((Path)saveFile.toPath(), (class_2505)class_2505.method_53898());
                    }
                    catch (IOException | class_8911 e) {
                        Surveyor.LOGGER.error("[Surveyor] Error loading client exploration file.", e);
                    }
                }
                INSTANCE.read(explorationNbt);
                SHARED.read(explorationNbt.method_10562(KEY_SHARED).orElse(new class_2487()));
            }
        }

        public static void onUnload() {
            if (saveFile != null) {
                try {
                    class_2487 nbt = INSTANCE.write(new class_2487());
                    class_2487 sharedNbt = SHARED.write(new class_2487());
                    nbt.method_10566(KEY_SHARED, (class_2520)sharedNbt);
                    class_2507.method_30614((class_2487)nbt, (Path)saveFile.toPath());
                }
                catch (IOException e) {
                    Surveyor.LOGGER.error("[Surveyor] Error saving client exploration file.", (Throwable)e);
                }
                saveFile = null;
            }
            ClientExploration.INSTANCE.terrain.clear();
            ClientExploration.INSTANCE.structures.clear();
            ClientExploration.INSTANCE.groupPlayers.clear();
            ClientExploration.SHARED.terrain.clear();
            ClientExploration.SHARED.structures.clear();
            ClientExploration.SHARED.groupPlayers.clear();
        }

        @Override
        public Set<UUID> sharedPlayers() {
            HashSet<UUID> sharedPlayers = new HashSet<UUID>();
            sharedPlayers.add(SurveyorClient.getClientUuid());
            sharedPlayers.addAll(this.groupPlayers);
            return sharedPlayers;
        }

        @Override
        public boolean personal() {
            return true;
        }

        @Override
        public void addStructure(class_5321<class_1937> worldKey, class_5321<class_3195> structureKey, class_1923 pos) {
            SurveyorExploration.super.addStructure(worldKey, structureKey, pos);
            this.updateClientForAddStructure((class_1937)class_310.method_1551().field_1687, structureKey, pos);
        }

        @Override
        public void mergeRegion(class_5321<class_1937> worldKey, RegionPos regionPos, BitSet bitSet) {
            SurveyorExploration.super.mergeRegion(worldKey, regionPos, bitSet);
            this.updateClientForMergeRegion((class_1937)class_310.method_1551().field_1687, regionPos, bitSet);
        }

        @Override
        public void addChunk(class_5321<class_1937> worldKey, class_1923 pos) {
            SurveyorExploration.super.addChunk(worldKey, pos);
            this.updateClientForAddChunk((class_1937)class_310.method_1551().field_1687, pos);
        }
    }
}

