/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.landmark.component;

import com.mojang.serialization.Codec;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.landmark.component.LandmarkComponentMap;
import folk.sisby.surveyor.landmark.component.LandmarkComponentType;
import folk.sisby.surveyor.util.RegionPos;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3620;
import net.minecraft.class_4538;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import net.minecraft.class_8942;
import net.minecraft.class_9334;

public class LandmarkComponentTypes {
    public static final LandmarkComponentType<class_2338> POS = LandmarkComponentTypes.register("pos", class_2338.field_25064, (T p) -> class_2561.method_43470((String)"[").method_10852((class_2561)class_2561.method_43470((String)p.method_23854()).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"]")));
    public static final LandmarkComponentType<class_2561> NAME = LandmarkComponentTypes.register("name", class_8824.field_46597, (T t) -> class_2561.method_43470((String)"\"").method_10852((class_2561)t.method_27661().method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"\"")));
    public static final LandmarkComponentType<List<class_2561>> LORE = LandmarkComponentTypes.register("lore", Codec.list((Codec)class_8824.field_46597), (T l) -> class_2564.method_36332((Collection)l, (class_2561)class_2561.method_43470((String)"\" | \""), t -> t.method_27661().method_27692(class_124.field_1060)));
    public static final LandmarkComponentType<Integer> COLOR = LandmarkComponentTypes.register("color", Codec.INT, (T i) -> class_2561.method_43470((String)"#").method_10862(class_2583.field_24360.method_36139(0xFFFFFF & i)).method_10852((class_2561)class_2561.method_43470((String)Integer.toHexString(0xFFFFFF & i).toUpperCase()).method_27692(class_124.field_1065)));
    public static final LandmarkComponentType<Long> TIME = LandmarkComponentTypes.register("time", Codec.LONG, (T tick) -> class_2561.method_30163((String)"Day %d, %d:%02d".formatted(1L + tick / 24000L, (6000L + tick) % 24000L / 1000L, tick % 1000L > 500L ? 30 : 0)));
    public static final LandmarkComponentType<Integer> SEED = LandmarkComponentTypes.register("seed", Codec.INT, (T i) -> class_2561.method_43470((String)String.valueOf(i)).method_27692(class_124.field_1065));
    public static final LandmarkComponentType<class_3341> BOX = LandmarkComponentTypes.register("box", class_3341.field_29325, (T b) -> class_2561.method_43470((String)"[").method_10852((class_2561)class_2561.method_43470((String)new class_2338(b.method_35415(), b.method_35416(), b.method_35417()).method_23854()).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"]->[")).method_10852((class_2561)class_2561.method_43470((String)new class_2338(b.method_35418(), b.method_35419(), b.method_35420()).method_23854()).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"]")));
    public static final LandmarkComponentType<class_1799> STACK = LandmarkComponentTypes.register("stack", class_1799.field_24671, (T s) -> class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"[")).method_10852((class_2561)s.method_7909().method_63680().method_27661().method_27692(s.method_7932().method_58413())).method_10852((class_2561)class_2561.method_43470((String)"]")).method_10852((class_2561)(s.method_57826(class_9334.field_49631) ? class_2561.method_43470((String)" - \"").method_10852((class_2561)s.method_7964().method_27661().method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"\"")) : class_2561.method_43470((String)""))));
    public static final LandmarkComponentType<Map<RegionPos, BitSet>> CHUNKS = LandmarkComponentTypes.register("chunks", Codec.unboundedMap(RegionPos.CODEC, (Codec)class_5699.field_40724), (T m) -> class_2561.method_43470((String)"%d chunks".formatted(m.values().stream().mapToInt(BitSet::cardinality).sum())).method_27694(s -> s.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)RegionPos.regionsToChunks(m).stream().map(class_1923::toString).collect(Collectors.joining(", ")))))));

    public static LandmarkComponentMap.Builder forBlock(LandmarkComponentMap.Builder builder, class_1936 world, class_2338 pos) {
        int color;
        class_2680 state = world.method_8320(pos);
        class_1799 stack = state.method_26204().method_9574((class_4538)world, pos, world.method_8320(pos), true);
        class_2586 entity = world.method_8321(pos);
        if (entity != null && class_7923.field_41181.method_29113((Object)entity.method_11017()).map(t -> Surveyor.CONFIG.builtins.allowedBlockEntities.contains(t.toString())).orElse(false).booleanValue()) {
            try (class_8942.class_11340 logging = new class_8942.class_11340(entity.method_71402(), Surveyor.LOGGER);){
                class_11362 nbtWriteView = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)world.method_30349());
                entity.method_71400((class_11372)nbtWriteView);
                class_1747.method_57338((class_1799)stack, (class_2591)entity.method_11017(), (class_11362)nbtWriteView);
            }
        }
        builder.add(NAME, !stack.method_7960() ? stack.method_7964() : state.method_26204().method_9518());
        if (!stack.method_7960()) {
            builder.add(STACK, stack);
        }
        if ((color = state.method_26205((class_1922)world, pos).method_15820(class_3620.class_6594.field_34761)) != 0) {
            builder.add(COLOR, color);
        }
        builder.add(POS, pos);
        return builder;
    }

    private static <T> LandmarkComponentType<T> register(String path, Codec<T> codec, Function<T, class_2561> viewer) {
        return LandmarkComponentTypes.register(Surveyor.id(path), codec, viewer);
    }

    public static <T> LandmarkComponentType<T> register(class_2960 id, Codec<T> codec, Function<T, class_2561> viewer) {
        LandmarkComponentType<T> type = new LandmarkComponentType<T>(id, codec, viewer);
        LandmarkComponentType.register(type);
        return type;
    }

    public static void touch() {
    }
}

