/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.packet.SurveyorPacket;
import folk.sisby.surveyor.packet.SurveyorPacketCodecs;
import folk.sisby.surveyor.packet.SyncPacket;
import folk.sisby.surveyor.util.MapUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record SyncLandmarksAddedPacket(Map<UUID, Map<class_2960, Landmark>> landmarks) implements SyncPacket
{
    public static final class_8710.class_9154<SyncLandmarksAddedPacket> ID = new class_8710.class_9154(Surveyor.id("landmarks_added"));
    public static final class_9139<ByteBuf, SyncLandmarksAddedPacket> CODEC = SurveyorPacketCodecs.LANDMARK_SUMMARIES.method_56432(SyncLandmarksAddedPacket::new, SyncLandmarksAddedPacket::landmarks);

    public static SyncLandmarksAddedPacket of(Multimap<UUID, class_2960> keySet, WorldLandmarks summary) {
        return summary.createUpdatePacket(keySet);
    }

    @Override
    public List<SurveyorPacket> toPayloads(class_5455 registryManager) {
        ArrayList<SurveyorPacket> payloads = new ArrayList<SurveyorPacket>();
        class_9129 buf = new class_9129((ByteBuf)new class_2540(Unpooled.buffer()), registryManager);
        CODEC.encode((Object)buf, (Object)this);
        if (buf.readableBytes() < 0x100000) {
            payloads.add(this);
        } else {
            Multimap<UUID, class_2960> keySet = MapUtil.keyMultiMap(this.landmarks);
            if (keySet.size() == 1) {
                Surveyor.LOGGER.error("Couldn't create a landmark update packet for {} at {} - an individual landmark would be too large to send!", keySet.keys().stream().findFirst().orElseThrow(), keySet.values().stream().findFirst().orElseThrow());
                return List.of();
            }
            HashMultimap firstHalf = HashMultimap.create();
            HashMultimap secondHalf = HashMultimap.create();
            keySet.forEach((arg_0, arg_1) -> SyncLandmarksAddedPacket.lambda$toPayloads$0((Multimap)firstHalf, keySet, (Multimap)secondHalf, arg_0, arg_1));
            payloads.addAll(new SyncLandmarksAddedPacket(MapUtil.splitByKeyMap(this.landmarks, firstHalf)).toPayloads(registryManager));
            payloads.addAll(new SyncLandmarksAddedPacket(MapUtil.splitByKeyMap(this.landmarks, secondHalf)).toPayloads(registryManager));
        }
        return payloads;
    }

    public class_8710.class_9154<SyncLandmarksAddedPacket> method_56479() {
        return ID;
    }

    private static /* synthetic */ void lambda$toPayloads$0(Multimap firstHalf, Multimap keySet, Multimap secondHalf, UUID key, class_2960 pos) {
        if (firstHalf.size() < keySet.size() / 2) {
            firstHalf.put((Object)key, (Object)pos);
        } else {
            secondHalf.put((Object)key, (Object)pos);
        }
    }
}

