/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.structure;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.structure.JigsawPieceSummary;
import folk.sisby.surveyor.structure.RegionStructureSummary;
import folk.sisby.surveyor.structure.StructurePieceSummary;
import folk.sisby.surveyor.structure.StructureStartSummary;
import folk.sisby.surveyor.util.ChunkUtil;
import folk.sisby.surveyor.util.MapUtil;
import folk.sisby.surveyor.util.RegionPos;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_3773;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7151;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8911;

public class WorldStructureSummary {
    public static final String KEY_STRUCTURES = "structures";
    public static final String KEY_TYPE = "type";
    public static final String KEY_TAGS = "tags";
    protected final class_5321<class_1937> worldKey;
    protected final Map<RegionPos, RegionStructureSummary> regions = new ConcurrentHashMap<RegionPos, RegionStructureSummary>();
    protected final Map<class_5321<class_3195>, class_5321<class_7151<?>>> structureTypes = new ConcurrentHashMap();
    protected final Multimap<class_5321<class_3195>, class_6862<class_3195>> structureTags = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    protected boolean dirty = false;

    public WorldStructureSummary(class_5321<class_1937> worldKey, Map<RegionPos, RegionStructureSummary> regions, Map<class_5321<class_3195>, class_5321<class_7151<?>>> structureTypes, Multimap<class_5321<class_3195>, class_6862<class_3195>> structureTags) {
        this.worldKey = worldKey;
        this.regions.putAll(regions);
        this.structureTypes.putAll(structureTypes);
        this.structureTags.putAll(structureTags);
    }

    public static StructurePieceSummary readStructurePieceNbt(class_2487 nbt) {
        if (nbt.method_10558("id").equals(class_7923.field_41146.method_10221((Object)class_3773.field_25840).toString())) {
            return new JigsawPieceSummary(nbt);
        }
        return new StructurePieceSummary(nbt);
    }

    protected static WorldStructureSummary readNbt(class_5321<class_1937> worldKey, class_2487 nbt, Map<RegionPos, RegionStructureSummary> regions) {
        ConcurrentHashMap structureTypes = new ConcurrentHashMap();
        HashMultimap structureTags = HashMultimap.create();
        class_2487 structuresCompound = nbt.method_10562(KEY_STRUCTURES);
        for (String structureId : structuresCompound.method_10541()) {
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60654((String)structureId));
            class_2487 structureCompound = structuresCompound.method_10562(structureId);
            class_5321 type = class_5321.method_29179((class_5321)class_7924.field_41231, (class_2960)class_2960.method_60654((String)structureCompound.method_10558(KEY_TYPE)));
            structureTypes.put((class_5321<class_3195>)key, type);
            List<class_6862> tags = structureCompound.method_10554(KEY_TAGS, 8).stream().map(e -> class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60654((String)e.method_10714()))).toList();
            structureTags.putAll((Object)key, tags);
        }
        for (RegionStructureSummary region : regions.values()) {
            region.structures.keySet().removeIf(k -> !structureTypes.containsKey(k));
        }
        return new WorldStructureSummary(worldKey, regions, structureTypes, (Multimap<class_5321<class_3195>, class_6862<class_3195>>)structureTags);
    }

    public static WorldStructureSummary load(class_1937 world, File folder) {
        File structuresFile = new File(folder, "structures.dat");
        class_2487 worldNbt = new class_2487();
        if (structuresFile.exists()) {
            try {
                worldNbt = class_2507.method_30613((Path)structuresFile.toPath(), (class_2505)class_2505.method_53898());
            }
            catch (IOException | class_8911 e) {
                Surveyor.LOGGER.error("[Surveyor] Error loading structure summary file for {}.", (Object)world.method_27983().method_29177(), (Object)e);
            }
        }
        HashMap<RegionPos, RegionStructureSummary> regions = new HashMap<RegionPos, RegionStructureSummary>();
        ChunkUtil.getRegionNbt(folder, "s").forEach((pos, nbt) -> regions.put((RegionPos)pos, RegionStructureSummary.readNbt(nbt)));
        if (regions.isEmpty()) {
            RegionStructureSummary worldSummary = RegionStructureSummary.readNbt(worldNbt);
            worldSummary.structures.forEach((key, map) -> map.forEach((pos, start) -> {
                RegionPos rPos = RegionPos.of(pos);
                regions.computeIfAbsent(rPos, k -> new RegionStructureSummary()).put((class_5321<class_3195>)key, (class_1923)pos, (StructureStartSummary)start);
            }));
        }
        return WorldStructureSummary.readNbt((class_5321<class_1937>)world.method_27983(), worldNbt, regions);
    }

    public static void onChunkLoad(class_3218 world, class_2818 chunk) {
        WorldStructureSummary structures = WorldSummary.of((class_1937)world).structures();
        chunk.method_12016().forEach((structure, start) -> {
            if (structures != null && !structures.contains((class_1937)world, (class_3449)start)) {
                structures.put(world, (class_3449)start);
            }
        });
    }

    public static void onStructurePlace(class_3218 world, class_3449 start) {
        WorldStructureSummary structures = WorldSummary.of((class_1937)world).structures();
        if (structures != null && !structures.contains((class_1937)world, start)) {
            structures.put(world, start);
        }
    }

    public class_5321<class_7151<?>> getType(class_5321<class_3195> key) {
        return this.structureTypes.get(key);
    }

    public Collection<class_6862<class_3195>> getTags(class_5321<class_3195> key) {
        return this.structureTags.get(key);
    }

    public boolean contains(class_1937 world, class_3449 start) {
        RegionPos rPos = RegionPos.of(start.method_34000());
        return this.regions.containsKey(rPos) && this.regions.get(rPos).contains(world, start);
    }

    public boolean contains(class_5321<class_3195> key, class_1923 pos) {
        RegionPos rPos = RegionPos.of(pos);
        return this.regions.containsKey(rPos) && this.regions.get(rPos).contains(key, pos);
    }

    public StructureStartSummary get(class_5321<class_3195> key, class_1923 pos) {
        RegionPos rPos = RegionPos.of(pos);
        return this.regions.containsKey(rPos) ? this.regions.get(rPos).get(key, pos) : null;
    }

    public Map<class_5321<class_3195>, Map<class_1923, StructureStartSummary>> asMap(SurveyorExploration exploration) {
        Multimap<class_5321<class_3195>, class_1923> keySet = this.keySet(exploration);
        HashMap<class_5321<class_3195>, Map<class_1923, StructureStartSummary>> map = new HashMap<class_5321<class_3195>, Map<class_1923, StructureStartSummary>>();
        keySet.forEach((key, pos) -> map.computeIfAbsent((class_5321<class_3195>)key, k -> new HashMap()).put(pos, this.get((class_5321<class_3195>)key, (class_1923)pos)));
        return map;
    }

    public Multimap<class_5321<class_3195>, class_1923> keySet(SurveyorExploration exploration) {
        HashMultimap map = HashMultimap.create();
        this.regions.values().forEach(arg_0 -> WorldStructureSummary.lambda$keySet$9((Multimap)map, arg_0));
        if (exploration != null) {
            exploration.limitStructureKeySet(this.worldKey, (Multimap<class_5321<class_3195>, class_1923>)map);
        }
        return map;
    }

    public void put(class_3218 world, class_3449 start) {
        if (Surveyor.CONFIG.structures == SystemMode.FROZEN) {
            return;
        }
        RegionPos rPos = RegionPos.of(start.method_34000());
        class_5321 key = (class_5321)world.method_30349().method_30530(class_7924.field_41246).method_29113((Object)start.method_16656()).orElseThrow();
        Optional type = world.method_30349().method_30530(class_7924.field_41231).method_29113((Object)start.method_16656().method_41618());
        if (!start.method_16657()) {
            Surveyor.LOGGER.error("Cowardly refusing to save structure {} as it has no pieces! Report this to the structure mod author!", (Object)key.method_29177());
            return;
        }
        if (type.isEmpty()) {
            Surveyor.LOGGER.error("Cowardly refusing to save structure {} as it has no structure type! Report this to the structure mod author!", (Object)key.method_29177());
            return;
        }
        this.regions.computeIfAbsent(rPos, k -> new RegionStructureSummary()).put(world, start);
        List tags = world.method_30349().method_30530(class_7924.field_41246).method_47983((Object)start.method_16656()).method_40228().toList();
        this.structureTypes.put((class_5321<class_3195>)key, (class_5321)type.orElseThrow());
        this.structureTags.putAll((Object)key, tags);
        this.dirty();
        SurveyorEvents.Invoke.structuresAdded((class_1937)world, (class_5321<class_3195>)key, start.method_34000());
    }

    public void put(class_1937 world, class_5321<class_3195> key, class_1923 pos, StructureStartSummary summary, class_5321<class_7151<?>> type, Collection<class_6862<class_3195>> tagKeys) {
        if (Surveyor.CONFIG.structures == SystemMode.FROZEN) {
            return;
        }
        RegionPos rPos = RegionPos.of(pos);
        this.regions.computeIfAbsent(rPos, k -> new RegionStructureSummary()).put(key, pos, summary);
        this.structureTypes.put(key, type);
        this.structureTags.putAll(key, tagKeys);
        this.dirty();
        SurveyorEvents.Invoke.structuresAdded(world, key, pos);
    }

    protected class_2487 writeNbt(class_2487 nbt) {
        class_2487 structuresCompound = new class_2487();
        this.structureTypes.forEach((key, starts) -> {
            class_2487 structureCompound = new class_2487();
            structureCompound.method_10582(KEY_TYPE, this.structureTypes.get(key).method_29177().toString());
            structureCompound.method_10566(KEY_TAGS, (class_2520)new class_2499(this.structureTags.get(key).stream().map(t -> class_2519.method_23256((String)t.comp_327().toString())).toList(), 8));
            structuresCompound.method_10566(key.method_29177().toString(), (class_2520)structureCompound);
        });
        nbt.method_10566(KEY_STRUCTURES, (class_2520)structuresCompound);
        return nbt;
    }

    public int save(class_1937 world, File folder) {
        ArrayList savedRegions = new ArrayList();
        if (this.isDirty()) {
            File structureFile = new File(folder, "structures.dat");
            class_2487 structureCompound = this.writeNbt(new class_2487());
            class_156.method_27958().execute(() -> {
                try {
                    class_2507.method_30614((class_2487)structureCompound, (Path)structureFile.toPath());
                }
                catch (IOException e) {
                    Surveyor.LOGGER.error("[Surveyor] Error writing world structure summary file for {}.", (Object)world.method_27983().method_29177(), (Object)e);
                }
            });
            this.dirty = false;
            this.regions.forEach((pos, summary) -> {
                if (!summary.isDirty()) {
                    return;
                }
                savedRegions.add(pos);
                class_2487 regionCompound = summary.writeNbt(new class_2487());
                File regionFile = new File(folder, "s.%d.%d.dat".formatted(pos.x(), pos.z()));
                class_156.method_27958().execute(() -> {
                    try {
                        class_2507.method_30614((class_2487)regionCompound, (Path)regionFile.toPath());
                    }
                    catch (IOException e) {
                        Surveyor.LOGGER.error("[Surveyor] Error writing region structure summary file {}.", (Object)regionFile.getName(), (Object)e);
                    }
                });
                summary.dirty = false;
            });
        }
        return savedRegions.size();
    }

    public Multimap<class_5321<class_3195>, class_1923> readUpdatePacket(class_1937 world, S2CStructuresAddedPacket packet) {
        if (Surveyor.CONFIG.structures == SystemMode.FROZEN) {
            return HashMultimap.create();
        }
        packet.structures().forEach((key, map) -> map.forEach((pos, start) -> this.put(world, (class_5321<class_3195>)key, (class_1923)pos, (StructureStartSummary)start, packet.types().get(key), packet.tags().get(key))));
        return MapUtil.keyMultiMap(packet.structures());
    }

    public S2CStructuresAddedPacket createUpdatePacket(boolean shared, Multimap<class_5321<class_3195>, class_1923> keySet) {
        HashMap<class_5321<class_3195>, Map<class_1923, StructureStartSummary>> packetStructures = new HashMap<class_5321<class_3195>, Map<class_1923, StructureStartSummary>>();
        HashMap packetTypes = new HashMap();
        HashMultimap packetTags = HashMultimap.create();
        keySet.forEach((key, pos) -> packetStructures.computeIfAbsent((class_5321<class_3195>)key, k -> new HashMap()).put(pos, this.get((class_5321<class_3195>)key, (class_1923)pos)));
        for (class_5321 key2 : keySet.keySet()) {
            packetTypes.put((class_5321<class_3195>)key2, this.getType((class_5321<class_3195>)key2));
            packetTags.putAll((Object)key2, this.getTags((class_5321<class_3195>)key2));
        }
        return new S2CStructuresAddedPacket(shared, packetStructures, packetTypes, (Multimap<class_5321<class_3195>, class_6862<class_3195>>)packetTags);
    }

    public boolean isDirty() {
        return (this.dirty || this.regions.values().stream().anyMatch(RegionStructureSummary::isDirty)) && Surveyor.CONFIG.structures != SystemMode.FROZEN;
    }

    private void dirty() {
        this.dirty = true;
    }

    private static /* synthetic */ void lambda$keySet$9(Multimap map, RegionStructureSummary r) {
        map.putAll(r.keySet());
    }
}

