/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.util;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record RegionPos(int x, int z) {
    public static final Codec<RegionPos> CODEC = Codec.STRING.xmap(RegionPos::of, RegionPos::toString);
    public static final class_9139<ByteBuf, RegionPos> PACKET_CODEC = class_9135.field_48551.method_56432(RegionPos::of, RegionPos::toLong);
    public static final int CHUNK_POWER = 5;
    public static final int CHUNK_SIZE = 32;
    public static final int CHUNK_AREA = 1024;
    public static final int BLOCK_POWER = 9;
    public static final int BLOCK_SIZE = 512;
    public static final int BLOCK_AREA = 262144;

    public static int regionRelative(int xz) {
        return xz & 0x1F;
    }

    public static int regionToChunk(int xz) {
        return xz << 5;
    }

    public static int chunkToRegion(int xz) {
        return xz >> 5;
    }

    public static int regionToBlock(int xz) {
        return xz << 9;
    }

    public static int blockToRegion(int xz) {
        return xz >> 9;
    }

    public static int chunkToBit(int relativeChunkX, int relativeChunkZ) {
        return (relativeChunkX << 5) + relativeChunkZ;
    }

    public static int chunkToBit(class_1923 pos) {
        return RegionPos.chunkToBit(RegionPos.regionRelative(pos.field_9181), RegionPos.regionRelative(pos.field_9180));
    }

    public static int bitToX(int bit) {
        return bit >> 5;
    }

    public static int bitToZ(int bit) {
        return bit & 0x1F;
    }

    public static RegionPos of(class_2338 pos) {
        return new RegionPos(RegionPos.blockToRegion(pos.method_10263()), RegionPos.blockToRegion(pos.method_10260()));
    }

    public static RegionPos of(class_1923 pos) {
        return new RegionPos(RegionPos.chunkToRegion(pos.field_9181), RegionPos.chunkToRegion(pos.field_9180));
    }

    public static RegionPos of(long pos) {
        return new RegionPos((int)pos, (int)(pos >> 32));
    }

    public static RegionPos of(String pos) {
        return new RegionPos(Integer.parseInt(pos.split(",")[0]), Integer.parseInt(pos.split(",")[1]));
    }

    @Override
    @NotNull
    public String toString() {
        return this.x + "," + this.z;
    }

    public int chunkX() {
        return RegionPos.regionToChunk(this.x);
    }

    public int chunkZ() {
        return RegionPos.regionToChunk(this.z);
    }

    public int blockX() {
        return RegionPos.regionToBlock(this.x);
    }

    public int blockZ() {
        return RegionPos.regionToBlock(this.z);
    }

    public long toLong() {
        return class_1923.method_8331((int)this.x, (int)this.z);
    }

    public class_1923 toChunk() {
        return new class_1923(this.chunkX(), this.chunkZ());
    }

    public class_2338 toBlock(int y) {
        return new class_2338(this.blockX(), y, this.blockZ());
    }

    public class_1923 toChunk(int relativeChunkX, int relativeChunkZ) {
        return new class_1923(this.chunkX() + relativeChunkX, this.chunkZ() + relativeChunkZ);
    }

    public class_1923 toChunk(int bit) {
        return this.toChunk(RegionPos.bitToX(bit), RegionPos.bitToZ(bit));
    }

    public Set<class_1923> toChunks(BitSet bits) {
        return bits.stream().mapToObj(this::toChunk).collect(Collectors.toSet());
    }

    public Set<class_1923> toChunks() {
        return IntStream.range(0, 256).mapToObj(this::toChunk).collect(Collectors.toSet());
    }

    public void forXZ(BiConsumer<Integer, Integer> action) {
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                action.accept(x, z);
            }
        }
    }

    public static Map<RegionPos, BitSet> chunksToRegions(Iterable<class_1923> chunks) {
        LinkedHashMap<RegionPos, BitSet> map = new LinkedHashMap<RegionPos, BitSet>();
        chunks.forEach(chunk -> map.computeIfAbsent(RegionPos.of(chunk), r -> new BitSet(1024)).set(RegionPos.chunkToBit(chunk)));
        return map;
    }

    public static Set<class_1923> regionsToChunks(Map<RegionPos, BitSet> chunks) {
        LinkedHashSet<class_1923> outSet = new LinkedHashSet<class_1923>();
        chunks.entrySet().stream().flatMap(e -> ((RegionPos)e.getKey()).toChunks((BitSet)e.getValue()).stream()).forEach(outSet::add);
        return outSet;
    }
}

